/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.animation.D2;

import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.rmi.RemoteException;
import java.util.ArrayList;
import nl.tudelft.simulation.dsol.animation.D2.Renderable2DInterface;
import nl.tudelft.simulation.dsol.animation.Locatable;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.dsol.swing.animation.D2.AnimationPanel;
import nl.tudelft.simulation.dsol.swing.animation.D2.InputListener;
import nl.tudelft.simulation.dsol.swing.gui.animation.panel.SearchPanel;
import nl.tudelft.simulation.language.DSOLException;
import org.djutils.draw.bounds.Bounds2d;
import org.djutils.draw.point.Point;
import org.djutils.draw.point.Point2d;
import org.djutils.event.Event;
import org.djutils.logger.CategoryLogger;

public class AutoPanAnimationPanel
extends AnimationPanel {
    private static final long serialVersionUID = 20180430L;
    private Object lastFollowedObject;
    private String autoPanId = null;
    private SearchPanel.ObjectKind<?> autoPanKind = null;
    private boolean autoPanTrack = false;
    private boolean autoPanOnNextPaintComponent = false;

    public AutoPanAnimationPanel(Bounds2d homeExtent, SimulatorInterface<?> simulator) throws RemoteException, DSOLException {
        super(homeExtent, simulator);
        MouseWheelListener[] wheelListeners;
        MouseListener[] listeners;
        for (MouseListener listener : listeners = this.getMouseListeners()) {
            this.removeMouseListener(listener);
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object searchedObject;
                if (e.isControlDown() && (searchedObject = AutoPanAnimationPanel.this.getSelectedObject(e.getPoint())) != null) {
                    e.consume();
                }
                e.consume();
            }
        });
        for (MouseListener listener : listeners) {
            this.addMouseListener(listener);
        }
        for (MouseWheelListener wheelListener : wheelListeners = this.getMouseWheelListeners()) {
            this.removeMouseWheelListener(wheelListener);
        }
        this.addMouseWheelListener(new InputListener(this){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                super.mouseWheelMoved(e);
            }
        });
    }

    protected Object getSelectedObject(Point2D mousePoint) {
        ArrayList<Locatable> targets = new ArrayList<Locatable>();
        Point2d point = this.getRenderableScale().getWorldCoordinates(mousePoint, this.getExtent(), this.getSize());
        for (Renderable2DInterface renderable2DInterface : this.getElements()) {
            if (!this.isShowElement((Renderable2DInterface<? extends Locatable>)renderable2DInterface) || !renderable2DInterface.contains(point, this.getExtent())) continue;
            targets.add(renderable2DInterface.getSource());
        }
        if (targets.size() == 1) {
            return targets.get(0);
        }
        return null;
    }

    public void setAutoPan(String newAutoPanId, SearchPanel.ObjectKind<?> newAutoPanKind, boolean newAutoPanTrack) {
        this.autoPanId = newAutoPanId;
        this.autoPanKind = newAutoPanKind;
        this.autoPanTrack = newAutoPanTrack;
        this.autoPanOnNextPaintComponent = true;
        if (null != this.autoPanId && this.autoPanId.length() > 0 && null != this.autoPanKind) {
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Object locatable;
        if (this.autoPanTrack && this.autoPanKind != null && this.autoPanId != null && null != (locatable = this.autoPanKind.searchObject(this.autoPanId))) {
            try {
                Point point = locatable.getLocation();
                if (point != null) {
                    double w = this.getExtent().getDeltaX();
                    double h = this.getExtent().getDeltaY();
                    this.setExtent(new Bounds2d(point.getX() - w / 2.0, point.getX() + w / 2.0, point.getY() - h / 2.0, point.getY() + h / 2.0));
                }
            }
            catch (RemoteException exception) {
                CategoryLogger.always().warn("Caught RemoteException trying to locate {} with id {}.", new Object[]{this.autoPanKind, this.autoPanId});
                return;
            }
        }
        super.paintComponent(g);
    }

    @Override
    public void notify(Event event) throws RemoteException {
        if (event.getType().equals((Object)SearchPanel.ANIMATION_SEARCH_OBJECT_EVENT)) {
            Object[] content = (Object[])event.getContent();
            this.autoPanKind = (SearchPanel.ObjectKind)content[0];
            this.autoPanId = (String)content[1];
            this.autoPanTrack = (Boolean)content[2];
        }
        super.notify(event);
    }

    @Override
    public String toString() {
        return "AutoAnimationPanel [lastPerson=" + this.lastFollowedObject + "]";
    }
}

