/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.animation.D2;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import nl.tudelft.simulation.dsol.swing.animation.D2.VisualizationPanel;
import nl.tudelft.simulation.dsol.swing.animation.D2.actions.PanDownAction;
import nl.tudelft.simulation.dsol.swing.animation.D2.actions.PanLeftAction;
import nl.tudelft.simulation.dsol.swing.animation.D2.actions.PanRightAction;
import nl.tudelft.simulation.dsol.swing.animation.D2.actions.PanUpAction;
import nl.tudelft.simulation.dsol.swing.introspection.gui.IntrospectionDialog;

public class InputListener
implements MouseListener,
MouseWheelListener,
MouseMotionListener,
KeyListener {
    private final VisualizationPanel panel;
    private Point2D mouseClicked = null;
    private long timeLastAnimationMouseMoveEvent;
    private long timeBetweenAnimationMouseMoveEventsMs = 10L;

    public InputListener(VisualizationPanel panel) {
        this.panel = panel;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object selected;
        this.panel.requestFocus();
        this.mouseClicked = e.getPoint();
        if (!e.isPopupTrigger() && !e.isConsumed() && (selected = this.panel.getSelectedObject(this.panel.getSelectedObjects(e.getPoint()))) != null) {
            new IntrospectionDialog(selected);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.panel.requestFocus();
        this.mouseClicked = e.getPoint();
        if (e.isPopupTrigger()) {
            this.panel.popup(e);
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.panel.popup(e);
        } else if (e.isShiftDown() || e.getButton() == 1) {
            this.panel.pan(this.mouseClicked, e.getPoint());
            this.panel.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int amount = e.getUnitsToScroll();
        if (amount > 0) {
            this.panel.zoom(1.2, e.getX(), e.getY());
        } else if (amount < 0) {
            this.panel.zoom(0.8333333333333334, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.isShiftDown()) {
            this.panel.setDragLine(e.getPoint(), this.mouseClicked);
        }
        this.panel.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        long time = System.currentTimeMillis();
        if (time - this.timeLastAnimationMouseMoveEvent > this.timeBetweenAnimationMouseMoveEventsMs) {
            this.panel.mouseMoved(mouseEvent.getPoint());
            this.timeLastAnimationMouseMoveEvent = time;
        }
    }

    public long getTimeBetweenAnimationMouseMoveEventsMs() {
        return this.timeBetweenAnimationMouseMoveEventsMs;
    }

    public void setTimeBetweenAnimationMouseMoveEventsMs(long timeBetweenAnimationMouseMoveEventsMs) {
        this.timeBetweenAnimationMouseMoveEventsMs = timeBetweenAnimationMouseMoveEventsMs;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 37: {
                new PanLeftAction(this.panel).actionPerformed(new ActionEvent(this, 0, "LEFT"));
                break;
            }
            case 39: {
                new PanRightAction(this.panel).actionPerformed(new ActionEvent(this, 0, "RIGHT"));
                break;
            }
            case 38: {
                new PanUpAction(this.panel).actionPerformed(new ActionEvent(this, 0, "UP"));
                break;
            }
            case 40: {
                new PanDownAction(this.panel).actionPerformed(new ActionEvent(this, 0, "DOWN"));
                break;
            }
            case 45: {
                this.panel.zoom(1.2, this.panel.getWidth() / 2, this.panel.getHeight() / 2);
                break;
            }
            case 521: {
                this.panel.zoom(0.8333333333333334, this.panel.getWidth() / 2, this.panel.getHeight() / 2);
                break;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

