/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.animation.D2;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.naming.NamingException;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import nl.tudelft.simulation.dsol.animation.D2.Renderable2DComparator;
import nl.tudelft.simulation.dsol.animation.D2.Renderable2DInterface;
import nl.tudelft.simulation.dsol.animation.D2.RenderableScale;
import nl.tudelft.simulation.dsol.animation.Locatable;
import nl.tudelft.simulation.dsol.simulators.AnimatorInterface;
import nl.tudelft.simulation.dsol.swing.animation.D2.InputListener;
import nl.tudelft.simulation.dsol.swing.animation.D2.actions.IntrospectionAction;
import nl.tudelft.simulation.naming.context.ContextInterface;
import org.djutils.draw.bounds.Bounds;
import org.djutils.draw.bounds.Bounds2d;
import org.djutils.draw.point.Point;
import org.djutils.draw.point.Point2d;
import org.djutils.event.Event;
import org.djutils.event.EventListener;
import org.djutils.event.EventListenerMap;
import org.djutils.event.EventProducer;
import org.djutils.event.EventType;
import org.djutils.event.LocalEventProducer;
import org.djutils.event.reference.ReferenceType;
import org.djutils.logger.CategoryLogger;
import org.djutils.metadata.MetaData;
import org.djutils.metadata.ObjectDescriptor;

public class VisualizationPanel
extends JPanel
implements EventProducer,
EventListener {
    private static final long serialVersionUID = 20230305L;
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final double ZOOMFACTOR = 1.2;
    protected static final Color GRIDCOLOR = Color.BLACK;
    private Bounds2d extent = null;
    private Bounds2d homeExtent = null;
    protected boolean showGrid = true;
    protected double gridSizeX = 100.0;
    protected double gridSizeY = 100.0;
    protected NumberFormat formatter = NumberFormat.getInstance();
    protected Dimension lastDimension = null;
    protected Point2d worldCoordinate = new Point2d(0.0, 0.0);
    protected boolean showToolTip = true;
    private RenderableScale renderableScale;
    protected SortedSet<Renderable2DInterface<? extends Locatable>> elements = new TreeSet<Renderable2DInterface<? extends Locatable>>((Comparator<Renderable2DInterface<? extends Locatable>>)new Renderable2DComparator());
    protected Map<Class<? extends Locatable>, Boolean> visibilityMap = Collections.synchronizedMap(new LinkedHashMap());
    protected Set<Class<? extends Locatable>> hiddenClasses = new LinkedHashSet<Class<? extends Locatable>>();
    protected Set<Class<? extends Locatable>> shownClasses = new LinkedHashSet<Class<? extends Locatable>>();
    protected ContextInterface context = null;
    private int[] dragLine = new int[4];
    private boolean dragLineEnabled = false;
    protected List<Renderable2DInterface<? extends Locatable>> elementList = new ArrayList<Renderable2DInterface<? extends Locatable>>();
    private boolean dirty = false;
    private final AnimationEventProducer animationEventProducer;
    public static final double EXTENT_MARGIN_FACTOR = 0.05;
    public static final EventType ANIMATION_MOUSE_CLICK_EVENT = new EventType(new MetaData("ANIMATION_MOUSE_CLICK_EVENT", "ANIMATION_MOUSE_CLICK_EVENT", new ObjectDescriptor[]{new ObjectDescriptor("worldCoordinate", "x and y position in world coordinates", Point2d.class), new ObjectDescriptor("screenCoordinate", "x and y position in screen coordinates", java.awt.Point.class), new ObjectDescriptor("shiftCtrlAlt", "shift[0], ctrl[1], and/or alt[2] pressed", boolean[].class), new ObjectDescriptor("objectList", "List of objects whose bounding box includes the coordinate", List.class)}));
    public static final EventType ANIMATION_MOUSE_POPUP_EVENT = new EventType(new MetaData("ANIMATION_MOUSE_POPUP_EVENT", "ANIMATION_MOUSE_POPUP_EVENT", new ObjectDescriptor[]{new ObjectDescriptor("worldCoordinate", "x and y position in world coordinates", Point2d.class), new ObjectDescriptor("screenCoordinate", "x and y position in screen coordinates", java.awt.Point.class), new ObjectDescriptor("shiftCtrlAlt", "shift[0], ctrl[1], and/or alt[2] pressed", boolean[].class), new ObjectDescriptor("object", "Selected object whose bounding box includes the coordinate", Object.class)}));

    public VisualizationPanel(Bounds2d homeExtent, EventProducer producer) throws RemoteException {
        this.setPreferredSize(new Dimension(1024, 768));
        this.animationEventProducer = new AnimationEventProducer();
        this.showGrid = true;
        InputListener listener = new InputListener(this);
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.addMouseWheelListener(listener);
        this.addKeyListener(listener);
        this.renderableScale = new RenderableScale();
        this.homeExtent = homeExtent;
        this.setBackground(Color.WHITE);
        this.lastDimension = this.getSize();
        this.setExtent(homeExtent);
        producer.addListener((EventListener)this, AnimatorInterface.UPDATE_ANIMATION_EVENT);
    }

    public VisualizationPanel(Bounds2d homeExtent, EventProducer producer, ContextInterface context) throws RemoteException, NamingException {
        this(homeExtent, producer);
        this.context = context.createSubcontext("animation/2D");
        this.subscribeToContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        super.paintComponent(g);
        if (!this.getSize().equals(this.lastDimension)) {
            this.lastDimension = this.getSize();
            this.setExtent(this.renderableScale.computeVisibleExtent(this.extent, this.getSize()));
        }
        if (this.showGrid) {
            this.drawGrid(g);
        }
        if (this.dirty) {
            List<Renderable2DInterface<? extends Locatable>> list = this.elementList;
            synchronized (list) {
                this.elementList.clear();
                this.elementList.addAll(this.elements);
                this.dirty = false;
            }
        }
        for (Renderable2DInterface renderable2DInterface : this.elementList) {
            if (renderable2DInterface.getSource() == null) {
                this.objectRemoved((Renderable2DInterface<? extends Locatable>)renderable2DInterface);
                continue;
            }
            if (!this.isShowElement((Renderable2DInterface<? extends Locatable>)renderable2DInterface)) continue;
            renderable2DInterface.paintComponent(g2, this.getExtent(), this.getSize(), this.getRenderableScale(), (ImageObserver)this);
        }
        if (this.dragLineEnabled) {
            g.setColor(Color.BLACK);
            g.drawLine(this.dragLine[0], this.dragLine[1], this.dragLine[2], this.dragLine[3]);
            this.dragLineEnabled = false;
        }
    }

    public boolean isShowElement(Renderable2DInterface<? extends Locatable> element) {
        return element.getSource() == null ? false : this.isShowClass(element.getSource().getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShowClass(Class<? extends Locatable> locatableClass) {
        if (this.hiddenClasses.contains(locatableClass)) {
            return false;
        }
        boolean show = true;
        if (!this.shownClasses.contains(locatableClass)) {
            Map<Class<? extends Locatable>, Boolean> map = this.visibilityMap;
            synchronized (map) {
                for (Class<? extends Locatable> lc : this.visibilityMap.keySet()) {
                    if (!lc.isAssignableFrom(locatableClass) || this.visibilityMap.get(lc).booleanValue()) continue;
                    show = false;
                }
                if (show) {
                    this.shownClasses.add(locatableClass);
                } else {
                    this.hiddenClasses.add(locatableClass);
                }
            }
        }
        return show;
    }

    protected void subscribeToContext() throws RemoteException {
        this.context.addListener((EventListener)this, ContextInterface.OBJECT_ADDED_EVENT);
        this.context.addListener((EventListener)this, ContextInterface.OBJECT_REMOVED_EVENT);
        for (Object element : this.context.values()) {
            if (element instanceof Renderable2DInterface) {
                this.objectAdded((Renderable2DInterface<? extends Locatable>)((Renderable2DInterface)element));
                continue;
            }
            System.err.println("odd object in context: " + element);
        }
        this.repaint();
    }

    public void notify(Event event) throws RemoteException {
        if (event.getType().equals((Object)AnimatorInterface.UPDATE_ANIMATION_EVENT) && this.isShowing()) {
            if (this.getWidth() > 0 || this.getHeight() > 0) {
                this.repaint();
            }
            return;
        }
        if (event.getType().equals((Object)ContextInterface.OBJECT_ADDED_EVENT)) {
            this.objectAdded((Renderable2DInterface<? extends Locatable>)((Renderable2DInterface)((Object[])event.getContent())[2]));
        } else if (event.getType().equals((Object)ContextInterface.OBJECT_REMOVED_EVENT)) {
            this.objectRemoved((Renderable2DInterface<? extends Locatable>)((Renderable2DInterface)((Object[])event.getContent())[2]));
        }
    }

    public Bounds2d getExtent() {
        return this.extent;
    }

    public void setExtent(Bounds2d extent) {
        this.extent = extent;
        this.repaint();
    }

    public synchronized void showGrid(boolean bool) {
        this.showGrid = bool;
        this.repaint();
    }

    public synchronized void setWorldCoordinate(Point2d point) {
        this.worldCoordinate = point;
    }

    public synchronized Point2d getWorldCoordinate() {
        return this.worldCoordinate;
    }

    public synchronized void displayWorldCoordinateToolTip() {
        if (this.showToolTip) {
            String worldPoint = "(x=" + this.formatter.format(this.worldCoordinate.getX()) + " ; y=" + this.formatter.format(this.worldCoordinate.getY()) + ")";
            this.setToolTipText(worldPoint);
        }
    }

    public synchronized boolean isShowToolTip() {
        return this.showToolTip;
    }

    public synchronized void setShowToolTip(boolean showToolTip) {
        this.showToolTip = showToolTip;
    }

    public synchronized void pan(int direction, double percentage) {
        if (percentage <= 0.0 || percentage > 1.0) {
            throw new IllegalArgumentException("percentage<=0 || >1.0");
        }
        switch (direction) {
            case 3: {
                this.setExtent(new Bounds2d(this.extent.getMinX() - percentage * this.extent.getDeltaX(), this.extent.getMaxX() - percentage * this.extent.getDeltaX(), this.extent.getMinY(), this.extent.getMaxY()));
                break;
            }
            case 4: {
                this.setExtent(new Bounds2d(this.extent.getMinX() + percentage * this.extent.getDeltaX(), this.extent.getMaxX() + percentage * this.extent.getDeltaX(), this.extent.getMinY(), this.extent.getMaxY()));
                break;
            }
            case 1: {
                this.setExtent(new Bounds2d(this.extent.getMinX(), this.extent.getMaxX(), this.extent.getMinY() + percentage * this.extent.getDeltaY(), this.extent.getMaxY() + percentage * this.extent.getDeltaY()));
                break;
            }
            case 2: {
                this.setExtent(new Bounds2d(this.extent.getMinX(), this.extent.getMaxX(), this.extent.getMinY() - percentage * this.extent.getDeltaY(), this.extent.getMaxY() - percentage * this.extent.getDeltaY()));
                break;
            }
            default: {
                throw new IllegalArgumentException("direction unkown");
            }
        }
    }

    public synchronized void home() {
        this.setExtent(this.renderableScale.computeVisibleExtent(this.homeExtent, this.getSize()));
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean showGrid) {
        this.showGrid = showGrid;
    }

    public synchronized void zoom(double factor) {
        this.zoom(factor, (int)((double)this.getWidth() / 2.0), (int)((double)this.getHeight() / 2.0));
    }

    public synchronized void zoom(double factor, int mouseX, int mouseY) {
        Point2d mwc = this.renderableScale.getWorldCoordinates((Point2D)new Point2D.Double(mouseX, mouseY), this.extent, this.getSize());
        double minX = mwc.getX() - (mwc.getX() - this.extent.getMinX()) * factor;
        double minY = mwc.getY() - (mwc.getY() - this.extent.getMinY()) * factor;
        double w = this.extent.getDeltaX() * factor;
        double h = this.extent.getDeltaY() * factor;
        this.setExtent(new Bounds2d(minX, minX + w, minY, minY + h));
    }

    protected synchronized void drawGrid(Graphics g) {
        int maximumNumberOfDigits;
        int maximumNumberOfDigits2;
        g.setFont(g.getFont().deriveFont(11.0f));
        g.setColor(GRIDCOLOR);
        double scaleX = this.renderableScale.getXScale(this.extent, this.getSize());
        double scaleY = this.renderableScale.getYScale(this.extent, this.getSize());
        int count = 0;
        int gridSizePixelsX = (int)Math.round(this.gridSizeX / scaleX);
        while (gridSizePixelsX < 40) {
            this.gridSizeX = 10.0 * this.gridSizeX;
            maximumNumberOfDigits2 = (int)Math.max(0.0, 1.0 + Math.ceil(Math.log(1.0 / this.gridSizeX) / Math.log(10.0)));
            this.formatter.setMaximumFractionDigits(maximumNumberOfDigits2);
            gridSizePixelsX = (int)Math.round(this.gridSizeX / scaleX);
            if (count++ <= 10) continue;
            break;
        }
        count = 0;
        while (gridSizePixelsX > 400) {
            maximumNumberOfDigits2 = (int)Math.max(0.0, 2.0 + Math.ceil(Math.log(1.0 / this.gridSizeX) / Math.log(10.0)));
            this.formatter.setMaximumFractionDigits(maximumNumberOfDigits2);
            this.gridSizeX /= 10.0;
            gridSizePixelsX = (int)Math.round(this.gridSizeX / scaleX);
            if (count++ <= 10) continue;
            break;
        }
        int gridSizePixelsY = (int)Math.round(this.gridSizeY / scaleY);
        while (gridSizePixelsY < 40) {
            this.gridSizeY = 10.0 * this.gridSizeY;
            maximumNumberOfDigits = (int)Math.max(0.0, 1.0 + Math.ceil(Math.log(1.0 / this.gridSizeY) / Math.log(10.0)));
            this.formatter.setMaximumFractionDigits(maximumNumberOfDigits);
            gridSizePixelsY = (int)Math.round(this.gridSizeY / scaleY);
            if (count++ <= 10) continue;
            break;
        }
        count = 0;
        while (gridSizePixelsY > 400) {
            maximumNumberOfDigits = (int)Math.max(0.0, 2.0 + Math.ceil(Math.log(1.0 / this.gridSizeY) / Math.log(10.0)));
            this.formatter.setMaximumFractionDigits(maximumNumberOfDigits);
            this.gridSizeY /= 10.0;
            gridSizePixelsY = (int)Math.round(this.gridSizeY / scaleY);
            if (count++ <= 10) continue;
            break;
        }
        double mod = this.extent.getMinX() % this.gridSizeX;
        for (int x = (int)(-Math.round(mod / scaleX)); x < this.getWidth(); x += gridSizePixelsX) {
            Point2d point = this.renderableScale.getWorldCoordinates((Point2D)new Point2D.Double(x, 0.0), this.extent, this.getSize());
            if (point == null) continue;
            String label = this.formatter.format((double)Math.round(point.getX() / this.gridSizeX) * this.gridSizeX);
            double labelWidth = this.getFontMetrics(this.getFont()).getStringBounds(label, g).getWidth();
            if (!((double)x > labelWidth + 4.0)) continue;
            g.drawLine(x, 15, x, this.getHeight());
            g.drawString(label, (int)Math.round((double)x - 0.5 * labelWidth), 11);
        }
        mod = Math.abs(this.extent.getMinY()) % this.gridSizeY;
        for (int y = (int)Math.round(this.getSize().getHeight() - mod / scaleY); y > 15; y -= gridSizePixelsY) {
            Point2d point = this.renderableScale.getWorldCoordinates((Point2D)new Point2D.Double(0.0, y), this.extent, this.getSize());
            if (point == null) continue;
            String label = this.formatter.format((double)Math.round(point.getY() / this.gridSizeY) * this.gridSizeY);
            Rectangle2D labelBounds = this.getFontMetrics(this.getFont()).getStringBounds(label, g);
            g.drawLine((int)Math.round(labelBounds.getWidth() + 4.0), y, this.getWidth(), y);
            g.drawString(label, 2, (int)Math.round((double)y + labelBounds.getHeight() * 0.3));
        }
    }

    public RenderableScale getRenderableScale() {
        return this.renderableScale;
    }

    public void setRenderableScale(RenderableScale renderableScale) {
        this.renderableScale = renderableScale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectAdded(Renderable2DInterface<? extends Locatable> element) {
        List<Renderable2DInterface<? extends Locatable>> list = this.elementList;
        synchronized (list) {
            this.elements.add(element);
            this.dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectRemoved(Renderable2DInterface<? extends Locatable> element) {
        List<Renderable2DInterface<? extends Locatable>> list = this.elementList;
        synchronized (list) {
            this.elements.remove(element);
            this.dirty = true;
        }
    }

    public synchronized Bounds2d fullExtent() {
        double minX = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double minY = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        try {
            for (Renderable2DInterface<? extends Locatable> renderable : this.elementList) {
                Point l;
                if (renderable.getSource() == null || (l = renderable.getSource().getLocation()) == null) continue;
                Bounds b = renderable.getSource().getBounds();
                minX = Math.min(minX, l.getX() + b.getMinX());
                minY = Math.min(minY, l.getY() + b.getMinY());
                maxX = Math.max(maxX, l.getX() + b.getMaxX());
                maxY = Math.max(maxY, l.getY() + b.getMaxY());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        minX -= 0.05 * Math.abs(maxX - minX);
        minY -= 0.05 * Math.abs(maxY - minY);
        maxX += 0.05 * Math.abs(maxX - minX);
        maxY += 0.05 * Math.abs(maxY - minY);
        return new Bounds2d(minX, maxX, minY, maxY);
    }

    public synchronized void zoomAll() {
        this.setExtent(this.getRenderableScale().computeVisibleExtent(this.fullExtent(), this.getSize()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showClass(Class<? extends Locatable> locatableClass) {
        Map<Class<? extends Locatable>, Boolean> map = this.visibilityMap;
        synchronized (map) {
            this.visibilityMap.put(locatableClass, true);
        }
        this.shownClasses.clear();
        this.hiddenClasses.clear();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideClass(Class<? extends Locatable> locatableClass) {
        Map<Class<? extends Locatable>, Boolean> map = this.visibilityMap;
        synchronized (map) {
            this.visibilityMap.put(locatableClass, false);
        }
        this.shownClasses.clear();
        this.hiddenClasses.clear();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleClass(Class<? extends Locatable> locatableClass) {
        Map<Class<? extends Locatable>, Boolean> map = this.visibilityMap;
        synchronized (map) {
            if (!this.visibilityMap.containsKey(locatableClass)) {
                this.showClass(locatableClass);
            }
            this.visibilityMap.put(locatableClass, this.visibilityMap.get(locatableClass) == false);
        }
        this.shownClasses.clear();
        this.hiddenClasses.clear();
        this.repaint();
    }

    public void mouseMoved(java.awt.Point point) {
        Point2d world = this.getRenderableScale().getWorldCoordinates((Point2D)point, this.getExtent(), this.getSize());
        this.setWorldCoordinate(world);
        this.displayWorldCoordinateToolTip();
    }

    protected void pan(Point2D mouseClickedPoint, Point2D mouseReleasedPoint) {
        double dx = mouseReleasedPoint.getX() - mouseClickedPoint.getX();
        double dy = mouseReleasedPoint.getY() - mouseClickedPoint.getY();
        double scaleX = this.getRenderableScale().getXScale(this.getExtent(), this.getSize());
        double scaleY = this.getRenderableScale().getYScale(this.getExtent(), this.getSize());
        Bounds2d extent = this.getExtent();
        this.setExtent(new Bounds2d(extent.getMinX() - dx * scaleX, extent.getMinX() - dx * scaleX + extent.getDeltaX(), extent.getMinY() + dy * scaleY, extent.getMinY() + dy * scaleY + extent.getDeltaY()));
    }

    protected List<Locatable> getSelectedObjects(Point2D mousePoint) {
        ArrayList<Locatable> targets = new ArrayList<Locatable>();
        try {
            Point2d point = this.getRenderableScale().getWorldCoordinates(mousePoint, this.getExtent(), this.getSize());
            for (Renderable2DInterface renderable2DInterface : this.getElements()) {
                if (!this.isShowElement((Renderable2DInterface<? extends Locatable>)renderable2DInterface) || !renderable2DInterface.contains(point, this.getExtent())) continue;
                targets.add(renderable2DInterface.getSource());
            }
        }
        catch (Exception exception) {
            CategoryLogger.always().warn((Throwable)exception, "getSelectedObjects");
        }
        return targets;
    }

    protected void popup(MouseEvent e) {
        List<Locatable> targets = this.getSelectedObjects(e.getPoint());
        if (targets.size() > 0) {
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add("Introspect");
            popupMenu.add(new JSeparator());
            Iterator<Locatable> i = targets.iterator();
            while (i.hasNext()) {
                popupMenu.add(new IntrospectionAction(i.next()));
            }
            popupMenu.show(this, e.getX(), e.getY());
        }
    }

    protected Object getSelectedObject(List<Locatable> targets) {
        Locatable selectedObject = null;
        try {
            double zValue = -1.7976931348623157E308;
            for (Locatable next : targets) {
                double z = next.getZ();
                if (!(z > zValue)) continue;
                zValue = z;
                selectedObject = next;
            }
        }
        catch (RemoteException exception) {
            CategoryLogger.always().warn((Throwable)exception, "getSelectedObject");
        }
        return selectedObject;
    }

    protected void setDragLine(Point2D mousePosition, Point2D mouseClicked) {
        if (mousePosition != null && mouseClicked != null) {
            this.setDragLineEnabled(false);
            this.dragLine = new int[4];
            this.dragLine[0] = (int)mousePosition.getX();
            this.dragLine[1] = (int)mousePosition.getY();
            this.dragLine[2] = (int)mouseClicked.getX();
            this.dragLine[3] = (int)mouseClicked.getY();
            this.setDragLineEnabled(true);
        }
    }

    public int[] getDragLine() {
        return this.dragLine;
    }

    public boolean isDragLineEnabled() {
        return this.dragLineEnabled;
    }

    public void setDragLineEnabled(boolean dragLineEnabled) {
        this.dragLineEnabled = dragLineEnabled;
    }

    public SortedSet<Renderable2DInterface<? extends Locatable>> getElements() {
        return this.elements;
    }

    public AnimationEventProducer getAnimationEventProducer() {
        return this.animationEventProducer;
    }

    public boolean addListener(EventListener listener, EventType eventType) {
        return this.animationEventProducer.addListener(listener, eventType);
    }

    public boolean addListener(EventListener listener, EventType eventType, ReferenceType referenceType) {
        return this.animationEventProducer.addListener(listener, eventType, referenceType);
    }

    public boolean addListener(EventListener listener, EventType eventType, int position) {
        return this.animationEventProducer.addListener(listener, eventType, position);
    }

    public boolean addListener(EventListener listener, EventType eventType, int position, ReferenceType referenceType) {
        return this.animationEventProducer.addListener(listener, eventType, position, referenceType);
    }

    public boolean removeListener(EventListener listener, EventType eventType) {
        return this.animationEventProducer.removeListener(listener, eventType);
    }

    public int removeAllListeners() {
        return this.animationEventProducer.removeAllListeners();
    }

    public EventListenerMap getEventListenerMap() throws RemoteException {
        return this.animationEventProducer.getEventListenerMap();
    }

    class AnimationEventProducer
    extends LocalEventProducer {
        private static final long serialVersionUID = 20210213L;

        AnimationEventProducer() {
        }

        public void fireEvent(Event event) {
            super.fireEvent(event);
        }
    }
}

