/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.charts.boxAndWhisker;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.naming.NamingException;
import javax.swing.BorderFactory;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.dsol.swing.Swingable;
import nl.tudelft.simulation.dsol.swing.charts.boxAndWhisker.BoxAndWhiskerPlot;
import nl.tudelft.simulation.naming.context.ContextInterface;
import nl.tudelft.simulation.naming.context.util.ContextUtil;
import org.djutils.stats.summarizers.event.EventBasedTally;
import org.djutils.stats.summarizers.event.EventBasedTimestampWeightedTally;
import org.djutils.stats.summarizers.event.EventBasedWeightedTally;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;

public class BoxAndWhiskerChart
implements Swingable,
Serializable {
    private static final long serialVersionUID = 20200108L;
    public static final Font TITLE_FONT = new Font("SansSerif", 1, 18);
    private JFreeChart chart = null;

    public BoxAndWhiskerChart(String title) {
        BoxAndWhiskerPlot plot = new BoxAndWhiskerPlot();
        this.chart = new JFreeChart(title, TITLE_FONT, (Plot)plot, true);
        this.chart.setBackgroundPaint((Paint)new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.blue));
    }

    public BoxAndWhiskerChart(SimulatorInterface<?> simulator, String title) {
        this(title);
        try {
            ContextInterface context = ContextUtil.lookupOrCreateSubContext((ContextInterface)simulator.getReplication().getContext(), (String)"charts");
            context.bindObject((Object)this);
        }
        catch (RemoteException | NamingException exception) {
            simulator.getLogger().always().warn((Throwable)exception, "<init>");
        }
    }

    public void add(EventBasedTally tally) throws RemoteException {
        ((BoxAndWhiskerPlot)this.chart.getPlot()).add(tally);
    }

    public void add(EventBasedWeightedTally tally) throws RemoteException {
        ((BoxAndWhiskerPlot)this.chart.getPlot()).add(tally);
    }

    public void add(EventBasedTimestampWeightedTally tally) throws RemoteException {
        ((BoxAndWhiskerPlot)this.chart.getPlot()).add(tally);
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    @Override
    public Container getSwingPanel() {
        ChartPanel result = new ChartPanel(this.chart);
        result.setBorder(BorderFactory.createEtchedBorder(1));
        result.setMouseZoomable(true, false);
        result.setPreferredSize(new Dimension(800, 600));
        return result;
    }

    public double getConfidenceInterval() {
        return ((BoxAndWhiskerPlot)this.chart.getPlot()).getConfidenceInterval();
    }

    public void setConfidenceInterval(double confidenceInterval) {
        ((BoxAndWhiskerPlot)this.chart.getPlot()).setConfidenceInterval(confidenceInterval);
    }

    public String toString() {
        return this.getChart().getTitle().getText();
    }
}

