/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.charts.boxAndWhisker;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.djutils.event.Event;
import org.djutils.event.EventListener;
import org.djutils.event.reference.ReferenceType;
import org.djutils.stats.summarizers.Tally;
import org.djutils.stats.summarizers.TallyStatistic;
import org.djutils.stats.summarizers.WeightedTally;
import org.djutils.stats.summarizers.event.EventBasedTally;
import org.djutils.stats.summarizers.event.EventBasedTimestampWeightedTally;
import org.djutils.stats.summarizers.event.EventBasedWeightedTally;
import org.djutils.stats.summarizers.event.StatisticsEvents;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;

public class BoxAndWhiskerPlot
extends Plot
implements EventListener {
    private static final long serialVersionUID = 1L;
    public static final short BORDER_SIZE = 50;
    public static final String PLOT_TYPE = "SUMMARY_PLOT";
    public static final Font FONT = new Font("SansSerif", 0, 10);
    public static final Font TITLE_FONT = new Font("SansSerif", 1, 15);
    protected List<TallyStatistic> tallies = new ArrayList<TallyStatistic>();
    protected NumberFormat formatter = NumberFormat.getInstance();
    protected double confidenceInterval = 0.05;

    public synchronized void add(EventBasedTally tally) throws RemoteException {
        tally.addListener((EventListener)this, StatisticsEvents.SAMPLE_MEAN_EVENT, ReferenceType.STRONG);
        this.tallies.add((TallyStatistic)tally);
    }

    public synchronized void add(EventBasedWeightedTally tally) throws RemoteException {
        tally.addListener((EventListener)this, StatisticsEvents.WEIGHTED_SAMPLE_MEAN_EVENT, ReferenceType.STRONG);
        this.tallies.add((TallyStatistic)tally);
    }

    public synchronized void add(EventBasedTimestampWeightedTally tally) throws RemoteException {
        tally.addListener((EventListener)this, StatisticsEvents.TIMED_WEIGHTED_SAMPLE_MEAN_EVENT, ReferenceType.STRONG);
        this.tallies.add((TallyStatistic)tally);
    }

    public String getPlotType() {
        return PLOT_TYPE;
    }

    public void notify(Event event) {
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    private static double[] extent(List<TallyStatistic> tallies) {
        double[] result = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
        for (int i = 0; i < tallies.size(); ++i) {
            if (tallies.get(i).getMin() < result[0]) {
                result[0] = tallies.get(i).getMin();
            }
            if (!(tallies.get(i).getMax() > result[1])) continue;
            result[1] = tallies.get(i).getMax();
        }
        return result;
    }

    private double[] borders(Graphics2D g2, FontRenderContext context, List<TallyStatistic> tallyList) {
        double[] result = new double[]{0.0, 0.0};
        for (int i = 0; i < tallyList.size(); ++i) {
            double left = g2.getFont().getStringBounds(this.formatter.format(tallyList.get(i).getMin()), context).getWidth();
            double rigth = g2.getFont().getStringBounds(this.formatter.format(tallyList.get(i).getMax()), context).getWidth();
            if (left > result[0]) {
                result[0] = left;
            }
            if (!(rigth > result[1])) continue;
            result[1] = rigth;
        }
        result[0] = result[0] + 3.0;
        result[1] = result[1] + 3.0;
        return result;
    }

    private Rectangle2D getBounds(String word, FontRenderContext context) {
        return FONT.getStringBounds(word, context);
    }

    private void fillRectangle(Graphics2D g2, Rectangle2D rectangle, Color color) {
        g2.setColor(color);
        g2.fillRect((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
    }

    private void paintTally(Graphics2D g2, Rectangle2D rectangle, TallyStatistic tally, double leftX, double leftBorder, double scale) {
        this.fillRectangle(g2, rectangle, Color.WHITE);
        g2.setColor(Color.BLACK);
        g2.setFont(TITLE_FONT);
        g2.drawString(tally.getDescription(), (int)Math.round(leftBorder + 0.5 * (rectangle.getWidth() - leftBorder - 20.0) - 0.5 * this.getBounds(tally.getDescription(), g2.getFontRenderContext()).getWidth()), 25 + (int)rectangle.getY());
        g2.setFont(FONT);
        g2.drawRect((int)rectangle.getX() - 1, (int)rectangle.getY() - 1, (int)rectangle.getWidth() + 2, (int)rectangle.getHeight() + 2);
        int tallyMin = (int)Math.round(rectangle.getX() + (tally.getMin() - leftX) * scale + leftBorder);
        int tallyMax = (int)Math.round(rectangle.getX() + (tally.getMax() - leftX) * scale + leftBorder);
        int middle = (int)Math.round(rectangle.getY() + 0.5 * rectangle.getHeight());
        String label = this.formatter.format(tally.getMin());
        g2.drawString(label, (int)Math.round((double)(tallyMin - 3) - this.getBounds(label, g2.getFontRenderContext()).getWidth()), (int)Math.round((double)middle + 0.5 * this.getBounds(label, g2.getFontRenderContext()).getHeight()));
        label = this.formatter.format(tally.getMax());
        g2.drawString(label, tallyMax + 3, (int)Math.round((double)middle + 0.5 * this.getBounds(label, g2.getFontRenderContext()).getHeight()));
        g2.drawLine(tallyMin, middle + 6, tallyMin, middle - 6);
        g2.drawLine(tallyMin, middle, tallyMax, middle);
        g2.drawLine(tallyMax, middle + 6, tallyMax, middle - 6);
        if (tally instanceof Tally) {
            Tally unweightedTally = (Tally)tally;
            double[] confidence = unweightedTally.getConfidenceInterval(this.confidenceInterval);
            int middleX = (int)Math.round((unweightedTally.getSampleMean() - leftX) * scale + (double)tallyMin);
            g2.fillRect(middleX, middle - 6, 2, 12);
            label = this.formatter.format(unweightedTally.getSampleMean());
            Rectangle2D bounds = this.getBounds(label, g2.getFontRenderContext());
            g2.drawString(label, (int)Math.round((double)middleX - 0.5 * bounds.getWidth()), Math.round(middle - 8));
            if (confidence != null) {
                int confX = (int)Math.round((confidence[0] - leftX) * scale + (double)tallyMin);
                int confWidth = (int)Math.round((confidence[1] - confidence[0]) * scale);
                g2.fillRect(confX, middle - 2, confWidth, 4);
                label = this.formatter.format(confidence[0]);
                bounds = this.getBounds(label, g2.getFontRenderContext());
                g2.drawString(label, (int)Math.round((double)confX - bounds.getWidth()), (int)Math.round((double)(middle + 8) + bounds.getHeight()));
                label = this.formatter.format(confidence[1]);
                bounds = this.getBounds(label, g2.getFontRenderContext());
                g2.drawString(label, Math.round(confX + confWidth), (int)Math.round((double)(middle + 8) + bounds.getHeight()));
            }
        } else if (tally instanceof WeightedTally) {
            WeightedTally weightedTally = (WeightedTally)tally;
            int middleX = (int)Math.round((weightedTally.getWeightedSampleMean() - leftX) * scale + (double)tallyMin);
            g2.fillRect(middleX, middle - 6, 2, 12);
            label = this.formatter.format(weightedTally.getWeightedSampleMean());
            Rectangle2D bounds = this.getBounds(label, g2.getFontRenderContext());
            g2.drawString(label, (int)Math.round((double)middleX - 0.5 * bounds.getWidth()), Math.round(middle - 8));
        }
    }

    public void draw(Graphics2D g2, Rectangle2D rectangle, Point2D point, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        g2.setBackground(Color.WHITE);
        double height = Math.min(rectangle.getHeight() / (double)this.tallies.size() * 1.0, rectangle.getHeight());
        double[] extent = BoxAndWhiskerPlot.extent(this.tallies);
        double[] border = this.borders(g2, g2.getFontRenderContext(), this.tallies);
        double scale = (0.85 * rectangle.getWidth() - 10.0 - border[0] - border[1]) / ((extent[1] - extent[0]) * 1.0);
        for (int i = 0; i < this.tallies.size(); ++i) {
            g2.setFont(FONT);
            Rectangle2D.Double area = new Rectangle2D.Double(rectangle.getX() + 0.15 * rectangle.getWidth(), rectangle.getY() + (double)i * height + 3.0, 0.85 * rectangle.getWidth() - 10.0, 0.75 * height - 3.0);
            this.paintTally(g2, area, this.tallies.get(i), extent[0], border[0], scale);
        }
    }

    public double getConfidenceInterval() {
        return this.confidenceInterval;
    }

    public void setConfidenceInterval(double confidenceInterval) {
        this.confidenceInterval = confidenceInterval;
    }
}

