/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.charts.histogram;

import java.awt.Color;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.naming.NamingException;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.dsol.statistics.SimCounter;
import nl.tudelft.simulation.dsol.swing.Swingable;
import nl.tudelft.simulation.dsol.swing.charts.histogram.HistogramDataset;
import nl.tudelft.simulation.dsol.swing.charts.histogram.HistogramDomainAxis;
import nl.tudelft.simulation.dsol.swing.charts.histogram.HistogramSeries;
import nl.tudelft.simulation.naming.context.ContextInterface;
import nl.tudelft.simulation.naming.context.util.ContextUtil;
import org.djutils.event.EventListener;
import org.djutils.event.EventProducer;
import org.djutils.event.EventType;
import org.djutils.event.reference.ReferenceType;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.xy.IntervalXYDataset;

public class Histogram
implements Swingable,
Serializable {
    private static final long serialVersionUID = 20200108L;
    public static final String LABEL_X_AXIS = "X";
    public static final String LABEL_Y_AXIS = "#";
    protected JFreeChart chart = null;
    protected HistogramDataset dataset = null;

    public Histogram(String title, double[] domain, int numberofBins) {
        this(title, domain, null, numberofBins);
    }

    public Histogram(String title, double[] domain, double[] range, int numberofBins) {
        this.dataset = new HistogramDataset((Comparable<?>)((Object)title), domain, range, numberofBins);
        this.chart = ChartFactory.createHistogram((String)title, (String)LABEL_X_AXIS, (String)LABEL_Y_AXIS, (IntervalXYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        this.chart.setBackgroundPaint((Paint)new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.blue));
        this.chart.getXYPlot().setRangeAxis((ValueAxis)new NumberAxis(LABEL_Y_AXIS));
        this.chart.getXYPlot().getRangeAxis().setAutoRange(true);
        this.chart.getXYPlot().setDomainAxis((ValueAxis)new HistogramDomainAxis(this.chart.getXYPlot(), LABEL_X_AXIS, domain, numberofBins));
        this.dataset.addChangeListener((DatasetChangeListener)this.chart.getXYPlot());
    }

    public Histogram(SimulatorInterface<?> simulator, String title, double[] domain, double[] range, int numberofBins) {
        this(title, domain, range, numberofBins);
        try {
            ContextInterface context = ContextUtil.lookupOrCreateSubContext((ContextInterface)simulator.getReplication().getContext(), (String)"charts");
            context.bindObject((Object)this);
        }
        catch (RemoteException | NamingException exception) {
            simulator.getLogger().always().warn((Throwable)exception, "<init>");
        }
    }

    public Histogram(SimulatorInterface<?> simulator, String title, double[] domain, int numberofBins) {
        this(title, domain, numberofBins);
        try {
            ContextInterface context = ContextUtil.lookupOrCreateSubContext((ContextInterface)simulator.getReplication().getContext(), (String)"charts");
            context.bindObject((Object)this);
        }
        catch (RemoteException | NamingException exception) {
            simulator.getLogger().always().warn((Throwable)exception, "<init>");
        }
    }

    public synchronized void add(SimCounter<?> counter) throws RemoteException {
        HistogramSeries set = this.getDataset().addSeries(counter.getDescription());
        counter.addListener((EventListener)set, SimCounter.TIMED_OBSERVATION_ADDED_EVENT, ReferenceType.STRONG);
    }

    public synchronized void add(String description, EventProducer source, EventType eventType) throws RemoteException {
        HistogramSeries set = this.getDataset().addSeries(description);
        source.addListener((EventListener)set, eventType, ReferenceType.STRONG);
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    @Override
    public Container getSwingPanel() {
        ChartPanel result = new ChartPanel(this.chart);
        result.setMouseZoomable(true, false);
        return result;
    }

    public HistogramDataset getDataset() {
        return this.dataset;
    }

    public String toString() {
        return this.getChart().getTitle().getText();
    }
}

