/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.charts.histogram;

import java.util.ArrayList;
import java.util.Arrays;
import nl.tudelft.simulation.dsol.swing.charts.histogram.HistogramSeries;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.statistics.SimpleHistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;

public class HistogramDataset
extends SimpleHistogramDataset
implements IntervalXYDataset,
DatasetChangeListener {
    private static final long serialVersionUID = 1L;
    protected double[] domain = null;
    protected double[] range = null;
    protected int numberOfBins = 0;
    protected HistogramSeries[] series = new HistogramSeries[0];

    public HistogramDataset(Comparable<?> key, double[] domain, double[] range, int numberOfBins) {
        super(key);
        this.domain = domain;
        this.range = range;
        this.numberOfBins = numberOfBins;
    }

    public synchronized HistogramSeries addSeries(String name) {
        HistogramSeries histogramSeries = new HistogramSeries(name, this.domain, this.range, this.numberOfBins);
        this.addSeries(histogramSeries);
        return histogramSeries;
    }

    public synchronized void addSeries(HistogramSeries newSeries) {
        newSeries.addChangeListener(this);
        ArrayList<HistogramSeries> list = new ArrayList<HistogramSeries>(Arrays.asList(this.series));
        list.add(newSeries);
        this.series = list.toArray(new HistogramSeries[list.size()]);
        this.fireDatasetChanged();
    }

    public void datasetChanged(DatasetChangeEvent arg0) {
        if (arg0 != null) {
            this.fireDatasetChanged();
        }
    }

    public double getEndXValue(int serieNr, int bin) {
        return this.series[serieNr].getEndXValue(bin);
    }

    public double getEndYValue(int serieNr, int bin) {
        return this.series[serieNr].getEndYValue(bin);
    }

    public double getStartXValue(int serieNr, int bin) {
        return this.series[serieNr].getStartXValue(bin);
    }

    public double getStartYValue(int serieNr, int bin) {
        return this.series[serieNr].getStartYValue(bin);
    }

    public int getItemCount(int serieNr) {
        return this.series[serieNr].getBinCount();
    }

    public double getXValue(int serieNr, int bin) {
        return this.series[serieNr].getXValue(bin);
    }

    public double getYValue(int serieNr, int bin) {
        return this.series[serieNr].getYValue(bin);
    }

    public int getSeriesCount() {
        return this.series.length;
    }

    public String getSeriesName(int serieNr) {
        return this.series[serieNr].getName();
    }

    public Number getEndX(int serieNr, int bin) {
        return this.series[serieNr].getEndXValue(bin);
    }

    public Number getEndY(int serieNr, int bin) {
        return this.series[serieNr].getEndYValue(bin);
    }

    public Number getStartX(int serieNr, int bin) {
        return this.series[serieNr].getStartXValue(bin);
    }

    public Number getStartY(int serieNr, int bin) {
        return this.series[serieNr].getStartYValue(bin);
    }

    public Number getX(int serieNr, int bin) {
        return this.series[serieNr].getXValue(bin);
    }

    public Number getY(int serieNr, int bin) {
        return this.series[serieNr].getYValue(bin);
    }
}

