/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.charts.histogram;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.RectangleEdge;

public class HistogramDomainAxis
extends NumberAxis {
    private static final long serialVersionUID = 1L;
    protected String[] labels = null;
    protected double maxLabelHeight = -1.0;

    public HistogramDomainAxis(XYPlot parent, String label, double[] domain, int numberOfBins) {
        super(label);
        this.setAutoRange(false);
        double binWidth = (domain[1] - domain[0]) / (double)numberOfBins * 1.0;
        this.setLowerBound(domain[0] - binWidth);
        this.setUpperBound(domain[1] + binWidth);
        this.setVerticalTickLabels(true);
        this.setLabelFont(parent.getRangeAxis().getLabelFont());
        this.setTickLabelFont(parent.getRangeAxis().getTickLabelFont());
        this.labels = this.createLabels(domain, numberOfBins);
    }

    public double valueToJava2D(double value, Rectangle2D dataArea, RectangleEdge edge) {
        double ratio = (value - this.getLowerBound()) / (this.getUpperBound() - this.getLowerBound());
        return dataArea.getX() + ratio * dataArea.getWidth();
    }

    public double java2DToValue(double value, Rectangle2D dataArea, RectangleEdge edge) {
        double ratio = (value - dataArea.getX()) / dataArea.getWidth();
        return this.getLowerBound() + ratio * (this.getUpperBound() - this.getLowerBound());
    }

    public AxisSpace reserveSpace(Graphics2D g2, Plot dataPlot, Rectangle2D dataArea, RectangleEdge edge, AxisSpace axisSpace) {
        if (this.maxLabelHeight == -1.0) {
            g2.setFont(this.getTickLabelFont());
            for (int i = 0; i < this.labels.length; ++i) {
                double height = g2.getFont().getStringBounds(this.labels[i], g2.getFontRenderContext()).getWidth();
                if (!(height > this.maxLabelHeight)) continue;
                this.maxLabelHeight = height + 3.0;
            }
        }
        AxisSpace result = new AxisSpace();
        result.add(this.maxLabelHeight, RectangleEdge.BOTTOM);
        return result;
    }

    private String[] createLabels(double[] domain, int numberOfBins) {
        String[] result = new String[numberOfBins + 2];
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setMaximumFractionDigits(2);
        double binWidth = (domain[1] - domain[0]) / (double)numberOfBins * 1.0;
        double start = domain[0];
        for (int i = 1; i < numberOfBins + 1; ++i) {
            result[i] = formatter.format(start);
            start += binWidth;
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        result[0] = "-" + symbols.getInfinity();
        result[numberOfBins + 1] = symbols.getInfinity();
        return result;
    }

    public AxisState draw(Graphics2D g2, double cursor, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge, PlotRenderingInfo arg5) {
        g2.setColor(Color.BLACK);
        g2.setFont(this.getTickLabelFont());
        double labelWidth = g2.getFont().getStringBounds(this.labels[0], g2.getFontRenderContext()).getHeight();
        double width = dataArea.getWidth() / (double)this.labels.length * 1.0;
        double x = dataArea.getX() + 0.5 * width;
        double y = dataArea.getY() + dataArea.getHeight();
        g2.translate(x, y);
        g2.rotate(-1.5707963267948966);
        double offset = 0.0;
        for (int i = 0; i < this.labels.length; ++i) {
            double labelHeight = g2.getFont().getStringBounds(this.labels[i], g2.getFontRenderContext()).getWidth() + 3.0;
            g2.drawString(this.labels[i], (float)Math.round(-labelHeight), (float)Math.round(offset + 0.33 * labelWidth));
            offset += width;
        }
        g2.rotate(1.5707963267948966);
        g2.translate(-x, -y);
        return new AxisState();
    }
}

