/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.charts.histogram;

import org.djutils.event.Event;
import org.djutils.event.EventListener;
import org.jfree.data.general.AbstractDataset;

public class HistogramSeries
extends AbstractDataset
implements EventListener {
    private static final long serialVersionUID = 1L;
    private String name;
    private Bin[] bins = null;

    public HistogramSeries(String name, double[] domain, double[] range, int numberOfBins) {
        this.name = name;
        this.bins = new Bin[numberOfBins + 2];
        double binWidth = (domain[1] - domain[0]) / (double)numberOfBins * 1.0;
        double min = domain[0] - binWidth;
        for (int i = 0; i < numberOfBins + 2; ++i) {
            this.bins[i] = new Bin(new double[]{min, min + binWidth}, range);
            if (range != null) {
                this.bins[i].setFixed(true);
            }
            min += binWidth;
        }
        this.fireDatasetChanged();
    }

    public String getName() {
        return this.name;
    }

    public double getEndXValue(int bin) {
        return this.bins[bin].getEndXValue();
    }

    public double getEndYValue(int bin) {
        return this.bins[bin].getEndYValue();
    }

    public double getStartXValue(int bin) {
        return this.bins[bin].getStartXValue();
    }

    public double getStartYValue(int bin) {
        return this.bins[bin].getStartYValue();
    }

    public int getBinCount() {
        return this.bins.length;
    }

    public double getXValue(int bin) {
        return this.bins[bin].getXValue();
    }

    public int getYValue(int bin) {
        return this.bins[bin].getYValue();
    }

    public synchronized void notify(Event event) {
        double value = (Double)event.getContent();
        this.bins[this.resolveBin(value)].increase();
        this.fireDatasetChanged();
    }

    private int resolveBin(double value) {
        if (value <= this.bins[1].getStartXValue()) {
            return 0;
        }
        for (int i = 1; i < this.bins.length - 1; ++i) {
            if (!(value > this.bins[i].getStartXValue()) || !(value <= this.bins[i].getEndXValue())) continue;
            return i;
        }
        return this.bins.length - 1;
    }

    private class Bin {
        private double[] domain;
        private double[] range = null;
        private int observations = 0;
        private boolean fixed = false;

        Bin(double[] domain, double[] range) {
            this.domain = domain;
            if (range == null) {
                this.range = new double[]{0.0, 1.0};
            } else {
                this.range = range;
                this.fixed = true;
            }
        }

        public void increase() {
            ++this.observations;
            if (!this.fixed && (double)this.observations >= this.range[1]) {
                this.range[1] = this.observations;
            }
        }

        public double getStartXValue() {
            return this.domain[0];
        }

        public double getStartYValue() {
            return this.range[0];
        }

        public double getEndXValue() {
            return this.domain[1];
        }

        public double getEndYValue() {
            return this.range[1];
        }

        public synchronized double getXValue() {
            return 0.5 * (this.domain[1] - this.domain[0]);
        }

        public int getYValue() {
            return this.observations;
        }

        public void setFixed(boolean fixed) {
            this.fixed = fixed;
        }
    }
}

