/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.charts.xy;

import java.awt.Color;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.naming.NamingException;
import javax.swing.BorderFactory;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.dsol.statistics.SimPersistent;
import nl.tudelft.simulation.dsol.swing.Swingable;
import nl.tudelft.simulation.dsol.swing.charts.xy.XYDataset;
import nl.tudelft.simulation.dsol.swing.charts.xy.XYSeries;
import nl.tudelft.simulation.language.filters.FilterInterface;
import nl.tudelft.simulation.naming.context.ContextInterface;
import nl.tudelft.simulation.naming.context.util.ContextUtil;
import org.djutils.event.EventListener;
import org.djutils.event.EventProducer;
import org.djutils.event.EventType;
import org.djutils.event.reference.ReferenceType;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.general.DatasetChangeListener;

public class XYChart
implements Swingable,
Serializable {
    private static final long serialVersionUID = 20200108L;
    public static final short XLINEAR_YLINEAR = 0;
    public static final short XLINEAR_YLOGARITHMIC = 1;
    public static final short XLOGARITHMIC_YLINEAR = 2;
    public static final short XLOGARITHMIC_YLOGARITHMIC = 3;
    private static final String LABEL_X_AXIS = "X";
    private static final String LABEL_Y_AXIS = "value";
    protected JFreeChart chart = null;
    final SimulatorInterface<?> simulator;
    protected XYDataset dataset = new XYDataset();
    protected short axisType = 0;
    private double period = Double.POSITIVE_INFINITY;

    public XYChart(SimulatorInterface<?> simulator, String title, double[] domain, double[] range, short axisType) {
        this.simulator = simulator;
        this.chart = ChartFactory.createXYLineChart((String)title, (String)LABEL_X_AXIS, (String)LABEL_Y_AXIS, (org.jfree.data.xy.XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        this.chart.setBackgroundPaint((Paint)new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.blue));
        this.axisType = axisType;
        switch (this.axisType) {
            case 1: {
                this.chart.getXYPlot().setRangeAxis((ValueAxis)new LogarithmicAxis(LABEL_Y_AXIS));
                break;
            }
            case 2: {
                this.chart.getXYPlot().setDomainAxis((ValueAxis)new LogarithmicAxis(LABEL_X_AXIS));
                break;
            }
            case 3: {
                this.chart.getXYPlot().setDomainAxis((ValueAxis)new LogarithmicAxis(LABEL_X_AXIS));
                this.chart.getXYPlot().setRangeAxis((ValueAxis)new LogarithmicAxis(LABEL_Y_AXIS));
                break;
            }
        }
        if (domain != null) {
            if (Double.isNaN(domain[0])) {
                this.chart.getXYPlot().getDomainAxis().setAutoRange(true);
                this.period = domain[1];
            } else {
                this.chart.getXYPlot().getDomainAxis().setAutoRange(false);
                this.chart.getXYPlot().getDomainAxis().setLowerBound(domain[0]);
                this.chart.getXYPlot().getDomainAxis().setUpperBound(domain[1]);
            }
        } else {
            this.chart.getXYPlot().getDomainAxis().setAutoRange(true);
        }
        if (range != null) {
            this.chart.getXYPlot().getRangeAxis().setAutoRange(false);
            this.chart.getXYPlot().getRangeAxis().setLowerBound(range[0]);
            this.chart.getXYPlot().getRangeAxis().setUpperBound(range[1]);
        } else {
            this.chart.getXYPlot().getRangeAxis().setAutoRange(true);
        }
        this.dataset.addChangeListener((DatasetChangeListener)this.chart.getXYPlot());
        this.getChart().fireChartChanged();
        try {
            ContextInterface context = ContextUtil.lookupOrCreateSubContext((ContextInterface)simulator.getReplication().getContext(), (String)"charts");
            context.bindObject((Object)this);
        }
        catch (RemoteException | NamingException exception) {
            simulator.getLogger().always().warn((Throwable)exception, "<init>");
        }
    }

    public XYChart(SimulatorInterface<?> simulator, String title) {
        this(simulator, title, new double[]{0.0, simulator.getReplication().getRunLength().doubleValue()});
    }

    public XYChart(SimulatorInterface<?> simulator, String title, short axisType) {
        this(simulator, title, new double[]{0.0, simulator.getReplication().getRunLength().doubleValue()}, axisType);
    }

    public XYChart(SimulatorInterface<?> simulator, String title, double[] domain) {
        this(simulator, title, domain, null, 0);
    }

    public XYChart(SimulatorInterface<?> simulator, String title, double period) {
        this(simulator, title, new double[]{Double.NaN, period}, null, 0);
    }

    public XYChart(SimulatorInterface<?> simulator, String title, double[] domain, short axisType) {
        this(simulator, title, domain, null, axisType);
    }

    public XYChart(SimulatorInterface<?> simulator, String title, double period, short axisType) {
        this(simulator, title, new double[]{Double.NaN, period}, null, axisType);
    }

    public XYChart(SimulatorInterface<?> simulator, String title, double[] domain, double[] range) {
        this(simulator, title, domain, range, 0);
    }

    public XYChart(SimulatorInterface<?> simulator, String title, double period, double[] range) {
        this(simulator, title, new double[]{Double.NaN, period}, range, 0);
    }

    public void add(SimPersistent<?> persistent) throws RemoteException {
        XYSeries set = new XYSeries(persistent.getDescription(), this.simulator, this.axisType, this.period);
        persistent.addListener((EventListener)set, SimPersistent.TIMED_OBSERVATION_ADDED_EVENT, ReferenceType.STRONG);
        this.getDataset().addSeries(set);
    }

    public void add(String description, EventProducer source, EventType eventType) throws RemoteException {
        XYSeries set = new XYSeries(description, this.simulator, this.axisType, this.period);
        source.addListener((EventListener)set, eventType, 0, ReferenceType.STRONG);
        this.getDataset().addSeries(set);
    }

    public XYChart setLabelXAxis(String xLabel) {
        this.getChart().getXYPlot().getDomainAxis().setLabel(xLabel);
        return this;
    }

    public XYChart setLabelYAxis(String yLabel) {
        this.getChart().getXYPlot().getRangeAxis().setLabel(yLabel);
        return this;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    @Override
    public Container getSwingPanel() {
        ChartPanel result = new ChartPanel(this.chart);
        result.setBorder(BorderFactory.createEtchedBorder(1));
        result.setMouseZoomable(true, false);
        return result;
    }

    public XYDataset getDataset() {
        return this.dataset;
    }

    public void setFilter(FilterInterface filter) {
        this.dataset.setFilter(filter);
    }

    public String toString() {
        return this.getChart().getTitle().getText();
    }
}

