/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.charts.xy;

import java.util.ArrayList;
import java.util.Arrays;
import nl.tudelft.simulation.dsol.swing.charts.xy.XYSeries;
import nl.tudelft.simulation.language.filters.FilterInterface;
import org.jfree.data.DomainOrder;
import org.jfree.data.general.AbstractSeriesDataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;

public class XYDataset
extends AbstractSeriesDataset
implements org.jfree.data.xy.XYDataset,
DatasetChangeListener {
    private static final long serialVersionUID = 1L;
    private XYSeries[] series = new XYSeries[0];

    public XYDataset() {
        this.fireDatasetChanged();
    }

    public void datasetChanged(DatasetChangeEvent arg0) {
        if (arg0 != null) {
            this.fireDatasetChanged();
        }
    }

    public synchronized void addSeries(XYSeries dataset) {
        dataset.addChangeListener(this);
        ArrayList<XYSeries> list = new ArrayList<XYSeries>(Arrays.asList(this.series));
        list.add(dataset);
        this.series = list.toArray(new XYSeries[list.size()]);
        this.fireDatasetChanged();
    }

    public DomainOrder getDomainOrder() {
        return DomainOrder.ASCENDING;
    }

    public int getItemCount(int serie) {
        return this.series[serie].getItemCount();
    }

    public double getXValue(int serie, int item) {
        return this.series[serie].getXValue(item);
    }

    public double getYValue(int serie, int item) {
        return this.series[serie].getYValue(item);
    }

    public int getSeriesCount() {
        return this.series.length;
    }

    public String getSeriesName(int serie) {
        return this.series[serie].getSeriesName();
    }

    public Number getX(int serie, int item) {
        return this.series[serie].getXValue(item);
    }

    public Number getY(int serie, int item) {
        return this.series[serie].getYValue(item);
    }

    public void setFilter(FilterInterface filter) {
        for (int i = 0; i < this.series.length; ++i) {
            this.series[i].setFilter(filter);
        }
    }

    public Comparable<?> getSeriesKey(int seriesNumber) {
        return this.series[seriesNumber].getSeriesName();
    }
}

