/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.charts.xy;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.language.filters.FilterInterface;
import nl.tudelft.simulation.language.filters.ZeroFilter;
import org.djutils.event.Event;
import org.djutils.event.EventListener;
import org.djutils.event.EventType;
import org.djutils.event.TimedEvent;
import org.djutils.logger.CategoryLogger;
import org.jfree.data.general.AbstractDataset;

public class XYSeries
extends AbstractDataset
implements EventListener {
    private static final long serialVersionUID = 1L;
    public static final EventType LOWER_RANGE_EVENT = new EventType("LOWER_RANGE_EVENT");
    public static final EventType UPPER_RANGE_EVENT = new EventType("UPPER_RANGE_EVENT");
    private String name = null;
    protected List<double[]> entries = new ArrayList<double[]>();
    private final SimulatorInterface<?> simulator;
    private short axisType = 0;
    private FilterInterface filter = new ZeroFilter();
    private final double PERIOD;

    public XYSeries(String name, SimulatorInterface<?> simulator, short axisType, double period) {
        this.axisType = axisType;
        this.name = name;
        this.simulator = simulator;
        this.PERIOD = period;
        this.fireDatasetChanged();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void notify(Event event) {
        Number timeStamp;
        if (event instanceof TimedEvent) {
            TimedEvent timedEvent = (TimedEvent)event;
            if (timedEvent.getTimeStamp() instanceof Number) {
                timeStamp = (Number)((Object)timedEvent.getTimeStamp());
            } else {
                if (!(timedEvent.getTimeStamp() instanceof Calendar)) throw new IllegalArgumentException("TimedEvent has timestamp other than Number or Calendar");
                timeStamp = ((Calendar)timedEvent.getTimeStamp()).getTimeInMillis();
            }
        } else {
            timeStamp = this.simulator.getSimulatorTime();
        }
        if ((this.axisType == 2 || this.axisType == 3) && timeStamp.doubleValue() <= 0.0) {
            CategoryLogger.always().warn("notify: refusing xvalue of {} on logrithmic chart", new Object[]{event});
            return;
        }
        if ((this.axisType == 1 || this.axisType == 3) && ((Number)event.getContent()).doubleValue() <= 0.0) {
            CategoryLogger.always().warn("notify: refusing yValue of {} on logrithmic chart", new Object[]{event});
            return;
        }
        double[] point = new double[]{timeStamp.doubleValue(), ((Number)event.getContent()).doubleValue()};
        if (!this.filter.accept((Object)point)) {
            return;
        }
        this.entries.add(point);
        if (!Double.isInfinite(this.PERIOD)) {
            double[] entry;
            double lowerBounds = point[0] - this.PERIOD;
            Iterator<double[]> i = this.entries.iterator();
            while (i.hasNext() && (entry = i.next())[0] < lowerBounds) {
                i.remove();
            }
        }
        this.fireDatasetChanged();
    }

    public int getItemCount() {
        return this.entries.size();
    }

    public synchronized double getXValue(int item) {
        item = Math.min(item, this.entries.size() - 1);
        return this.entries.get(item)[0];
    }

    public double getYValue(int item) {
        item = Math.min(item, this.entries.size() - 1);
        return this.entries.get(item)[1];
    }

    public String getSeriesName() {
        return this.name;
    }

    public void setFilter(FilterInterface filter) {
        this.filter = filter;
    }
}

