/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import nl.tudelft.simulation.dsol.swing.gui.appearance.AppearanceControl;
import org.djutils.logger.CategoryLogger;
import org.pmw.tinylog.Configuration;
import org.pmw.tinylog.Configurator;
import org.pmw.tinylog.Level;
import org.pmw.tinylog.LogEntry;
import org.pmw.tinylog.writers.LogEntryValue;
import org.pmw.tinylog.writers.Writer;

public class ConsoleLogger
extends JPanel
implements AppearanceControl {
    private static final long serialVersionUID = 1L;
    protected ConsoleLogWriter consoleLogWriter;
    private String messageFormat = "{class_name}.{method}:{line} {message|indent=4}";
    private Level level = Level.INFO;
    private JTextPane textPane;

    public ConsoleLogger(Level logLevel) {
        this.level = logLevel;
        this.setLayout(new BorderLayout());
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.textPane.setBackground(Color.WHITE);
        this.textPane.setOpaque(true);
        this.consoleLogWriter = new ConsoleLogWriter(this.textPane);
        Configurator.currentConfig().addWriter((Writer)this.consoleLogWriter, this.level, this.messageFormat).activate();
        JScrollPane scrollPane = new JScrollPane(this.textPane, 22, 31);
        scrollPane.setBackground(Color.WHITE);
        scrollPane.setOpaque(true);
        this.add((Component)scrollPane, "Center");
    }

    public void setLogMessageFormat(String newMessageFormat) {
        Configurator.currentConfig().removeWriter((Writer)this.consoleLogWriter).activate();
        this.messageFormat = newMessageFormat;
        Configurator.currentConfig().addWriter((Writer)this.consoleLogWriter, this.level, this.messageFormat).activate();
    }

    public void setLogLevel(Level newLevel) {
        Configurator.currentConfig().removeWriter((Writer)this.consoleLogWriter).activate();
        this.level = newLevel;
        Configurator.currentConfig().addWriter((Writer)this.consoleLogWriter, this.level, this.messageFormat).activate();
    }

    public void setMaxLines(int maxLines) {
        this.consoleLogWriter.maxLines = Math.max(1, maxLines);
    }

    @Override
    public boolean isBackground() {
        return true;
    }

    public static class ConsoleLogWriter
    implements Writer {
        JTextPane textPane;
        StyledDocument doc;
        Style style;
        int nrLines = 0;
        protected int maxLines = 20000;

        public ConsoleLogWriter(JTextPane textPane) {
            this.textPane = textPane;
            this.doc = textPane.getStyledDocument();
            this.style = textPane.addStyle("colorStyle", null);
        }

        public Set<LogEntryValue> getRequiredLogEntryValues() {
            return EnumSet.of(LogEntryValue.RENDERED_LOG_ENTRY);
        }

        public void init(Configuration configuration) throws Exception {
        }

        public synchronized void write(final LogEntry logEntry) throws Exception {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    String[] lines = logEntry.getRenderedLogEntry().split("\\r?\\n");
                    while (nrLines > Math.max(0, maxLines - lines.length)) {
                        String[] document = doc;
                        Element root = document.getDefaultRootElement();
                        Element line = root.getElement(0);
                        int end = line.getEndOffset();
                        try {
                            document.remove(0, end);
                            --nrLines;
                        }
                        catch (BadLocationException exception) {
                            CategoryLogger.always().error((Throwable)exception);
                            break;
                        }
                    }
                    switch (logEntry.getLevel()) {
                        case TRACE: {
                            StyleConstants.setForeground(style, Color.DARK_GRAY);
                            break;
                        }
                        case DEBUG: {
                            StyleConstants.setForeground(style, Color.BLUE);
                            break;
                        }
                        case INFO: {
                            StyleConstants.setForeground(style, Color.BLACK);
                            break;
                        }
                        case WARNING: {
                            StyleConstants.setForeground(style, Color.MAGENTA);
                            break;
                        }
                        case ERROR: {
                            StyleConstants.setForeground(style, Color.RED);
                            break;
                        }
                    }
                    try {
                        for (String line : lines) {
                            doc.insertString(doc.getLength(), line + "\n", style);
                            ++nrLines;
                        }
                    }
                    catch (Exception exception) {
                        System.err.println("Was not able to insert text in the Console");
                    }
                    textPane.setCaretPosition(doc.getLength());
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        public void flush() throws Exception {
        }

        public void close() throws Exception {
        }
    }
}

