/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ConsoleOutput
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextArea textArea;
    private PrintStream standardOut;
    private PrintStream standardErr;

    public ConsoleOutput() {
        this.setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.standardOut = System.out;
        this.standardErr = System.err;
        System.setOut(new PrintStream(new CustomOutputStream(this.textArea, this.standardOut)));
        System.setErr(new PrintStream(new CustomErrorStream(this.textArea, this.standardErr)));
        JScrollPane scrollPane = new JScrollPane(this.textArea, 22, 31);
        this.add((Component)scrollPane, "Center");
    }

    public static class CustomErrorStream
    extends OutputStream {
        private final JTextArea textArea;
        private final PrintStream standardErr;

        public CustomErrorStream(JTextArea textArea, PrintStream standardErr) {
            this.textArea = textArea;
            this.standardErr = standardErr;
        }

        @Override
        public void write(int b) throws IOException {
            this.textArea.append(String.valueOf((char)b));
            this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
            this.standardErr.append(String.valueOf((char)b));
        }
    }

    public static class CustomOutputStream
    extends OutputStream {
        private final JTextArea textArea;
        private final PrintStream standardOut;

        public CustomOutputStream(JTextArea textArea, PrintStream standardOut) {
            this.textArea = textArea;
            this.standardOut = standardOut;
        }

        @Override
        public void write(int b) throws IOException {
            this.textArea.append(String.valueOf((char)b));
            this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
            this.standardOut.append(String.valueOf((char)b));
        }
    }
}

