/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nl.tudelft.simulation.dsol.swing.animation.D2.AnimationPanel;
import nl.tudelft.simulation.dsol.swing.gui.DSOLPanel;
import nl.tudelft.simulation.dsol.swing.gui.appearance.Appearance;
import nl.tudelft.simulation.dsol.swing.gui.appearance.AppearanceControl;

public class DSOLApplication
extends JFrame {
    private static final long serialVersionUID = 20190118L;
    private final DSOLPanel panel;
    protected boolean closed = false;
    protected Properties frameProperties;
    private Appearance appearance = Appearance.BRIGHT;

    public DSOLApplication(DSOLPanel panel, String title) {
        this.setPreferredSize(new Dimension(1024, 768));
        this.panel = panel;
        this.setTitle(title);
        this.setContentPane(panel);
        this.pack();
        this.setExtendedState(6);
        this.setVisible(true);
        this.setExitOnClose(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DSOLApplication.this.closed = true;
                super.windowClosing(windowEvent);
            }
        });
        String sep = System.getProperty("file.separator");
        final String propertiesFile = System.getProperty("user.home") + sep + "dsol" + sep + "properties.ini";
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                try {
                    File f = new File(propertiesFile);
                    f.getParentFile().mkdirs();
                    FileWriter writer = new FileWriter(f);
                    DSOLApplication.this.frameProperties.store(writer, "DSOL user settings");
                }
                catch (IOException exception) {
                    System.err.println("Could not store properties at " + propertiesFile + ".");
                }
            }
        });
        Properties defaults = new Properties();
        defaults.setProperty("Appearance", "BRIGHT");
        this.frameProperties = new Properties(defaults);
        try {
            FileReader reader = new FileReader(propertiesFile);
            this.frameProperties.load(reader);
        }
        catch (IOException reader) {
            // empty catch block
        }
        this.appearance = Appearance.valueOf(this.frameProperties.getProperty("Appearance").toUpperCase());
        class AppearanceControlMenu
        extends JMenu
        implements AppearanceControl {
            private static final long serialVersionUID = 20180206L;

            AppearanceControlMenu(String string) {
                super(string);
            }

            @Override
            public boolean isFont() {
                return true;
            }

            @Override
            public String toString() {
                return "AppearanceControlMenu []";
            }
        }
        AppearanceControlMenu app = new AppearanceControlMenu("Appearance");
        app.addMouseListener(new SubMenuShower(app));
        ButtonGroup appGroup = new ButtonGroup();
        for (Appearance appearanceValue : Appearance.values()) {
            appGroup.add(this.addAppearance(app, appearanceValue));
        }
        class AppearanceControlPopupMenu
        extends JPopupMenu
        implements AppearanceControl {
            private static final long serialVersionUID = 20180206L;

            AppearanceControlPopupMenu() {
            }

            @Override
            public boolean isFont() {
                return true;
            }

            @Override
            public String toString() {
                return "AppearanceControlPopupMenu []";
            }
        }
        AppearanceControlPopupMenu popMenu = new AppearanceControlPopupMenu();
        popMenu.add(app);
        panel.setComponentPopupMenu(popMenu);
        this.setAppearance(this.getAppearance());
    }

    public void setAppearance(Appearance appearance) {
        this.appearance = appearance;
        this.setAppearance(this.getContentPane(), appearance);
        this.frameProperties.setProperty("Appearance", appearance.toString());
    }

    private void setAppearance(Component c, Appearance appear) {
        if (c instanceof AppearanceControl) {
            AppearanceControl ac = (AppearanceControl)((Object)c);
            if (ac.isBackground()) {
                c.setBackground(appear.getBackground());
            }
            if (ac.isForeground()) {
                c.setForeground(appear.getForeground());
            }
            if (ac.isFont()) {
                this.changeFont(c, appear.getFont());
            }
        } else if (c instanceof AnimationPanel) {
            c.setBackground(appear.getBackdrop());
            c.setForeground(appear.getForeground());
            this.changeFont(c, appear.getFont());
        } else {
            c.setBackground(appear.getBackground());
            c.setForeground(appear.getForeground());
            this.changeFont(c, appear.getFont());
        }
        if (c instanceof JSlider) {
            Dictionary dictionary = ((JSlider)c).getLabelTable();
            Enumeration keys = dictionary.keys();
            while (keys.hasMoreElements()) {
                JLabel label = (JLabel)dictionary.get(keys.nextElement());
                label.setForeground(appear.getForeground());
                label.setBackground(appear.getBackground());
            }
        }
        if (c instanceof JComponent) {
            for (Component child : ((JComponent)c).getComponents()) {
                this.setAppearance(child, appear);
            }
        }
    }

    private void changeFont(Component c, String font) {
        Font prev = c.getFont();
        c.setFont(new Font(font, prev.getStyle(), prev.getSize()));
    }

    public Appearance getAppearance() {
        return this.appearance;
    }

    private JMenuItem addAppearance(JMenu group, final Appearance appear) {
        StayOpenCheckBoxMenuItem check = new StayOpenCheckBoxMenuItem(appear.getName(), appear.equals((Object)this.getAppearance()));
        check.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DSOLApplication.this.setAppearance(appear);
            }
        });
        return group.add(check);
    }

    public void setExitOnClose(boolean exitOnClose) {
        if (exitOnClose) {
            this.setDefaultCloseOperation(3);
        } else {
            this.setDefaultCloseOperation(2);
        }
    }

    public DSOLPanel getDSOLPanel() {
        return this.panel;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private static class StayOpenCheckBoxMenuItem
    extends JCheckBoxMenuItem
    implements AppearanceControl {
        private static final long serialVersionUID = 20180206L;
        private static MenuElement[] path;

        public static void setPath(MenuElement[] path) {
            StayOpenCheckBoxMenuItem.path = path;
        }

        StayOpenCheckBoxMenuItem(String text, boolean selected) {
            super(text, selected);
            this.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (this.getModel().isArmed() && this.isShowing()) {
                        StayOpenCheckBoxMenuItem.setPath(MenuSelectionManager.defaultManager().getSelectedPath());
                    }
                }
            });
        }

        @Override
        public void doClick(int pressTime) {
            super.doClick(pressTime);
            for (MenuElement element : path) {
                if (!(element instanceof JComponent)) continue;
                ((JComponent)((Object)element)).setVisible(true);
            }
            JMenu menu = (JMenu)path[path.length - 3];
            MenuSelectionManager.defaultManager().setSelectedPath(new MenuElement[]{(MenuElement)((Object)menu.getParent()), menu, menu.getPopupMenu()});
        }

        @Override
        public boolean isFont() {
            return true;
        }

        @Override
        public String toString() {
            return "StayOpenCheckBoxMenuItem []";
        }
    }

    private class SubMenuShower
    extends MouseAdapter {
        private JMenu menu;

        SubMenuShower(JMenu menu) {
            this.menu = menu;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            MenuSelectionManager.defaultManager().setSelectedPath(new MenuElement[]{(MenuElement)((Object)this.menu.getParent()), this.menu, this.menu.getPopupMenu()});
        }

        public String toString() {
            return "SubMenuShower [menu=" + this.menu + "]";
        }
    }
}

