/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.rmi.RemoteException;
import javax.swing.JPanel;
import javax.swing.UIManager;
import nl.tudelft.simulation.dsol.model.DSOLModel;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.dsol.swing.gui.ConsoleLogger;
import nl.tudelft.simulation.dsol.swing.gui.ConsoleOutput;
import nl.tudelft.simulation.dsol.swing.gui.InputParametersTab;
import nl.tudelft.simulation.dsol.swing.gui.TabbedContentPane;
import nl.tudelft.simulation.dsol.swing.gui.appearance.AppearanceControl;
import nl.tudelft.simulation.dsol.swing.gui.control.AbstractControlPanel;
import org.pmw.tinylog.Level;

public class DSOLPanel
extends JPanel
implements AppearanceControl {
    private static final long serialVersionUID = 20150617L;
    private AbstractControlPanel<?, ?> controlPanel;
    private final TabbedContentPane tabbedPane;

    public DSOLPanel(AbstractControlPanel<?, ?> controlPanel) throws RemoteException {
        this.setPreferredSize(new Dimension(1024, 768));
        this.tabbedPane = new AppearanceControlTabbedContentPane(3);
        this.setLayout(new BorderLayout());
        this.controlPanel = controlPanel;
        this.add(this.controlPanel, "North");
        this.add((Component)this.tabbedPane, "Center");
    }

    public void addTab(String tabTitle, Component component) {
        this.tabbedPane.addTab(tabTitle, component);
    }

    public void addTab(int position, String tabTitle, Component component) {
        this.tabbedPane.addTab(position, tabTitle, component);
    }

    public void addConsoleLogger(Level logLevel) {
        this.addTab("logger", new ConsoleLogger(logLevel));
    }

    public void addConsoleOutput() {
        this.addTab("console", new ConsoleOutput());
    }

    public void addInputParametersTab() {
        this.addTab("parameters", new InputParametersTab(this.getModel()));
    }

    public TabbedContentPane getTabbedPane() {
        return this.tabbedPane;
    }

    public SimulatorInterface<?> getSimulator() {
        return this.controlPanel.getSimulator();
    }

    public AbstractControlPanel<?, ?> getControlPanel() {
        return this.controlPanel;
    }

    public DSOLModel<?, ?> getModel() {
        return this.controlPanel.getModel();
    }

    public void enableSimulationControlButtons() {
        this.controlPanel.setControlButtonsState(true);
    }

    public void disableSimulationControlButtons() {
        this.controlPanel.setControlButtonsState(false);
    }

    @Override
    public String toString() {
        return "SimulationPanel";
    }

    static {
        UIManager.put("TabbedPane.contentBorderInsets", new Insets(1, 1, 1, 1));
    }

    static class AppearanceControlTabbedContentPane
    extends TabbedContentPane
    implements AppearanceControl {
        private static final long serialVersionUID = 20180206L;

        AppearanceControlTabbedContentPane(int tabPlacement) {
            super(tabPlacement);
        }

        @Override
        public String toString() {
            return "AppearanceControlTabbedContentPane []";
        }
    }
}

