/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui;

import java.awt.Color;
import java.awt.Toolkit;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import nl.tudelft.simulation.dsol.model.DSOLModel;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameter;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterMap;

public class InputParametersTab
extends JPanel {
    private static final long serialVersionUID = 1L;
    public InputParameterMap inputParameterMap;

    public InputParametersTab(DSOLModel<?, ?> model) {
        this.inputParameterMap = model.getInputParameterMap();
        JEditorPane textPane = new JEditorPane("text/html", "");
        textPane.setOpaque(true);
        textPane.setBackground(Color.WHITE);
        textPane.setEditable(true);
        textPane.setPreferredSize(Toolkit.getDefaultToolkit().getScreenSize());
        JScrollPane scrollPane = new JScrollPane(textPane, 20, 30);
        this.add(scrollPane);
        StringBuilder textBuilder = new StringBuilder();
        textBuilder.append("<html>\n");
        textBuilder.append(this.makeHead());
        textBuilder.append(this.makeBody());
        textBuilder.append("</html>\n");
        textPane.setText(textBuilder.toString());
    }

    protected String makeHead() {
        StringBuilder textBuilder = new StringBuilder();
        textBuilder.append("  <head>\n");
        textBuilder.append("    <style>\n");
        textBuilder.append("      body {\n");
        textBuilder.append("        font-family: verdana;\n        font-size: 14pt;\n");
        textBuilder.append("      }\n");
        textBuilder.append("    </style>\n");
        textBuilder.append("  </head>\n");
        return textBuilder.toString();
    }

    protected String makeBody() {
        StringBuilder textBuilder = new StringBuilder();
        textBuilder.append("  <body style=\"background-color:white;\">\n  <h1>Parameters</h1><br>\n");
        for (InputParameter tab : this.inputParameterMap.getSortedSet()) {
            textBuilder.append("\n  <br>\n  <h2>" + tab.getDescription() + "</h2>\n");
            InputParameterMap tabbedMap = (InputParameterMap)tab;
            for (InputParameter parameter : tabbedMap.getSortedSet()) {
                textBuilder.append("  " + parameter.toString() + "<br>\n");
            }
        }
        textBuilder.append("  </body>\n");
        return textBuilder.toString();
    }
}

