/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TablePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int rows;
    private int columns;

    public TablePanel(int cells) {
        this(TablePanel.calcCols(cells), TablePanel.calcRows(cells));
    }

    public TablePanel(int columns, int rows) {
        this.rows = rows;
        this.columns = columns;
        double[][] tableDefinition = new double[][]{this.refractor(this.columns), this.refractor(this.rows)};
        TableLayout layout = new TableLayout((double[][])tableDefinition);
        this.setLayout((LayoutManager)layout);
    }

    private static int calcRows(int cells) {
        if (cells < 3) {
            return 1;
        }
        if (cells < 7) {
            return 2;
        }
        if (cells < 25) {
            return 4;
        }
        if (cells < 31) {
            return 5;
        }
        return (int)Math.ceil(Math.sqrt(cells));
    }

    private static int calcCols(int cells) {
        if (cells == 1) {
            return 1;
        }
        if (cells < 5) {
            return 2;
        }
        if (cells < 10) {
            return 3;
        }
        if (cells < 17) {
            return 4;
        }
        if (cells < 21) {
            return 5;
        }
        if (cells < 25) {
            return 6;
        }
        if (cells == 25) {
            return 5;
        }
        if (cells < 31) {
            return 6;
        }
        return (int)Math.ceil(Math.sqrt(cells));
    }

    public void setCell(Component container, int column, int row) {
        this.add(container, column + "," + row + ",C,C");
    }

    public void setCell(Component container, int cell) {
        int row = cell / this.columns;
        int column = cell % this.columns;
        this.add(container, column + "," + row + ",C,C");
    }

    private double[] refractor(int value) {
        double[] result = new double[value];
        for (int i = 0; i < result.length; ++i) {
            result[i] = 1.0 / (double)value;
            if (result[i] != 1.0) continue;
            result[i] = -1.0;
        }
        return result;
    }

    public static void main(String[] args) {
        int columns = 5;
        int rows = 10;
        if (args.length != 2) {
            System.out.println("Usage: java nl.tudelft.simulation.dsol.gui.TablePanel [#columns] [#rows]");
        } else {
            columns = Integer.valueOf(args[0]);
            rows = Integer.valueOf(args[1]);
        }
        JFrame app = new JFrame();
        TablePanel content = new TablePanel(columns, rows);
        for (int i = 0; i < columns; ++i) {
            for (int j = 0; j < rows; ++j) {
                content.setCell(new JTextField("x=" + i + " y=" + j), i, j);
            }
        }
        app.setSize(200, 100);
        app.setMinimumSize(new Dimension(200, 100));
        app.setContentPane(content);
        app.pack();
        app.setVisible(true);
    }
}

