/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui.animation;

import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import nl.tudelft.simulation.dsol.animation.gis.GisMapInterface;
import nl.tudelft.simulation.dsol.animation.gis.GisRenderable2D;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.dsol.swing.animation.D2.AnimationPanel;
import nl.tudelft.simulation.dsol.swing.animation.D2.AutoPanAnimationPanel;
import nl.tudelft.simulation.dsol.swing.gui.animation.DSOLAnimationTab;
import nl.tudelft.simulation.dsol.swing.gui.animation.panel.SearchPanel;
import nl.tudelft.simulation.language.DSOLException;
import org.djutils.draw.bounds.Bounds2d;
import org.djutils.logger.CategoryLogger;

public class DSOLAnimationGisTab
extends DSOLAnimationTab {
    private static final long serialVersionUID = 20150617L;
    private Map<String, GisMapInterface> toggleGISMap = new LinkedHashMap<String, GisMapInterface>();
    private Map<String, JToggleButton> toggleGISButtons = new LinkedHashMap<String, JToggleButton>();

    public DSOLAnimationGisTab(Bounds2d homeExtent, SimulatorInterface<?> simulator) throws RemoteException, DSOLException {
        super(homeExtent, simulator);
    }

    public DSOLAnimationGisTab(SimulatorInterface<?> simulator, AnimationPanel animationPanel) throws RemoteException, DSOLException {
        super(simulator, animationPanel);
    }

    public static DSOLAnimationTab createAutoPanTab(Bounds2d homeExtent, SimulatorInterface<?> simulator) throws RemoteException, DSOLException {
        DSOLAnimationTab tab = new DSOLAnimationTab(simulator, new AutoPanAnimationPanel(homeExtent, simulator));
        tab.setSearchPanel(new SearchPanel());
        return tab;
    }

    public void addAllToggleGISButtonText(String header, GisRenderable2D gisMap, String toolTipText) {
        this.addToggleText(" ");
        this.addToggleText(header);
        try {
            for (String layerName : gisMap.getMap().getLayerMap().keySet()) {
                this.addToggleGISButtonText(layerName, layerName, gisMap, toolTipText);
            }
        }
        catch (RemoteException exception) {
            exception.printStackTrace();
        }
    }

    public void addToggleGISButtonText(String layerName, String displayName, GisRenderable2D gisMap, String toolTipText) {
        JCheckBox button = new JCheckBox(displayName);
        button.setName(layerName);
        button.setEnabled(true);
        button.setSelected(true);
        button.setActionCommand(layerName);
        button.setToolTipText(toolTipText);
        button.addActionListener(this);
        JPanel toggleBox = new JPanel();
        toggleBox.setLayout(new BoxLayout(toggleBox, 0));
        toggleBox.add(button);
        this.getTogglePanel().add(toggleBox);
        toggleBox.setAlignmentX(0.0f);
        this.toggleGISMap.put(layerName, gisMap.getMap());
        this.toggleGISButtons.put(layerName, button);
    }

    public void showGISLayer(String layerName) {
        GisMapInterface gisMap = this.toggleGISMap.get(layerName);
        if (gisMap != null) {
            try {
                gisMap.showLayer(layerName);
                this.toggleGISButtons.get(layerName).setSelected(true);
                this.getAnimationPanel().repaint();
            }
            catch (RemoteException exception) {
                exception.printStackTrace();
            }
        }
    }

    public void hideGISLayer(String layerName) {
        GisMapInterface gisMap = this.toggleGISMap.get(layerName);
        if (gisMap != null) {
            try {
                gisMap.hideLayer(layerName);
                this.toggleGISButtons.get(layerName).setSelected(false);
                this.getAnimationPanel().repaint();
            }
            catch (RemoteException exception) {
                exception.printStackTrace();
            }
        }
    }

    public void toggleGISLayer(String layerName) {
        GisMapInterface gisMap = this.toggleGISMap.get(layerName);
        if (gisMap != null) {
            try {
                if (gisMap.getVisibleLayers().contains(gisMap.getLayerMap().get((Object)layerName))) {
                    gisMap.hideLayer(layerName);
                    this.toggleGISButtons.get(layerName).setSelected(false);
                } else {
                    gisMap.showLayer(layerName);
                    this.toggleGISButtons.get(layerName).setSelected(true);
                }
                this.getAnimationPanel().repaint();
            }
            catch (RemoteException exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        try {
            if (this.toggleGISMap.containsKey(actionCommand)) {
                this.toggleGISLayer(actionCommand);
                this.getTogglePanel().repaint();
            }
            super.actionPerformed(actionEvent);
        }
        catch (Exception exception) {
            CategoryLogger.always().warn((Throwable)exception);
        }
    }
}

