/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui.animation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import nl.tudelft.simulation.dsol.animation.Locatable;
import nl.tudelft.simulation.dsol.experiment.Replication;
import nl.tudelft.simulation.dsol.simulators.AnimatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.dsol.swing.animation.D2.AnimationPanel;
import nl.tudelft.simulation.dsol.swing.animation.D2.AutoPanAnimationPanel;
import nl.tudelft.simulation.dsol.swing.gui.animation.panel.ButtonPanel;
import nl.tudelft.simulation.dsol.swing.gui.animation.panel.InfoTextPanel;
import nl.tudelft.simulation.dsol.swing.gui.animation.panel.PropertiesPanel;
import nl.tudelft.simulation.dsol.swing.gui.animation.panel.SearchPanel;
import nl.tudelft.simulation.dsol.swing.gui.animation.panel.TogglePanel;
import nl.tudelft.simulation.dsol.swing.gui.util.Icons;
import nl.tudelft.simulation.language.DSOLException;
import org.djutils.draw.bounds.Bounds2d;
import org.djutils.event.Event;
import org.djutils.event.EventListener;
import org.djutils.event.TimedEvent;

public class DSOLAnimationTab
extends JPanel
implements ActionListener,
EventListener {
    private static final long serialVersionUID = 20150617L;
    private final SimulatorInterface<?> simulator;
    private final JPanel borderPanel;
    private final AnimationPanel animationPanel;
    private JPanel animationControlPanel;
    private TogglePanel togglePanel;
    private ButtonPanel buttonPanel;
    private SearchPanel searchPanel = null;
    private InfoTextPanel infoTextPanel = null;
    private PropertiesPanel propertiesPanel = null;
    private Map<String, Class<? extends Locatable>> toggleLocatableMap = new LinkedHashMap<String, Class<? extends Locatable>>();
    private Map<Class<? extends Locatable>, JToggleButton> toggleButtons = new LinkedHashMap<Class<? extends Locatable>, JToggleButton>();

    public DSOLAnimationTab(Bounds2d homeExtent, SimulatorInterface<?> simulator) throws RemoteException, DSOLException {
        this(simulator, new AnimationPanel(homeExtent, simulator));
    }

    public DSOLAnimationTab(SimulatorInterface<?> simulator, AnimationPanel animationPanel) throws RemoteException, DSOLException {
        this.setPreferredSize(new Dimension(1024, 768));
        if (!(simulator instanceof AnimatorInterface)) {
            throw new DSOLException("DSOLAnimationTab: simulator is not an instance of AnimatorInterface");
        }
        this.simulator = simulator;
        this.animationPanel = animationPanel;
        this.borderPanel = new JPanel(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.borderPanel, "Center");
        this.init();
    }

    public static DSOLAnimationTab createAutoPanTab(Bounds2d homeExtent, SimulatorInterface<?> simulator) throws RemoteException, DSOLException {
        DSOLAnimationTab tab = new DSOLAnimationTab(simulator, new AutoPanAnimationPanel(homeExtent, simulator));
        tab.setSearchPanel(new SearchPanel());
        return tab;
    }

    public void init() throws RemoteException {
        this.animationPanel.showGrid(true);
        this.borderPanel.add((Component)this.animationPanel, "Center");
        this.togglePanel = new TogglePanel(this);
        this.borderPanel.add((Component)this.togglePanel, "West");
        this.animationControlPanel = new JPanel();
        this.animationControlPanel.setLayout(new BoxLayout(this.animationControlPanel, 0));
        this.borderPanel.add((Component)this.animationControlPanel, "North");
        this.buttonPanel = new ButtonPanel(this.animationPanel);
        this.animationControlPanel.add(this.buttonPanel);
        this.infoTextPanel = new InfoTextPanel(this.animationPanel);
        this.animationControlPanel.add(this.infoTextPanel);
        this.animationPanel.notify((Event)new TimedEvent(Replication.START_REPLICATION_EVENT, null, (Comparable)((Object)this.simulator.getSimulatorTime())));
        this.animationPanel.setShowToolTip(false);
    }

    public void setSearchPanel(SearchPanel searchPanel) {
        if (this.searchPanel != null) {
            this.animationControlPanel.remove(this.searchPanel);
            this.searchPanel.removeListener(this.animationPanel, SearchPanel.ANIMATION_SEARCH_OBJECT_EVENT);
            if (this.propertiesPanel != null) {
                this.searchPanel.removeListener(this.propertiesPanel, SearchPanel.ANIMATION_SEARCH_OBJECT_EVENT);
            }
        }
        searchPanel.addListener(this.animationPanel, SearchPanel.ANIMATION_SEARCH_OBJECT_EVENT);
        if (this.propertiesPanel != null) {
            this.searchPanel.addListener(this.propertiesPanel, SearchPanel.ANIMATION_SEARCH_OBJECT_EVENT);
        }
        this.searchPanel = searchPanel;
        this.searchPanel.setMinimumSize(new Dimension(500, 10));
        this.searchPanel.setPreferredSize(new Dimension(500, 10));
        this.searchPanel.setMaximumSize(new Dimension(500, 30));
        this.animationControlPanel.add(Box.createHorizontalGlue());
        this.animationControlPanel.add(this.searchPanel);
    }

    public void addToggleAnimationButtonIcon(String name, Class<? extends Locatable> locatableClass, String iconPath, String toolTipText, boolean initiallyVisible, boolean idButton) {
        Icon icon = Icons.loadIcon(iconPath);
        Icon unIcon = Icons.loadGrayscaleIcon(iconPath);
        JCheckBox button = new JCheckBox();
        button.setSelectedIcon(icon);
        button.setIcon(unIcon);
        button.setPreferredSize(new Dimension(32, 28));
        button.setName(name);
        button.setEnabled(true);
        button.setSelected(initiallyVisible);
        button.setActionCommand(name);
        button.setToolTipText(toolTipText);
        button.addActionListener(this);
        if (idButton && this.togglePanel.getComponentCount() > 0) {
            JPanel lastToggleBox = (JPanel)this.togglePanel.getComponent(this.togglePanel.getComponentCount() - 1);
            lastToggleBox.add(button);
        } else {
            JPanel toggleBox = new JPanel();
            toggleBox.setLayout(new BoxLayout(toggleBox, 0));
            toggleBox.add(button);
            this.togglePanel.add(toggleBox);
            toggleBox.setAlignmentX(0.0f);
        }
        if (initiallyVisible) {
            this.animationPanel.showClass(locatableClass);
        } else {
            this.animationPanel.hideClass(locatableClass);
        }
        this.toggleLocatableMap.put(name, locatableClass);
        this.toggleButtons.put(locatableClass, button);
    }

    public void addToggleAnimationButtonText(String name, Class<? extends Locatable> locatableClass, String toolTipText, boolean initiallyVisible) {
        JCheckBox button = new JCheckBox(name);
        button.setName(name);
        button.setEnabled(true);
        button.setSelected(initiallyVisible);
        button.setActionCommand(name);
        button.setToolTipText(toolTipText);
        button.addActionListener(this);
        JPanel toggleBox = new JPanel();
        toggleBox.setLayout(new BoxLayout(toggleBox, 0));
        toggleBox.add(button);
        this.togglePanel.add(toggleBox);
        toggleBox.setAlignmentX(0.0f);
        if (initiallyVisible) {
            this.animationPanel.showClass(locatableClass);
        } else {
            this.animationPanel.hideClass(locatableClass);
        }
        this.toggleLocatableMap.put(name, locatableClass);
        this.toggleButtons.put(locatableClass, button);
    }

    public void addToggleText(String text) {
        JPanel textBox = new JPanel();
        textBox.setLayout(new BoxLayout(textBox, 0));
        textBox.add(new JLabel(text));
        this.togglePanel.add(textBox);
        textBox.setAlignmentX(0.0f);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        try {
            if (this.toggleLocatableMap.containsKey(actionCommand)) {
                Class<? extends Locatable> locatableClass = this.toggleLocatableMap.get(actionCommand);
                this.animationPanel.toggleClass(locatableClass);
                this.togglePanel.repaint();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public AnimationPanel getAnimationPanel() {
        return this.animationPanel;
    }

    public JPanel getTogglePanel() {
        return this.togglePanel;
    }

    public SearchPanel getSearchPanel() {
        return this.searchPanel;
    }

    public void updateAnimationClassCheckBox(Class<? extends Locatable> locatableClass) {
        JToggleButton button = this.toggleButtons.get(locatableClass);
        if (button == null) {
            return;
        }
        button.setSelected(this.getAnimationPanel().isShowClass(locatableClass));
    }

    public SimulatorInterface<?> getSimulator() {
        return this.simulator;
    }

    public void notify(Event event) throws RemoteException {
    }
}

