/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui.animation.panel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import nl.tudelft.simulation.dsol.swing.ButtonUtil;
import nl.tudelft.simulation.dsol.swing.animation.D2.AnimationPanel;
import org.djutils.logger.CategoryLogger;

public class ButtonPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 20210214L;
    private final AnimationPanel animationPanel;

    public ButtonPanel(AnimationPanel animationPanel) {
        this.animationPanel = animationPanel;
        this.init();
    }

    public void init() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(ButtonUtil.makeButton(this, "allButton", "/resources/Expand.png", "ZoomAll", "Zoom whole network", true));
        this.add(ButtonUtil.makeButton(this, "homeButton", "/resources/Home.png", "Home", "Zoom to original extent", true));
        this.add(ButtonUtil.makeButton(this, "gridButton", "/resources/Grid.png", "Grid", "Toggle grid on/off", true));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        try {
            if (actionCommand.equals("Home")) {
                this.animationPanel.home();
            }
            if (actionCommand.equals("ZoomAll")) {
                this.animationPanel.zoomAll();
            }
            if (actionCommand.equals("Grid")) {
                this.animationPanel.showGrid(!this.animationPanel.isShowGrid());
            }
        }
        catch (Exception exception) {
            CategoryLogger.always().warn((Throwable)exception);
        }
    }
}

