/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui.animation.panel;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import nl.tudelft.simulation.dsol.swing.animation.D2.AnimationPanel;

public class InfoTextPanel
extends JPanel {
    private static final long serialVersionUID = 20210214L;
    private final AnimationPanel animationPanel;
    private JLabel coordinateField;
    private static final NumberFormat COORDINATE_FORMATTER = NumberFormat.getInstance();
    private NumberFormat coordinateFormatter = NumberFormat.getInstance();

    public InfoTextPanel(AnimationPanel animationPanel) {
        this.animationPanel = animationPanel;
        this.coordinateFormatter = COORDINATE_FORMATTER;
        this.init();
    }

    public void init() {
        this.setMinimumSize(new Dimension(250, 35));
        this.setPreferredSize(new Dimension(250, 35));
        this.setLayout(new BoxLayout(this, 1));
        this.coordinateField = new JLabel("Mouse: ");
        this.coordinateField.setMinimumSize(new Dimension(250, 10));
        this.coordinateField.setPreferredSize(new Dimension(250, 10));
        this.add(this.coordinateField);
        new UpdateTimer().start();
    }

    public void updateWorldCoordinate() {
        String worldPoint = "(x=" + this.coordinateFormatter.format(this.animationPanel.getWorldCoordinate().getX()) + " ; y=" + this.coordinateFormatter.format(this.animationPanel.getWorldCoordinate().getY()) + ")";
        this.coordinateField.setText("Mouse: " + worldPoint);
        int requiredWidth = this.coordinateField.getGraphics().getFontMetrics().stringWidth(this.coordinateField.getText());
        if (this.coordinateField.getPreferredSize().width < requiredWidth) {
            Dimension requiredSize = new Dimension(requiredWidth, this.coordinateField.getPreferredSize().height);
            this.coordinateField.setPreferredSize(requiredSize);
            this.coordinateField.setMinimumSize(requiredSize);
            Container parent = this.coordinateField.getParent();
            parent.setPreferredSize(requiredSize);
            parent.setMinimumSize(requiredSize);
            parent.revalidate();
        }
        this.coordinateField.repaint();
    }

    public NumberFormat getCoordinateFormatter() {
        return this.coordinateFormatter;
    }

    public void setCoordinateFormatter(NumberFormat coordinateFormatter) {
        this.coordinateFormatter = coordinateFormatter;
    }

    static {
        COORDINATE_FORMATTER.setMaximumFractionDigits(3);
    }

    protected class UpdateTimer
    extends Thread {
        protected boolean closing = false;

        protected UpdateTimer() {
        }

        @Override
        public void run() {
            Window window = null;
            while (!this.closing) {
                if (window == null && (window = SwingUtilities.getWindowAncestor(InfoTextPanel.this)) != null) {
                    window.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            UpdateTimer.this.closing = true;
                            super.windowClosing(e);
                        }
                    });
                }
                if (InfoTextPanel.this.isShowing()) {
                    InfoTextPanel.this.updateWorldCoordinate();
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        @Override
        public String toString() {
            return "UpdateTimer thread for InfoTextPanel";
        }
    }
}

