/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui.animation.panel;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import nl.tudelft.simulation.dsol.animation.Locatable;
import nl.tudelft.simulation.dsol.swing.gui.appearance.AppearanceControl;
import nl.tudelft.simulation.dsol.swing.gui.util.Icons;
import org.djutils.event.Event;
import org.djutils.event.EventListener;
import org.djutils.event.EventListenerMap;
import org.djutils.event.EventProducer;
import org.djutils.event.EventType;
import org.djutils.event.LocalEventProducer;
import org.djutils.event.reference.ReferenceType;
import org.djutils.metadata.MetaData;
import org.djutils.metadata.ObjectDescriptor;

public class SearchPanel
extends JPanel
implements ActionListener,
FocusListener,
DocumentListener,
EventProducer {
    private static final long serialVersionUID = 20200127L;
    private JComboBox<ObjectKind<?>> typeToSearch;
    private final List<ObjectKind<?>> objectKindList;
    private final JTextField idTextField;
    private final JCheckBox trackObject;
    private final SearchPanelEventProducer searchPanelEventProducer = new SearchPanelEventProducer();
    public static final EventType ANIMATION_SEARCH_OBJECT_EVENT = new EventType(new MetaData("ANIMATION_SEARCH_OBJECT_EVENT", "ANIMATION_SEARCH_OBJECT_EVENT", new ObjectDescriptor[]{new ObjectDescriptor("objectKind", "object kind key", ObjectKind.class), new ObjectDescriptor("objectId", "object id", String.class), new ObjectDescriptor("track", "track the object or not", Boolean.class)}));

    public SearchPanel() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel("    "));
        this.add(new JLabel(Icons.loadIcon("/resources/Search.png")));
        this.objectKindList = new ArrayList();
        this.typeToSearch = new JComboBox<ObjectKind>(new ObjectKind[0]);
        this.add(this.typeToSearch);
        class AppearanceControlTextField
        extends JTextField
        implements AppearanceControl {
            private static final long serialVersionUID = 20180207L;

            AppearanceControlTextField() {
            }

            @Override
            public boolean isForeground() {
                return false;
            }

            @Override
            public boolean isBackground() {
                return false;
            }

            @Override
            public String toString() {
                return "AppearanceControlLabel []";
            }
        }
        this.idTextField = new AppearanceControlTextField();
        this.idTextField.setPreferredSize(new Dimension(100, 0));
        this.add(this.idTextField);
        this.trackObject = new JCheckBox("track");
        this.add(this.trackObject);
        this.trackObject.setActionCommand("Tracking status changed");
        this.idTextField.setActionCommand("Id changed");
        this.typeToSearch.setActionCommand("Type changed");
        this.trackObject.addActionListener(this);
        this.idTextField.addActionListener(this);
        this.typeToSearch.addActionListener(this);
        this.idTextField.addFocusListener(this);
        this.idTextField.getDocument().addDocumentListener(this);
    }

    public void addObjectKind(ObjectKind<?> objectKind) {
        this.objectKindList.add(objectKind);
        this.typeToSearch = new JComboBox<ObjectKind>(this.objectKindList.toArray(new ObjectKind[0]));
        this.typeToSearch.invalidate();
    }

    public void selectAndTrackObject(String objectKey, String objectId, boolean track) {
        int index = this.typeToSearch.getItemCount();
        while (--index >= 0) {
            if (!this.typeToSearch.getItemAt(index).getKey().equals(objectKey)) continue;
            this.typeToSearch.setSelectedIndex(index);
        }
        this.trackObject.setSelected(track);
        this.idTextField.setText(objectId);
        this.actionPerformed(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.searchPanelEventProducer.fireEvent(new Event(ANIMATION_SEARCH_OBJECT_EVENT, (Serializable)new Object[]{(ObjectKind)this.typeToSearch.getSelectedItem(), this.idTextField.getText(), this.trackObject.isSelected()}));
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.actionPerformed(null);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.actionPerformed(null);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.actionPerformed(null);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.actionPerformed(null);
    }

    public SearchPanelEventProducer getSearchPanelEventProducer() {
        return this.searchPanelEventProducer;
    }

    public boolean addListener(EventListener listener, EventType eventType) {
        return this.searchPanelEventProducer.addListener(listener, eventType);
    }

    public boolean addListener(EventListener listener, EventType eventType, ReferenceType referenceType) {
        return this.searchPanelEventProducer.addListener(listener, eventType, referenceType);
    }

    public boolean addListener(EventListener listener, EventType eventType, int position) {
        return this.searchPanelEventProducer.addListener(listener, eventType, position);
    }

    public boolean addListener(EventListener listener, EventType eventType, int position, ReferenceType referenceType) {
        return this.searchPanelEventProducer.addListener(listener, eventType, position, referenceType);
    }

    public boolean removeListener(EventListener listener, EventType eventType) {
        return this.searchPanelEventProducer.removeListener(listener, eventType);
    }

    public int removeAllListeners() {
        return this.searchPanelEventProducer.removeAllListeners();
    }

    public EventListenerMap getEventListenerMap() throws RemoteException {
        return this.searchPanelEventProducer.getEventListenerMap();
    }

    class SearchPanelEventProducer
    extends LocalEventProducer {
        private static final long serialVersionUID = 20210213L;

        SearchPanelEventProducer() {
        }

        public void fireEvent(Event event) {
            super.fireEvent(event);
        }
    }

    public static abstract class ObjectKind<T extends Locatable> {
        private final String key;

        public ObjectKind(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public abstract T searchObject(String var1);

        public String toString() {
            return this.key;
        }
    }
}

