/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui.control;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import nl.tudelft.simulation.dsol.SimRuntimeException;
import nl.tudelft.simulation.dsol.experiment.Replication;
import nl.tudelft.simulation.dsol.model.DSOLModel;
import nl.tudelft.simulation.dsol.simulators.RunState;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.dsol.swing.gui.appearance.AppearanceControlButton;
import nl.tudelft.simulation.dsol.swing.gui.control.ClockPanel;
import nl.tudelft.simulation.dsol.swing.gui.control.RunUntilPanel;
import nl.tudelft.simulation.dsol.swing.gui.control.SpeedPanel;
import nl.tudelft.simulation.dsol.swing.gui.util.Icons;
import org.djutils.event.Event;
import org.djutils.event.EventListener;
import org.djutils.exceptions.Throw;

public abstract class AbstractControlPanel<T extends Number, S extends SimulatorInterface<T>>
extends JPanel
implements ActionListener,
WindowListener,
EventListener {
    private static final long serialVersionUID = 20150617L;
    private S simulator;
    private final DSOLModel<T, ? extends SimulatorInterface<T>> model;
    private ClockPanel<T> clockPanel;
    private SpeedPanel<T> speedPanel;
    private RunUntilPanel<T> runUntilPanel;
    private final ArrayList<JButton> controlButtons = new ArrayList();
    private final JPanel controlButtonsPanel;
    private boolean controlButtonsEnabled = false;
    private boolean closeHandlerRegistered = false;
    private boolean isCleanUp = false;

    public AbstractControlPanel(DSOLModel<T, ? extends SimulatorInterface<T>> model, S simulator) throws RemoteException {
        Throw.whenNull(model, (String)"model cannot be null");
        Throw.whenNull(simulator, (String)"simulator cannot be null");
        this.model = model;
        this.simulator = simulator;
        this.setLayout(new FlowLayout(0));
        this.controlButtonsPanel = new JPanel();
        this.controlButtonsPanel.setLayout(new BoxLayout(this.controlButtonsPanel, 0));
        this.controlButtonsPanel.add(this.makeButton("resetButton", "/resources/Reset.png", "Reset", "Reset the simulation", false));
        this.controlButtonsPanel.add(this.makeButton("runPauseButton", "/resources/Run.png", "RunPause", "Run or pause the simulation", true));
        this.add(this.controlButtonsPanel);
        this.fixButtons();
        this.installWindowCloseHandler();
        this.simulator.addListener((EventListener)this, Replication.END_REPLICATION_EVENT);
        this.simulator.addListener((EventListener)this, SimulatorInterface.START_EVENT);
        this.simulator.addListener((EventListener)this, SimulatorInterface.STOP_EVENT);
    }

    public void setControlButtonsState(boolean newState) {
        this.controlButtonsEnabled = newState;
        this.fixButtons();
    }

    protected JButton makeButton(String name, String iconPath, String actionCommand, String toolTipText, boolean enabled) {
        AppearanceControlButton result = new AppearanceControlButton(Icons.loadIcon(iconPath));
        result.setName(name);
        result.setEnabled(enabled);
        result.setActionCommand(actionCommand);
        result.setToolTipText(toolTipText);
        result.addActionListener(this);
        this.controlButtons.add(result);
        return result;
    }

    public void installWindowCloseHandler() {
        if (this.closeHandlerRegistered) {
            return;
        }
        new DisposeOnCloseThread(this).start();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        try {
            if (actionCommand.equals("RunPause")) {
                if (this.simulator.isStartingOrRunning()) {
                    this.simulator.stop();
                } else if (this.getSimulator().getRunState() != RunState.ENDED) {
                    this.simulator.start();
                }
            } else if (actionCommand.equals("Reset")) {
                if (this.getSimulator().isStartingOrRunning()) {
                    this.getSimulator().stop();
                }
                if (null == this.getModel()) {
                    throw new RuntimeException("Do not know how to restart this simulation");
                }
                Container root = this;
                while (!(root instanceof JFrame)) {
                    root = root.getParent();
                }
                JFrame frame = (JFrame)root;
                frame.setDefaultCloseOperation(2);
                frame.dispose();
                this.cleanup();
                this.model.constructModel();
            }
            this.fixButtons();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void cleanup() {
        if (!this.isCleanUp) {
            this.isCleanUp = true;
            try {
                if (this.simulator != null) {
                    if (this.simulator.isStartingOrRunning()) {
                        this.simulator.stop();
                    }
                    if (this.getSimulator().getReplication().getContext().hasKey("animation")) {
                        this.getSimulator().getReplication().getContext().destroySubcontext("animation");
                    }
                    if (this.getSimulator().getReplication().getContext().hasKey("statistics")) {
                        this.getSimulator().getReplication().getContext().destroySubcontext("statistics");
                    }
                    if (this.getSimulator().getReplication().getContext().hasKey("statistics")) {
                        this.getSimulator().getReplication().getContext().destroySubcontext("statistics");
                    }
                }
                if (this.clockPanel != null) {
                    this.clockPanel.cancelTimer();
                }
                if (this.speedPanel != null) {
                    this.speedPanel.cancelTimer();
                }
            }
            catch (Throwable exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void fixButtons() {
        boolean moreWorkToDo = this.getSimulator().getRunState() != RunState.ENDED;
        for (JButton button : this.controlButtons) {
            String actionCommand = button.getActionCommand();
            if (actionCommand.equals("RunPause")) {
                button.setEnabled(moreWorkToDo && this.controlButtonsEnabled);
                if (this.simulator.isStartingOrRunning()) {
                    button.setToolTipText("Pause the simulation");
                    button.setIcon(Icons.loadIcon("/resources/Pause.png"));
                } else {
                    button.setToolTipText("Run the simulation at the indicated speed");
                    button.setIcon(Icons.loadIcon("/resources/Run.png"));
                }
                button.setEnabled(moreWorkToDo && this.controlButtonsEnabled);
                continue;
            }
            if (!actionCommand.equals("Reset")) continue;
            button.setEnabled(false);
        }
    }

    protected void invalidateButtons() {
        for (JButton button : this.controlButtons) {
            String actionCommand = button.getActionCommand();
            if (!actionCommand.equals("RunPause")) continue;
            button.setToolTipText("Run the simulation at the indicated speed");
            button.setIcon(Icons.loadIcon("/resources/Run.png"));
            button.setEnabled(false);
        }
    }

    public DSOLModel<T, ? extends SimulatorInterface<T>> getModel() {
        return this.model;
    }

    public S getSimulator() {
        return this.simulator;
    }

    public ClockPanel<T> getClockPanel() {
        return this.clockPanel;
    }

    public void setClockPanel(ClockPanel<T> clockPanel) {
        if (this.clockPanel != null) {
            this.remove(this.clockPanel);
            this.clockPanel.cancelTimer();
        }
        this.clockPanel = clockPanel;
        this.add((Component)this.clockPanel, 1);
    }

    public SpeedPanel<T> getSpeedPanel() {
        return this.speedPanel;
    }

    public void setSpeedPanel(SpeedPanel<T> speedPanel) {
        if (this.speedPanel != null) {
            this.remove(this.speedPanel);
            this.speedPanel.cancelTimer();
        }
        this.speedPanel = speedPanel;
        if (this.clockPanel != null) {
            this.add((Component)this.speedPanel, 2);
        } else {
            this.add((Component)this.speedPanel, 1);
        }
    }

    public ArrayList<JButton> getControlButtons() {
        return this.controlButtons;
    }

    public JPanel getControlButtonsPanel() {
        return this.controlButtonsPanel;
    }

    public RunUntilPanel<T> getRunUntilPanel() {
        return this.runUntilPanel;
    }

    public void setRunUntilPanel(RunUntilPanel<T> runUntilPanel) {
        if (this.runUntilPanel != null) {
            this.remove(this.runUntilPanel);
        }
        this.runUntilPanel = runUntilPanel;
        this.add(this.runUntilPanel);
    }

    public boolean isCloseHandlerRegistered() {
        return this.closeHandlerRegistered;
    }

    public boolean isControlButtonsEnabled() {
        return this.controlButtonsEnabled;
    }

    public void setCloseHandlerRegistered(boolean closeHandlerRegistered) {
        this.closeHandlerRegistered = closeHandlerRegistered;
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.simulator != null) {
            try {
                if (this.simulator.isStartingOrRunning()) {
                    this.simulator.stop();
                }
            }
            catch (SimRuntimeException exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.cleanup();
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public void notify(Event event) throws RemoteException {
        if (event.getType().equals((Object)SimulatorInterface.START_EVENT) || event.getType().equals((Object)SimulatorInterface.STOP_EVENT)) {
            this.fixButtons();
        }
        if (event.getType().equals((Object)Replication.END_REPLICATION_EVENT)) {
            this.invalidateButtons();
        }
    }

    @Override
    public String toString() {
        return "ControlPanel [simulatorTime=" + this.simulator.getSimulatorTime() + "]";
    }

    protected class DisposeOnCloseThread
    extends Thread {
        private AbstractControlPanel<T, S> panel;

        public DisposeOnCloseThread(AbstractControlPanel<T, S> panel) {
            this.panel = panel;
        }

        @Override
        public void run() {
            Container root = this.panel;
            while (!(root instanceof JFrame)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                root = this.panel;
                while (null != root.getParent() && !(root instanceof JFrame)) {
                    root = root.getParent();
                }
            }
            JFrame frame = (JFrame)root;
            frame.addWindowListener(this.panel);
            AbstractControlPanel.this.setCloseHandlerRegistered(true);
        }

        @Override
        public String toString() {
            return "DisposeOnCloseThread [panel=" + this.panel + "]";
        }
    }
}

