/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui.control;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.Serializable;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JLabel;
import javax.swing.JPanel;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.dsol.swing.gui.appearance.AppearanceControl;
import nl.tudelft.simulation.dsol.swing.gui.appearance.AppearanceControlLabel;
import org.djunits.value.vdouble.scalar.Duration;
import org.djunits.value.vfloat.scalar.FloatDuration;

public abstract class ClockPanel<T extends Number>
extends JPanel
implements AppearanceControl {
    private static final long serialVersionUID = 20141211L;
    public JLabel timeLabel;
    final SimulatorInterface<T> simulator;
    private Font timeFont = new Font("SansSerif", 1, 18);
    private Timer timer;
    private long updateInterval = 1000L;
    private T prevSimTime;

    public ClockPanel(SimulatorInterface<T> simulator) {
        this.simulator = simulator;
        this.setLayout(new FlowLayout(0));
        this.setFont(this.getTimeFont());
        this.timeLabel = new AppearanceControlLabel();
        this.timeLabel.setFont(this.getTimeFont());
        this.timeLabel.setMaximumSize(new Dimension(150, 35));
        this.add(this.timeLabel);
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)new TimeUpdateTask(), 0L, this.updateInterval);
    }

    public void cancelTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
    }

    public JLabel getTimeLabel() {
        return this.timeLabel;
    }

    public SimulatorInterface<T> getSimulator() {
        return this.simulator;
    }

    public Font getTimeFont() {
        return this.timeFont;
    }

    public long getUpdateInterval() {
        return this.updateInterval;
    }

    public T getPrevSimTime() {
        return this.prevSimTime;
    }

    protected void setPrevSimTime(T prevSimTime) {
        this.prevSimTime = prevSimTime;
    }

    protected abstract String formatSimulationTime(T var1);

    @Override
    public boolean isForeground() {
        return true;
    }

    @Override
    public String toString() {
        return "ClockPanel";
    }

    public static class TimeFloatUnit
    extends ClockPanel<FloatDuration> {
        private static final long serialVersionUID = 20201227L;

        public TimeFloatUnit(SimulatorInterface<FloatDuration> simulator) {
            super(simulator);
            this.setPrevSimTime(FloatDuration.ZERO);
        }

        @Override
        protected String formatSimulationTime(FloatDuration simulationTime) {
            return "t = " + simulationTime.toString(false, true);
        }
    }

    public static class TimeDoubleUnit
    extends ClockPanel<Duration> {
        private static final long serialVersionUID = 20201227L;

        public TimeDoubleUnit(SimulatorInterface<Duration> simulator) {
            super(simulator);
            this.setPrevSimTime(Duration.ZERO);
        }

        @Override
        protected String formatSimulationTime(Duration simulationTime) {
            return "t = " + simulationTime.toString(false, true);
        }
    }

    public static class TimeLong
    extends ClockPanel<Long> {
        private static final long serialVersionUID = 20201227L;

        public TimeLong(SimulatorInterface<Long> simulator) {
            super(simulator);
            this.setPrevSimTime(0L);
        }

        @Override
        protected String formatSimulationTime(Long simulationTime) {
            return String.format(" t = %8d ", simulationTime);
        }
    }

    public static class TimeFloat
    extends ClockPanel<Float> {
        private static final long serialVersionUID = 20201227L;

        public TimeFloat(SimulatorInterface<Float> simulator) {
            super(simulator);
            this.setPrevSimTime(Float.valueOf(0.0f));
        }

        @Override
        protected String formatSimulationTime(Float simulationTime) {
            return String.format(" t = %8.2f ", simulationTime);
        }
    }

    public static class TimeDouble
    extends ClockPanel<Double> {
        private static final long serialVersionUID = 20201227L;

        public TimeDouble(SimulatorInterface<Double> simulator) {
            super(simulator);
            this.setPrevSimTime(0.0);
        }

        @Override
        protected String formatSimulationTime(Double simulationTime) {
            return String.format(" t = %8.2f ", simulationTime);
        }
    }

    protected class TimeUpdateTask
    extends TimerTask
    implements Serializable {
        private static final long serialVersionUID = 20140000L;

        protected TimeUpdateTask() {
        }

        @Override
        public void run() {
            Number simulationTime = ClockPanel.this.getSimulator().getSimulatorTime();
            ClockPanel.this.getTimeLabel().setText(ClockPanel.this.formatSimulationTime(simulationTime));
            ClockPanel.this.getTimeLabel().repaint();
        }

        public String toString() {
            return "TimeUpdateTask of ClockPanel";
        }
    }
}

