/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui.control;

import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import nl.tudelft.simulation.dsol.SimRuntimeException;
import nl.tudelft.simulation.dsol.formalisms.eventscheduling.SimEvent;
import nl.tudelft.simulation.dsol.model.DSOLModel;
import nl.tudelft.simulation.dsol.simulators.DevsSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.RunState;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.dsol.swing.gui.control.AbstractControlPanel;
import nl.tudelft.simulation.dsol.swing.gui.control.ClockPanel;
import nl.tudelft.simulation.dsol.swing.gui.control.RunUntilPanel;
import nl.tudelft.simulation.dsol.swing.gui.control.SpeedPanel;
import org.djunits.value.vdouble.scalar.Duration;
import org.djunits.value.vfloat.scalar.FloatDuration;

public class DEVSControlPanel<T extends Number, S extends DevsSimulatorInterface<T>>
extends AbstractControlPanel<T, S> {
    private static final long serialVersionUID = 20201227L;
    private SimEvent<T> stopAtEvent = null;

    public DEVSControlPanel(DSOLModel<T, ? extends DevsSimulatorInterface<T>> model, S simulator) throws RemoteException {
        super(model, simulator);
        this.getControlButtonsPanel().add(this.makeButton("stepButton", "/resources/Step.png", "Step", "Execute one event", true));
        this.getControlButtonsPanel().add(this.makeButton("nextTimeButton", "/resources/StepTime.png", "NextTime", "Execute all events scheduled for the current time", true));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block7: {
            String actionCommand = actionEvent.getActionCommand();
            try {
                if (actionCommand.equals("Step")) {
                    if (((DevsSimulatorInterface)this.getSimulator()).isStartingOrRunning()) {
                        ((DevsSimulatorInterface)this.getSimulator()).stop();
                    }
                    ((DevsSimulatorInterface)this.getSimulator()).step();
                }
                if (!actionCommand.equals("NextTime")) break block7;
                if (((DevsSimulatorInterface)this.getSimulator()).isStartingOrRunning()) {
                    ((DevsSimulatorInterface)this.getSimulator()).stop();
                }
                Number now = ((DevsSimulatorInterface)this.getSimulator()).getSimulatorTime();
                try {
                    this.stopAtEvent = new SimEvent(now, 1, (Object)this, "autoPauseSimulator", null);
                    ((DevsSimulatorInterface)this.getSimulator()).scheduleEvent(this.stopAtEvent);
                }
                catch (SimRuntimeException exception) {
                    ((DevsSimulatorInterface)this.getSimulator()).getLogger().always().error("Caught an exception while trying to schedule an autoPauseSimulator event at the current simulator time");
                }
                ((DevsSimulatorInterface)this.getSimulator()).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        super.actionPerformed(actionEvent);
    }

    @Override
    protected void fixButtons() {
        boolean moreWorkToDo = ((DevsSimulatorInterface)this.getSimulator()).getRunState() != RunState.ENDED;
        for (JButton button : this.getControlButtons()) {
            String actionCommand = button.getActionCommand();
            if (actionCommand.equals("Step")) {
                button.setEnabled(moreWorkToDo && this.isControlButtonsEnabled());
                continue;
            }
            if (!actionCommand.equals("NextTime")) continue;
            button.setEnabled(moreWorkToDo && this.isControlButtonsEnabled());
        }
        super.fixButtons();
    }

    @Override
    protected void invalidateButtons() {
        for (JButton button : this.getControlButtons()) {
            String actionCommand = button.getActionCommand();
            if (actionCommand.equals("Step")) {
                button.setEnabled(false);
                continue;
            }
            if (!actionCommand.equals("NextTime")) continue;
            button.setEnabled(false);
        }
        super.invalidateButtons();
    }

    public void autoPauseSimulator() {
        if (((DevsSimulatorInterface)this.getSimulator()).isStartingOrRunning()) {
            try {
                ((DevsSimulatorInterface)this.getSimulator()).stop();
            }
            catch (SimRuntimeException exception1) {
                exception1.printStackTrace();
            }
            Number currentTick = ((DevsSimulatorInterface)this.getSimulator()).getSimulatorTime();
            Number nextTick = ((DevsSimulatorInterface)this.getSimulator()).getEventList().first().getAbsoluteExecutionTime();
            if (((Comparable)((Object)nextTick)).compareTo(currentTick) > 0) {
                try {
                    this.stopAtEvent = new SimEvent(nextTick, 10, (Object)this, "autoPauseSimulator", null);
                    ((DevsSimulatorInterface)this.getSimulator()).scheduleEvent(this.stopAtEvent);
                    ((DevsSimulatorInterface)this.getSimulator()).start();
                }
                catch (SimRuntimeException exception) {
                    ((DevsSimulatorInterface)this.getSimulator()).getLogger().always().error("Caught an exception while trying to re-schedule an autoPauseEvent at the next real event");
                }
            } else if (SwingUtilities.isEventDispatchThread()) {
                this.fixButtons();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            DEVSControlPanel.this.fixButtons();
                        }
                    });
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        System.out.println("Caught " + e);
                    }
                    e.printStackTrace();
                }
            }
        }
    }

    public static class TimeFloatUnit
    extends DEVSControlPanel<FloatDuration, DevsSimulatorInterface<FloatDuration>> {
        private static final long serialVersionUID = 20201227L;

        public TimeFloatUnit(DSOLModel<FloatDuration, ? extends DevsSimulatorInterface<FloatDuration>> model, DevsSimulatorInterface<FloatDuration> simulator) throws RemoteException {
            super(model, simulator);
            this.setClockPanel(new ClockPanel.TimeFloatUnit((SimulatorInterface<FloatDuration>)this.getSimulator()));
            this.setSpeedPanel(new SpeedPanel.TimeFloatUnit((SimulatorInterface<FloatDuration>)this.getSimulator()));
            this.setRunUntilPanel(new RunUntilPanel.TimeFloatUnit((SimulatorInterface<FloatDuration>)this.getSimulator()));
        }
    }

    public static class TimeDoubleUnit
    extends DEVSControlPanel<Duration, DevsSimulatorInterface<Duration>> {
        private static final long serialVersionUID = 20201227L;

        public TimeDoubleUnit(DSOLModel<Duration, ? extends DevsSimulatorInterface<Duration>> model, DevsSimulatorInterface<Duration> simulator) throws RemoteException {
            super(model, simulator);
            this.setClockPanel(new ClockPanel.TimeDoubleUnit((SimulatorInterface<Duration>)this.getSimulator()));
            this.setSpeedPanel(new SpeedPanel.TimeDoubleUnit((SimulatorInterface<Duration>)this.getSimulator()));
            this.setRunUntilPanel(new RunUntilPanel.TimeDoubleUnit((SimulatorInterface<Duration>)this.getSimulator()));
        }
    }

    public static class TimeLong
    extends DEVSControlPanel<Long, DevsSimulatorInterface<Long>> {
        private static final long serialVersionUID = 20201227L;

        public TimeLong(DSOLModel<Long, ? extends DevsSimulatorInterface<Long>> model, DevsSimulatorInterface<Long> simulator) throws RemoteException {
            super(model, simulator);
            this.setClockPanel(new ClockPanel.TimeLong((SimulatorInterface<Long>)this.getSimulator()));
            this.setSpeedPanel(new SpeedPanel.TimeLong((SimulatorInterface<Long>)this.getSimulator()));
            this.setRunUntilPanel(new RunUntilPanel.TimeLong((SimulatorInterface<Long>)this.getSimulator()));
        }
    }

    public static class TimeFloat
    extends DEVSControlPanel<Float, DevsSimulatorInterface<Float>> {
        private static final long serialVersionUID = 20201227L;

        public TimeFloat(DSOLModel<Float, ? extends DevsSimulatorInterface<Float>> model, DevsSimulatorInterface<Float> simulator) throws RemoteException {
            super(model, simulator);
            this.setClockPanel(new ClockPanel.TimeFloat((SimulatorInterface<Float>)this.getSimulator()));
            this.setSpeedPanel(new SpeedPanel.TimeFloat((SimulatorInterface<Float>)this.getSimulator()));
            this.setRunUntilPanel(new RunUntilPanel.TimeFloat((SimulatorInterface<Float>)this.getSimulator()));
        }
    }

    public static class TimeDouble
    extends DEVSControlPanel<Double, DevsSimulatorInterface<Double>> {
        private static final long serialVersionUID = 20201227L;

        public TimeDouble(DSOLModel<Double, ? extends DevsSimulatorInterface<Double>> model, DevsSimulatorInterface<Double> simulator) throws RemoteException {
            super(model, simulator);
            this.setClockPanel(new ClockPanel.TimeDouble((SimulatorInterface<Double>)this.getSimulator()));
            this.setSpeedPanel(new SpeedPanel.TimeDouble((SimulatorInterface<Double>)this.getSimulator()));
            this.setRunUntilPanel(new RunUntilPanel.TimeDouble((SimulatorInterface<Double>)this.getSimulator()));
        }
    }
}

