/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui.control;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import javax.swing.JButton;
import nl.tudelft.simulation.dsol.model.DSOLModel;
import nl.tudelft.simulation.dsol.simulators.DevsRealTimeAnimator;
import nl.tudelft.simulation.dsol.simulators.DevsSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.RunState;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.dsol.swing.gui.control.ClockPanel;
import nl.tudelft.simulation.dsol.swing.gui.control.DEVSControlPanel;
import nl.tudelft.simulation.dsol.swing.gui.control.RunSpeedSliderPanel;
import nl.tudelft.simulation.dsol.swing.gui.control.RunUntilPanel;
import nl.tudelft.simulation.dsol.swing.gui.control.SpeedPanel;
import org.djunits.value.vdouble.scalar.Duration;
import org.djunits.value.vfloat.scalar.FloatDuration;
import org.djutils.event.Event;
import org.djutils.event.EventListener;

public class RealTimeControlPanel<T extends Number, S extends DevsRealTimeAnimator<T>>
extends DEVSControlPanel<T, S>
implements PropertyChangeListener {
    private static final long serialVersionUID = 20201227L;
    private final RunSpeedSliderPanel runSpeedSliderPanel;
    private long savedAnimationDelay = 100L;

    public RealTimeControlPanel(DSOLModel<T, ? extends DevsSimulatorInterface<T>> model, S simulator) throws RemoteException {
        super(model, simulator);
        this.getControlButtonsPanel().add(this.makeButton("fastForwardButton", "/resources/FastForward.png", "FastForward", "Run the simulation as fast as possible", true));
        this.runSpeedSliderPanel = new RunSpeedSliderPanel(0.1, 1000.0, 1.0, 3, (DevsSimulatorInterface)this.getSimulator());
        this.add(this.runSpeedSliderPanel);
        ((DevsRealTimeAnimator)this.getSimulator()).addListener((EventListener)this, DevsRealTimeAnimator.CHANGE_SPEED_FACTOR_EVENT);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        try {
            if (actionCommand.equals("FastForward") && ((DevsRealTimeAnimator)this.getSimulator()).isStoppingOrStopped()) {
                this.savedAnimationDelay = ((DevsRealTimeAnimator)this.getSimulator()).getAnimationDelay();
                ((DevsRealTimeAnimator)this.getSimulator()).setAnimationDelay(0L);
                ((DevsRealTimeAnimator)this.getSimulator()).setUpdateMsec(1000);
                ((DevsRealTimeAnimator)this.getSimulator()).setAnimationDelay(500L);
                ((DevsRealTimeAnimator)this.getSimulator()).start();
            }
            if (actionCommand.equals("RunPause") || actionCommand.equals("Reset")) {
                ((DevsRealTimeAnimator)this.getSimulator()).setAnimationDelay(this.savedAnimationDelay);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        super.actionPerformed(actionEvent);
    }

    @Override
    protected void fixButtons() {
        boolean moreWorkToDo = ((DevsRealTimeAnimator)this.getSimulator()).getRunState() != RunState.ENDED;
        for (JButton button : this.getControlButtons()) {
            String actionCommand = button.getActionCommand();
            if (!actionCommand.equals("FastForward")) continue;
            button.setEnabled(moreWorkToDo && this.isControlButtonsEnabled() && ((DevsRealTimeAnimator)this.getSimulator()).isStoppingOrStopped());
        }
        super.fixButtons();
    }

    @Override
    protected void invalidateButtons() {
        for (JButton button : this.getControlButtons()) {
            String actionCommand = button.getActionCommand();
            if (!actionCommand.equals("FastForward")) continue;
            button.setEnabled(false);
        }
        super.invalidateButtons();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public void notify(Event event) throws RemoteException {
        if (event.getType().equals((Object)DevsRealTimeAnimator.CHANGE_SPEED_FACTOR_EVENT)) {
            this.runSpeedSliderPanel.setSpeedFactor((Double)event.getContent());
            this.fixButtons();
        }
        super.notify(event);
    }

    public static class TimeFloatUnit
    extends RealTimeControlPanel<FloatDuration, DevsRealTimeAnimator<FloatDuration>> {
        private static final long serialVersionUID = 20201227L;

        public TimeFloatUnit(DSOLModel<FloatDuration, ? extends DevsSimulatorInterface<FloatDuration>> model, DevsRealTimeAnimator<FloatDuration> simulator) throws RemoteException {
            super(model, simulator);
            this.setClockPanel(new ClockPanel.TimeFloatUnit((SimulatorInterface<FloatDuration>)this.getSimulator()));
            this.setSpeedPanel(new SpeedPanel.TimeFloatUnit((SimulatorInterface<FloatDuration>)this.getSimulator()));
            this.setRunUntilPanel(new RunUntilPanel.TimeFloatUnit((SimulatorInterface<FloatDuration>)this.getSimulator()));
        }
    }

    public static class TimeDoubleUnit
    extends RealTimeControlPanel<Duration, DevsRealTimeAnimator<Duration>> {
        private static final long serialVersionUID = 20201227L;

        public TimeDoubleUnit(DSOLModel<Duration, ? extends DevsSimulatorInterface<Duration>> model, DevsRealTimeAnimator<Duration> simulator) throws RemoteException {
            super(model, simulator);
            this.setClockPanel(new ClockPanel.TimeDoubleUnit((SimulatorInterface<Duration>)this.getSimulator()));
            this.setSpeedPanel(new SpeedPanel.TimeDoubleUnit((SimulatorInterface<Duration>)this.getSimulator()));
            this.setRunUntilPanel(new RunUntilPanel.TimeDoubleUnit((SimulatorInterface<Duration>)this.getSimulator()));
        }
    }

    public static class TimeLong
    extends RealTimeControlPanel<Long, DevsRealTimeAnimator<Long>> {
        private static final long serialVersionUID = 20201227L;

        public TimeLong(DSOLModel<Long, ? extends DevsSimulatorInterface<Long>> model, DevsRealTimeAnimator<Long> simulator) throws RemoteException {
            super(model, simulator);
            this.setClockPanel(new ClockPanel.TimeLong((SimulatorInterface<Long>)this.getSimulator()));
            this.setSpeedPanel(new SpeedPanel.TimeLong((SimulatorInterface<Long>)this.getSimulator()));
            this.setRunUntilPanel(new RunUntilPanel.TimeLong((SimulatorInterface<Long>)this.getSimulator()));
        }
    }

    public static class TimeFloat
    extends RealTimeControlPanel<Float, DevsRealTimeAnimator<Float>> {
        private static final long serialVersionUID = 20201227L;

        public TimeFloat(DSOLModel<Float, ? extends DevsSimulatorInterface<Float>> model, DevsRealTimeAnimator<Float> simulator) throws RemoteException {
            super(model, simulator);
            this.setClockPanel(new ClockPanel.TimeFloat((SimulatorInterface<Float>)this.getSimulator()));
            this.setSpeedPanel(new SpeedPanel.TimeFloat((SimulatorInterface<Float>)this.getSimulator()));
            this.setRunUntilPanel(new RunUntilPanel.TimeFloat((SimulatorInterface<Float>)this.getSimulator()));
        }
    }

    public static class TimeDouble
    extends RealTimeControlPanel<Double, DevsRealTimeAnimator<Double>> {
        private static final long serialVersionUID = 20201227L;

        public TimeDouble(DSOLModel<Double, ? extends DevsSimulatorInterface<Double>> model, DevsRealTimeAnimator<Double> simulator) throws RemoteException {
            super(model, simulator);
            this.setClockPanel(new ClockPanel.TimeDouble((SimulatorInterface<Double>)this.getSimulator()));
            this.setSpeedPanel(new SpeedPanel.TimeDouble((SimulatorInterface<Double>)this.getSimulator()));
            this.setRunUntilPanel(new RunUntilPanel.TimeDouble((SimulatorInterface<Double>)this.getSimulator()));
        }
    }
}

