/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui.control;

import java.awt.Dimension;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nl.tudelft.simulation.dsol.simulators.DevsRealTimeAnimator;
import nl.tudelft.simulation.dsol.simulators.DevsSimulatorInterface;

public class RunSpeedSliderPanel
extends JPanel {
    private static final long serialVersionUID = 20150408L;
    private final JSlider slider;
    private final int[] ratios;
    private Map<Integer, Double> tickValues = new LinkedHashMap<Integer, Double>();

    RunSpeedSliderPanel(double minimum, double maximum, double initialValue, int ticksPerDecade, final DevsSimulatorInterface<?> simulator) {
        if (minimum <= 0.0 || minimum > initialValue || initialValue > maximum) {
            throw new RuntimeException("Bad (combination of) minimum, maximum and initialValue; (restrictions: 0 < minimum <= initialValue <= maximum)");
        }
        switch (ticksPerDecade) {
            case 1: {
                this.ratios = new int[]{1};
                break;
            }
            case 2: {
                this.ratios = new int[]{1, 3};
                break;
            }
            case 3: {
                this.ratios = new int[]{1, 2, 5};
                break;
            }
            default: {
                throw new RuntimeException("Bad ticksPerDecade value (must be 1, 2 or 3)");
            }
        }
        int minimumTick = (int)Math.floor(Math.log10(minimum / initialValue) * (double)ticksPerDecade);
        int maximumTick = (int)Math.ceil(Math.log10(maximum / initialValue) * (double)ticksPerDecade);
        this.slider = new JSlider(0, minimumTick, maximumTick + 1, 0);
        this.slider.setPreferredSize(new Dimension(350, 45));
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        for (int step = 0; step <= maximumTick; ++step) {
            StringBuilder text = new StringBuilder();
            text.append(this.ratios[step % this.ratios.length]);
            for (int decade = 0; decade < step / this.ratios.length; ++decade) {
                text.append("0");
            }
            this.tickValues.put(step, Double.parseDouble(text.toString()));
            labels.put(step, new JLabel(text.toString().replace("000", "K")));
        }
        String decimalSeparator = "" + ((DecimalFormat)NumberFormat.getInstance()).getDecimalFormatSymbols().getDecimalSeparator();
        for (int step = -1; step >= minimumTick; --step) {
            StringBuilder text = new StringBuilder();
            text.append("0");
            text.append(decimalSeparator);
            for (int decade = (step + 1) / this.ratios.length; decade < 0; ++decade) {
                text.append("0");
            }
            int index = step % this.ratios.length;
            if (index < 0) {
                index += this.ratios.length;
            }
            text.append(this.ratios[index]);
            labels.put(step, new JLabel(text.toString()));
            this.tickValues.put(step, Double.parseDouble(text.toString()));
        }
        labels.put(maximumTick + 1, new JLabel("\u221e"));
        this.tickValues.put(maximumTick + 1, 1.0E9);
        this.slider.setLabelTable(labels);
        this.slider.setPaintLabels(true);
        this.slider.setPaintTicks(true);
        this.slider.setMajorTickSpacing(1);
        this.add(this.slider);
        if (simulator instanceof DevsRealTimeAnimator) {
            DevsRealTimeAnimator clock = (DevsRealTimeAnimator)simulator;
            clock.setSpeedFactor(this.tickValues.get(this.slider.getValue()).doubleValue());
        }
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                JSlider source = (JSlider)ce.getSource();
                if (!source.getValueIsAdjusting() && simulator instanceof DevsRealTimeAnimator) {
                    DevsRealTimeAnimator clock = (DevsRealTimeAnimator)simulator;
                    clock.setSpeedFactor(((RunSpeedSliderPanel)source.getParent()).getTickValues().get(source.getValue()).doubleValue());
                }
            }
        });
    }

    protected Map<Integer, Double> getTickValues() {
        return this.tickValues;
    }

    private double stepToFactor(int step) {
        int power;
        int index = step % this.ratios.length;
        if (index < 0) {
            index += this.ratios.length;
        }
        double result = this.ratios[index];
        for (power = (step + 1000 * this.ratios.length) / this.ratios.length - 1000; power > 0; --power) {
            result *= 10.0;
        }
        while (power < 0) {
            result /= 10.0;
            ++power;
        }
        return result;
    }

    public double getFactor() {
        return this.stepToFactor(this.slider.getValue());
    }

    @Override
    public String toString() {
        return "TimeWarpPanel [timeWarp=" + this.getFactor() + "]";
    }

    public void setSpeedFactor(double factor) {
        int bestStep = -1;
        double bestError = Double.MAX_VALUE;
        double logOfFactor = Math.log(factor);
        for (int step = this.slider.getMinimum(); step <= this.slider.getMaximum(); ++step) {
            double ratio = this.getTickValues().get(step);
            double logError = Math.abs(logOfFactor - Math.log(ratio));
            if (!(logError < bestError)) continue;
            bestStep = step;
            bestError = logError;
        }
        if (this.slider.getValue() != bestStep) {
            this.slider.setValue(bestStep);
        }
    }
}

