/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui.control;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.dsol.swing.gui.appearance.AppearanceControl;
import nl.tudelft.simulation.dsol.swing.gui.appearance.AppearanceControlButton;
import nl.tudelft.simulation.dsol.swing.gui.appearance.AppearanceControlLabel;
import nl.tudelft.simulation.dsol.swing.gui.util.Icons;
import nl.tudelft.simulation.dsol.swing.gui.util.RegexFormatter;
import org.djunits.value.vdouble.scalar.Duration;
import org.djunits.value.vdouble.scalar.base.AbstractDoubleScalar;
import org.djunits.value.vfloat.scalar.FloatDuration;
import org.djunits.value.vfloat.scalar.base.AbstractFloatScalar;

public abstract class RunUntilPanel<T extends Number>
extends JPanel
implements AppearanceControl,
ActionListener {
    private static final long serialVersionUID = 20141211L;
    private final SimulatorInterface<T> simulator;
    private final JFormattedTextField textField;
    private Font timeFont = new Font("SansSerif", 1, 18);
    private String initialValue;
    private JButton runUntilButton;
    private boolean applyState = false;
    private T runUntilTime = null;

    public RunUntilPanel(SimulatorInterface<T> simulator, String initialValue, String regex) {
        this.simulator = simulator;
        this.initialValue = initialValue;
        this.setLayout(new BoxLayout(this, 0));
        this.setMaximumSize(new Dimension(250, 35));
        this.textField = new JFormattedTextField(new RegexFormatter(regex));
        this.textField.setFont(this.getTimeFont());
        this.textField.setPreferredSize(new Dimension(120, 20));
        this.textField.setValue(this.initialValue);
        Icon runUntilIcon = Icons.loadIcon("/resources/Apply.png");
        this.runUntilButton = new AppearanceControlButton(runUntilIcon);
        this.runUntilButton.setName("runUntil");
        this.runUntilButton.setEnabled(true);
        this.runUntilButton.setActionCommand("RunUntil");
        this.runUntilButton.setToolTipText("Run until the given time; ignored if earlier than current simulation time");
        this.runUntilButton.addActionListener(this);
        this.add(new AppearanceControlLabel("Run until: "));
        this.add(this.textField);
        this.add(this.runUntilButton);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        try {
            if (actionCommand.equals("RunUntil")) {
                if (this.applyState) {
                    this.cancel();
                    return;
                }
                this.textField.commitEdit();
                String stopTimeValue = (String)this.textField.getValue();
                this.runUntilTime = this.parseSimulationTime(stopTimeValue);
                if (this.runUntilTime == null || ((Comparable)((Object)this.getSimulator().getSimulatorTime())).compareTo(this.runUntilTime) >= 0 || ((Comparable)((Object)this.getSimulator().getReplication().getEndTime())).compareTo(this.runUntilTime) < 0) {
                    this.cancel();
                    return;
                }
                this.apply();
            }
        }
        catch (Exception exception) {
            this.getSimulator().getLogger().always().warn((Throwable)exception);
            try {
                this.cancel();
            }
            catch (Exception e) {
                this.getSimulator().getLogger().always().warn((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply() throws RemoteException {
        JFormattedTextField jFormattedTextField = this.textField;
        synchronized (jFormattedTextField) {
            this.textField.setBackground(Color.GREEN);
            this.runUntilButton.setIcon(Icons.loadIcon("/resources/Cancel.png"));
            this.textField.validate();
            RunUntilPanel runUntilPanel = this;
            synchronized (runUntilPanel) {
                if (this.getSimulator().isStartingOrRunning()) {
                    this.getSimulator().stop();
                }
                if (((Comparable)((Object)this.getSimulator().getSimulatorTime())).compareTo(this.runUntilTime) < 0) {
                    this.getSimulator().runUpTo(this.runUntilTime);
                }
            }
            this.applyState = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel() throws RemoteException {
        JFormattedTextField jFormattedTextField = this.textField;
        synchronized (jFormattedTextField) {
            this.runUntilTime = null;
            this.textField.setValue(this.initialValue);
            this.textField.setBackground(Color.WHITE);
            this.runUntilButton.setIcon(Icons.loadIcon("/resources/Apply.png"));
            this.textField.validate();
            this.applyState = false;
        }
    }

    protected abstract String formatSimulationTime(T var1);

    protected abstract T parseSimulationTime(String var1);

    public SimulatorInterface<T> getSimulator() {
        return this.simulator;
    }

    public Font getTimeFont() {
        return this.timeFont;
    }

    @Override
    public boolean isForeground() {
        return true;
    }

    @Override
    public String toString() {
        return "RunUntilPanel [time=" + this.textField.getText() + "]";
    }

    public static class TimeFloatUnit
    extends RunUntilPanel<FloatDuration> {
        private static final long serialVersionUID = 20201227L;

        public TimeFloatUnit(SimulatorInterface<FloatDuration> simulator) {
            super(simulator, "0.0 s", "^[0-9]*[.]?[0-9]+([eE][-+]?[0-9]+)?\\s*(s|sec|Ys|Ysec|Zs|Zsec|Es|Esec|Ps|Psec|Ts|Tsec|Gs|Gsec|Ms|Msec|ks|ksec|hs|hsec|das|dasec|ds|dsec|cs|csec|ms|\\u03BCs|mus|\\u03BCsec|musec|ns|nsec|ps|psec|fs|fsec|as|asec|zs|zsec|ys|ysec|day|h|hr|hour|min|wk|week)");
        }

        @Override
        protected String formatSimulationTime(FloatDuration simulationTime) {
            return String.format("%s", simulationTime.toString());
        }

        @Override
        protected FloatDuration parseSimulationTime(String simulationTimeString) {
            try {
                FloatDuration t = FloatDuration.valueOf((String)simulationTimeString);
                return t.gt((AbstractFloatScalar)FloatDuration.ZERO) ? t : null;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public static class TimeDoubleUnit
    extends RunUntilPanel<Duration> {
        private static final long serialVersionUID = 20201227L;

        public TimeDoubleUnit(SimulatorInterface<Duration> simulator) {
            super(simulator, "0.0 s", "^[0-9]*[.]?[0-9]+([eE][-+]?[0-9]+)?\\s*(s|sec|Ys|Ysec|Zs|Zsec|Es|Esec|Ps|Psec|Ts|Tsec|Gs|Gsec|Ms|Msec|ks|ksec|hs|hsec|das|dasec|ds|dsec|cs|csec|ms|\\u03BCs|mus|\\u03BCsec|musec|ns|nsec|ps|psec|fs|fsec|as|asec|zs|zsec|ys|ysec|day|h|hr|hour|min|wk|week)");
        }

        @Override
        protected String formatSimulationTime(Duration simulationTime) {
            return String.format("%s", simulationTime.toString());
        }

        @Override
        protected Duration parseSimulationTime(String simulationTimeString) {
            try {
                Duration t = Duration.valueOf((String)simulationTimeString);
                return t.gt((AbstractDoubleScalar)Duration.ZERO) ? t : null;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public static class TimeLong
    extends RunUntilPanel<Long> {
        private static final long serialVersionUID = 20201227L;

        public TimeLong(SimulatorInterface<Long> simulator) {
            super(simulator, "0", "[0-9]+");
        }

        @Override
        protected String formatSimulationTime(Long simulationTime) {
            return String.format("%s", simulationTime);
        }

        @Override
        protected Long parseSimulationTime(String simulationTimeString) {
            try {
                long t = Long.parseLong(simulationTimeString);
                return t > 0L ? Long.valueOf(t) : null;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public static class TimeFloat
    extends RunUntilPanel<Float> {
        private static final long serialVersionUID = 20201227L;

        public TimeFloat(SimulatorInterface<Float> simulator) {
            super(simulator, "0.0", "^([0-9]+([.][0-9]*)?|[.][0-9]+)$");
        }

        @Override
        protected String formatSimulationTime(Float simulationTime) {
            return String.format("%s", simulationTime);
        }

        @Override
        protected Float parseSimulationTime(String simulationTimeString) {
            try {
                float t = Float.parseFloat(simulationTimeString);
                return t > 0.0f ? Float.valueOf(t) : null;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public static class TimeDouble
    extends RunUntilPanel<Double> {
        private static final long serialVersionUID = 20201227L;

        public TimeDouble(SimulatorInterface<Double> simulator) {
            super(simulator, "0.0", "^([0-9]+([.][0-9]*)?|[.][0-9]+)$");
        }

        @Override
        protected String formatSimulationTime(Double simulationTime) {
            return String.format("%s", simulationTime);
        }

        @Override
        protected Double parseSimulationTime(String simulationTimeString) {
            try {
                double t = Double.parseDouble(simulationTimeString);
                return t > 0.0 ? Double.valueOf(t) : null;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

