/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui.control;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.Serializable;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JLabel;
import javax.swing.JPanel;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.dsol.swing.gui.appearance.AppearanceControl;
import nl.tudelft.simulation.dsol.swing.gui.appearance.AppearanceControlLabel;
import org.djunits.value.vdouble.scalar.Duration;
import org.djunits.value.vfloat.scalar.FloatDuration;

public abstract class SpeedPanel<T extends Number>
extends JPanel
implements AppearanceControl {
    private static final long serialVersionUID = 20141211L;
    public JLabel speedLabel;
    final SimulatorInterface<T> simulator;
    private Font timeFont = new Font("SansSerif", 1, 18);
    private Timer timer;
    private long updateIntervalMs = 1000L;
    private T prevSimTime;

    public SpeedPanel(SimulatorInterface<T> simulator) {
        this.simulator = simulator;
        this.setLayout(new FlowLayout(0));
        this.setFont(this.getTimeFont());
        this.speedLabel = new AppearanceControlLabel();
        this.speedLabel.setFont(this.getTimeFont());
        this.speedLabel.setMaximumSize(new Dimension(100, 35));
        this.add(this.speedLabel);
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)new TimeUpdateTask(), 0L, this.updateIntervalMs);
    }

    public void cancelTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
    }

    public JLabel getSpeedLabel() {
        return this.speedLabel;
    }

    public SimulatorInterface<T> getSimulator() {
        return this.simulator;
    }

    public Font getTimeFont() {
        return this.timeFont;
    }

    public long getUpdateIntervalMs() {
        return this.updateIntervalMs;
    }

    public T getPrevSimTime() {
        return this.prevSimTime;
    }

    protected void setPrevSimTime(T prevSimTime) {
        this.prevSimTime = prevSimTime;
    }

    protected abstract String formatSpeed(T var1);

    @Override
    public boolean isForeground() {
        return true;
    }

    @Override
    public String toString() {
        return "SpeedPanel";
    }

    public static class TimeFloatUnit
    extends SpeedPanel<FloatDuration> {
        private static final long serialVersionUID = 20201227L;

        public TimeFloatUnit(SimulatorInterface<FloatDuration> simulator) {
            super(simulator);
            this.setPrevSimTime(FloatDuration.ZERO);
        }

        @Override
        protected String formatSpeed(FloatDuration simulationTime) {
            if (simulationTime == null) {
                return "0.0";
            }
            double speed = (double)(simulationTime.si - ((FloatDuration)this.getPrevSimTime()).si) / (0.001 * (double)this.getUpdateIntervalMs());
            this.setPrevSimTime(simulationTime);
            return String.format("%6.2f x ", speed);
        }
    }

    public static class TimeDoubleUnit
    extends SpeedPanel<Duration> {
        private static final long serialVersionUID = 20201227L;

        public TimeDoubleUnit(SimulatorInterface<Duration> simulator) {
            super(simulator);
            this.setPrevSimTime(Duration.ZERO);
        }

        @Override
        protected String formatSpeed(Duration simulationTime) {
            if (simulationTime == null) {
                return "0.0";
            }
            double speed = (simulationTime.si - ((Duration)this.getPrevSimTime()).si) / (0.001 * (double)this.getUpdateIntervalMs());
            this.setPrevSimTime(simulationTime);
            return String.format("%6.2f x ", speed);
        }
    }

    public static class TimeLong
    extends SpeedPanel<Long> {
        private static final long serialVersionUID = 20201227L;

        public TimeLong(SimulatorInterface<Long> simulator) {
            super(simulator);
            this.setPrevSimTime(0L);
        }

        @Override
        protected String formatSpeed(Long simulationTime) {
            if (simulationTime == null) {
                return "0.0";
            }
            double speed = (double)(simulationTime - (Long)this.getPrevSimTime()) / (0.001 * (double)this.getUpdateIntervalMs());
            this.setPrevSimTime(simulationTime);
            return String.format("%6.2f x ", speed);
        }
    }

    public static class TimeFloat
    extends SpeedPanel<Float> {
        private static final long serialVersionUID = 20201227L;

        public TimeFloat(SimulatorInterface<Float> simulator) {
            super(simulator);
            this.setPrevSimTime(Float.valueOf(0.0f));
        }

        @Override
        protected String formatSpeed(Float simulationTime) {
            if (simulationTime == null) {
                return "0.0";
            }
            double speed = (double)(simulationTime.floatValue() - ((Float)this.getPrevSimTime()).floatValue()) / (0.001 * (double)this.getUpdateIntervalMs());
            this.setPrevSimTime(simulationTime);
            return String.format("%6.2f x ", speed);
        }
    }

    public static class TimeDouble
    extends SpeedPanel<Double> {
        private static final long serialVersionUID = 20201227L;

        public TimeDouble(SimulatorInterface<Double> simulator) {
            super(simulator);
            this.setPrevSimTime(0.0);
        }

        @Override
        protected String formatSpeed(Double simulationTime) {
            if (simulationTime == null) {
                return "0.0";
            }
            double speed = (simulationTime - (Double)this.getPrevSimTime()) / (0.001 * (double)this.getUpdateIntervalMs());
            this.setPrevSimTime(simulationTime);
            return String.format("%6.2f x ", speed);
        }
    }

    protected class TimeUpdateTask
    extends TimerTask
    implements Serializable {
        private static final long serialVersionUID = 20140000L;

        protected TimeUpdateTask() {
        }

        @Override
        public void run() {
            Number simulationTime = SpeedPanel.this.getSimulator().getSimulatorTime();
            SpeedPanel.this.getSpeedLabel().setText(SpeedPanel.this.formatSpeed(simulationTime));
            SpeedPanel.this.getSpeedLabel().repaint();
        }

        public String toString() {
            return "TimeUpdateTask of SpeedPanel";
        }
    }
}

