/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui.inputparameters;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameter;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterDistContinuousSelection;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterDouble;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterException;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterFloat;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterInteger;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterLong;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterMapDistContinuous;
import nl.tudelft.simulation.dsol.swing.gui.inputparameters.AbstractInputField;
import nl.tudelft.simulation.dsol.swing.gui.inputparameters.InputFieldDouble;
import nl.tudelft.simulation.dsol.swing.gui.inputparameters.InputFieldFloat;
import nl.tudelft.simulation.dsol.swing.gui.inputparameters.InputFieldInteger;
import nl.tudelft.simulation.dsol.swing.gui.inputparameters.InputFieldLong;

public class InputFieldDistContinuous
extends AbstractInputField
implements ItemListener {
    protected JComboBox<String> distComboBox;
    protected Map<String, JTextField[]> textFields = new LinkedHashMap<String, JTextField[]>();
    protected Map<String, InputParameterMapDistContinuous> selectionMap = new LinkedHashMap<String, InputParameterMapDistContinuous>();
    protected JPanel distPanel;

    public InputFieldDistContinuous(JPanel panel, InputParameterDistContinuousSelection parameter) {
        super((InputParameter<?, ?>)parameter);
        JLabel label = new JLabel(parameter.getShortName());
        panel.add(label);
        JPanel container = new JPanel();
        container.setLayout(new BoxLayout(container, 1));
        JPanel comboBoxPane = new JPanel();
        String[] selections = new String[parameter.getOptions().size()];
        int defaultIndex = 0;
        int i = 0;
        for (Object option : parameter.getOptions().keySet()) {
            selections[i] = ((String)option).toString();
            InputParameterMapDistContinuous value = (InputParameterMapDistContinuous)parameter.getOptions().get(option);
            this.selectionMap.put(selections[i], value);
            if (value.equals(parameter.getDefaultValue())) {
                defaultIndex = i;
            }
            ++i;
        }
        this.distComboBox = new JComboBox<String>(selections);
        this.distComboBox.setSelectedIndex(defaultIndex);
        this.distComboBox.addItemListener(this);
        comboBoxPane.add(this.distComboBox);
        CardLayout cardLayout = new CardLayout();
        this.distPanel = new JPanel(cardLayout);
        for (String option : parameter.getOptions().keySet()) {
            JPanel distParamPanel = new JPanel();
            BoxLayout boxLayout = new BoxLayout(distParamPanel, 1);
            distParamPanel.setLayout(boxLayout);
            InputParameterMapDistContinuous value = (InputParameterMapDistContinuous)parameter.getOptions().get(option);
            JTextField[] paramFields = new JTextField[value.getSortedSet().size()];
            int index = 0;
            for (InputParameter param : value.getSortedSet()) {
                JPanel itemPanel = new JPanel();
                itemPanel.setLayout(new GridLayout(1, 2, 5, 0));
                itemPanel.add(new JLabel(param.getShortName()));
                paramFields[index] = new JTextField(param.getDefaultValue().toString(), 20);
                itemPanel.add(paramFields[index]);
                distParamPanel.add(itemPanel);
                ++index;
            }
            this.textFields.put(option.toString(), paramFields);
            distParamPanel.add(Box.createVerticalGlue());
            this.distPanel.add((Component)distParamPanel, option.toString());
        }
        container.add(this.distComboBox);
        container.add(this.distPanel);
        panel.add(container);
        cardLayout.show(this.distPanel, selections[defaultIndex]);
        JLabel explanation = new JLabel(parameter.getDescription());
        panel.add(explanation);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        CardLayout cardLayout = (CardLayout)this.distPanel.getLayout();
        cardLayout.show(this.distPanel, (String)event.getItem());
    }

    public InputParameterDistContinuousSelection getParameter() {
        return (InputParameterDistContinuousSelection)super.getParameter();
    }

    public void setDistParameterValues() throws InputParameterException {
        String selectedOption = this.distComboBox.getSelectedItem().toString();
        this.getParameter().setMapValue((Object)this.selectionMap.get(selectedOption));
        InputParameterMapDistContinuous ipMap = this.selectionMap.get(selectedOption);
        JTextField[] paramFields = this.textFields.get(selectedOption);
        int index = 0;
        for (InputParameter param : ipMap.getSortedSet()) {
            String sValue = paramFields[index].getText();
            if (param instanceof InputParameterDouble) {
                InputParameterDouble dParam = (InputParameterDouble)param;
                dParam.setDoubleValue(InputFieldDouble.getDoubleValue(sValue, param.getShortName()));
            } else if (param instanceof InputParameterFloat) {
                InputParameterFloat fParam = (InputParameterFloat)param;
                fParam.setFloatValue(InputFieldFloat.getFloatValue(sValue, param.getShortName()));
            } else if (param instanceof InputParameterInteger) {
                InputParameterInteger iParam = (InputParameterInteger)param;
                iParam.setIntValue(InputFieldInteger.getIntValue(sValue, param.getShortName()));
            } else if (param instanceof InputParameterLong) {
                InputParameterLong lParam = (InputParameterLong)param;
                lParam.setLongValue(InputFieldLong.getLongValue(sValue, param.getShortName()));
            }
            ++index;
        }
    }
}

