/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui.inputparameters;

import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameter;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterDoubleScalar;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterException;
import nl.tudelft.simulation.dsol.swing.gui.inputparameters.AbstractInputField;
import org.djunits.unit.Unit;
import org.djunits.value.vdouble.scalar.base.AbstractDoubleScalar;

public class InputFieldDoubleScalar<U extends Unit<U>, T extends AbstractDoubleScalar<U, T>>
extends AbstractInputField {
    protected JTextField doubleField;
    protected JComboBox<String> unitField;

    public InputFieldDoubleScalar(JPanel panel, InputParameterDoubleScalar<U, T> parameter) {
        super((InputParameter<?, ?>)parameter);
        JLabel label = new JLabel(parameter.getShortName());
        this.doubleField = new JTextField(20);
        this.doubleField.setText("" + ((AbstractDoubleScalar)parameter.getDefaultTypedValue()).getInUnit(((AbstractDoubleScalar)parameter.getDefaultTypedValue()).getDisplayUnit()));
        JLabel explanation = new JLabel(parameter.getDescription());
        String[] selections = new String[parameter.getUnitParameter().getOptions().size()];
        int defaultIndex = 0;
        int i = 0;
        for (String option : parameter.getUnitParameter().getOptions().keySet()) {
            selections[i] = option.toString();
            Unit value = (Unit)parameter.getUnitParameter().getOptions().get(option);
            if (value.equals(parameter.getUnitParameter().getDefaultValue())) {
                defaultIndex = i;
            }
            ++i;
        }
        this.unitField = new JComboBox<String>(selections);
        this.unitField.setSelectedIndex(defaultIndex);
        panel.add(label);
        JPanel scalarPanel = new JPanel();
        scalarPanel.setLayout(new GridLayout(1, 2, 5, 0));
        scalarPanel.add(this.doubleField);
        scalarPanel.add(this.unitField);
        panel.add(scalarPanel);
        panel.add(explanation);
    }

    public InputParameterDoubleScalar<U, T> getParameter() {
        return (InputParameterDoubleScalar)super.getParameter();
    }

    public T getDoubleScalarValue() throws InputParameterException {
        double doubleValue = InputFieldDoubleScalar.getDoubleValue(this.doubleField.getText(), this.parameter.getShortName());
        this.getParameter().getDoubleParameter().setDoubleValue(doubleValue);
        Unit unit = (Unit)this.getParameter().getUnitParameter().getOptions().get(this.unitField.getSelectedItem().toString());
        this.getParameter().getUnitParameter().setMapValue((Object)unit);
        this.getParameter().setCalculatedValue();
        return (T)((AbstractDoubleScalar)this.getParameter().getCalculatedValue());
    }

    public double getDoubleValue() throws InputParameterException {
        return InputFieldDoubleScalar.getDoubleValue(this.doubleField.getText(), this.parameter.getShortName());
    }

    public U getUnit() throws InputParameterException {
        return (U)((Unit)this.getParameter().getUnitParameter().getOptions().get(this.unitField.getSelectedItem().toString()));
    }

    public static double getDoubleValue(String s, String shortName) throws InputParameterException {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException exception) {
            throw new InputParameterException("Field " + shortName + " does not contain a valid double value -- value = '" + s + "'");
        }
    }
}

