/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui.inputparameters;

import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameter;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterException;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterFloatScalar;
import nl.tudelft.simulation.dsol.swing.gui.inputparameters.AbstractInputField;
import org.djunits.unit.Unit;
import org.djunits.value.vfloat.scalar.base.AbstractFloatScalar;

public class InputFieldFloatScalar<U extends Unit<U>, T extends AbstractFloatScalar<U, T>>
extends AbstractInputField {
    protected JTextField floatField;
    protected JComboBox<String> unitField;

    public InputFieldFloatScalar(JPanel panel, InputParameterFloatScalar<U, T> parameter) {
        super((InputParameter<?, ?>)parameter);
        JLabel label = new JLabel(parameter.getShortName());
        this.floatField = new JTextField(20);
        this.floatField.setText("" + ((AbstractFloatScalar)parameter.getDefaultTypedValue()).getInUnit(((AbstractFloatScalar)parameter.getDefaultTypedValue()).getDisplayUnit()));
        JLabel explanation = new JLabel(parameter.getDescription());
        String[] selections = new String[parameter.getUnitParameter().getOptions().size()];
        int defaultIndex = 0;
        int i = 0;
        for (String option : parameter.getUnitParameter().getOptions().keySet()) {
            selections[i] = option.toString();
            Unit value = (Unit)parameter.getUnitParameter().getOptions().get(option);
            if (value.equals(parameter.getUnitParameter().getDefaultValue())) {
                defaultIndex = i;
            }
            ++i;
        }
        this.unitField = new JComboBox<String>(selections);
        this.unitField.setSelectedIndex(defaultIndex);
        panel.add(label);
        JPanel scalarPanel = new JPanel();
        scalarPanel.setLayout(new GridLayout(1, 2, 5, 0));
        scalarPanel.add(this.floatField);
        scalarPanel.add(this.unitField);
        panel.add(scalarPanel);
        panel.add(explanation);
    }

    public InputParameterFloatScalar<U, T> getParameter() {
        return (InputParameterFloatScalar)super.getParameter();
    }

    public T getFloatScalarValue() throws InputParameterException {
        float floatValue = InputFieldFloatScalar.getFloatValue(this.floatField.getText(), this.parameter.getShortName());
        this.getParameter().getFloatParameter().setFloatValue(floatValue);
        Unit unit = (Unit)this.getParameter().getUnitParameter().getOptions().get(this.unitField.getSelectedItem().toString());
        this.getParameter().getUnitParameter().setMapValue((Object)unit);
        this.getParameter().setCalculatedValue();
        return (T)((AbstractFloatScalar)this.getParameter().getCalculatedValue());
    }

    public float getFloatValue() throws InputParameterException {
        return InputFieldFloatScalar.getFloatValue(this.floatField.getText(), this.parameter.getShortName());
    }

    public U getUnit() throws InputParameterException {
        return (U)((Unit)this.getParameter().getUnitParameter().getOptions().get(this.unitField.getSelectedItem().toString()));
    }

    public static float getFloatValue(String s, String shortName) throws InputParameterException {
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException exception) {
            throw new InputParameterException("Field " + shortName + " does not contain a valid float value -- value = '" + s + "'");
        }
    }
}

