/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui.inputparameters;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameter;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterSelectionMap;
import nl.tudelft.simulation.dsol.swing.gui.inputparameters.AbstractInputField;

public class InputFieldSelectionMap<K, T>
extends AbstractInputField {
    protected JComboBox<String> selectField;
    protected Map<String, T> selectionMap = new LinkedHashMap<String, T>();

    public InputFieldSelectionMap(JPanel panel, InputParameterSelectionMap<K, T> parameter) {
        super((InputParameter<?, ?>)parameter);
        JLabel label = new JLabel(parameter.getShortName());
        String[] selections = new String[parameter.getOptions().size()];
        int defaultIndex = 0;
        int i = 0;
        for (Object option : parameter.getOptions().keySet()) {
            selections[i] = option.toString();
            Object value = parameter.getOptions().get(option);
            this.selectionMap.put(selections[i], value);
            if (value.equals(parameter.getDefaultValue())) {
                defaultIndex = i;
            }
            ++i;
        }
        this.selectField = new JComboBox<String>(selections);
        this.selectField.setSelectedIndex(defaultIndex);
        JLabel explanation = new JLabel(parameter.getDescription());
        panel.add(label);
        panel.add(this.selectField);
        panel.add(explanation);
    }

    public InputParameterSelectionMap<K, T> getParameter() {
        return (InputParameterSelectionMap)super.getParameter();
    }

    public T getValue() {
        return this.selectionMap.get(this.selectField.getSelectedItem().toString());
    }
}

