/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui.inputparameters;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameter;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterBoolean;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterDistContinuousSelection;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterDistDiscreteSelection;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterDouble;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterDoubleScalar;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterFloat;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterFloatScalar;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterInteger;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterLong;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterMap;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterMapDistContinuous;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterMapDistDiscrete;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterSelectionList;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterSelectionMap;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterString;
import nl.tudelft.simulation.dsol.swing.gui.inputparameters.AbstractInputField;
import nl.tudelft.simulation.dsol.swing.gui.inputparameters.InputField;
import nl.tudelft.simulation.dsol.swing.gui.inputparameters.InputFieldBoolean;
import nl.tudelft.simulation.dsol.swing.gui.inputparameters.InputFieldDistContinuous;
import nl.tudelft.simulation.dsol.swing.gui.inputparameters.InputFieldDistDiscrete;
import nl.tudelft.simulation.dsol.swing.gui.inputparameters.InputFieldDouble;
import nl.tudelft.simulation.dsol.swing.gui.inputparameters.InputFieldDoubleScalar;
import nl.tudelft.simulation.dsol.swing.gui.inputparameters.InputFieldFloat;
import nl.tudelft.simulation.dsol.swing.gui.inputparameters.InputFieldFloatScalar;
import nl.tudelft.simulation.dsol.swing.gui.inputparameters.InputFieldInteger;
import nl.tudelft.simulation.dsol.swing.gui.inputparameters.InputFieldLong;
import nl.tudelft.simulation.dsol.swing.gui.inputparameters.InputFieldSelectionList;
import nl.tudelft.simulation.dsol.swing.gui.inputparameters.InputFieldSelectionMap;
import nl.tudelft.simulation.dsol.swing.gui.inputparameters.InputFieldString;

public class TabbedParameterDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public InputParameterMap inputParameterMap;
    protected List<InputField> fields = new ArrayList<InputField>();
    protected boolean stopped = false;

    public TabbedParameterDialog(InputParameterMap inputParameterMap) {
        super(null, inputParameterMap.getShortName(), Dialog.ModalityType.DOCUMENT_MODAL);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TabbedParameterDialog.this.stopped = true;
                super.windowClosing(windowEvent);
            }
        });
        this.setPreferredSize(new Dimension(1024, 600));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.inputParameterMap = inputParameterMap;
        JTabbedPane tabbedPane = new JTabbedPane();
        panel.add(tabbedPane);
        for (InputParameter tab : this.inputParameterMap.getSortedSet()) {
            if (this.stopped) continue;
            if (!(tab instanceof InputParameterMap)) {
                Object[] options = new Object[]{"CONTINUE", "STOP"};
                int choice = JOptionPane.showOptionDialog(null, "Input parameter\n" + tab.getShortName() + "\ncannot be displayed in a tab", "Warning", -1, 2, null, options, options[0]);
                if (choice != 1) continue;
                this.dispose();
                this.stopped = true;
                continue;
            }
            InputParameterMap tabbedMap = (InputParameterMap)tab;
            JPanel tabbedPanel = new JPanel();
            JPanel tabbedWrapper = new JPanel(new BorderLayout());
            tabbedWrapper.add((Component)tabbedPanel, "North");
            tabbedWrapper.add(Box.createGlue(), "Center");
            tabbedPane.addTab(tab.getShortName(), tabbedWrapper);
            BoxLayout tabLayout = new BoxLayout(tabbedPanel, 1);
            tabbedPanel.setLayout(tabLayout);
            for (InputParameter parameter : tabbedMap.getSortedSet()) {
                JPanel row = new JPanel();
                GridLayout rowLayout = new GridLayout(1, 3, 5, 0);
                row.setLayout(rowLayout);
                tabbedPanel.add(row);
                this.addParameterField(row, parameter);
                tabbedPanel.add(Box.createVerticalStrut(2));
            }
        }
        if (!this.stopped) {
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout());
            JPanel centerPanel = new JPanel();
            centerPanel.setLayout(new FlowLayout(1));
            centerPanel.add(buttonPanel);
            panel.add(centerPanel);
            JButton startSimulationButton = new JButton("Start simulation model");
            startSimulationButton.addActionListener(this);
            buttonPanel.add(startSimulationButton);
            JButton cancelButton = new JButton("Cancel");
            buttonPanel.add(cancelButton);
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TabbedParameterDialog.this.setVisible(false);
                    TabbedParameterDialog.this.dispose();
                    TabbedParameterDialog.this.stopped = true;
                }
            });
        }
        if (!this.stopped) {
            this.add(panel);
            this.pack();
            this.setVisible(true);
        }
    }

    public void addParameterField(JPanel panel, InputParameter<?, ?> parameter) {
        if (parameter instanceof InputParameterDouble) {
            this.fields.add(new InputFieldDouble(panel, (InputParameterDouble)parameter));
        } else if (parameter instanceof InputParameterFloat) {
            this.fields.add(new InputFieldFloat(panel, (InputParameterFloat)parameter));
        } else if (parameter instanceof InputParameterBoolean) {
            this.fields.add(new InputFieldBoolean(panel, (InputParameterBoolean)parameter));
        } else if (parameter instanceof InputParameterLong) {
            this.fields.add(new InputFieldLong(panel, (InputParameterLong)parameter));
        } else if (parameter instanceof InputParameterInteger) {
            this.fields.add(new InputFieldInteger(panel, (InputParameterInteger)parameter));
        } else if (parameter instanceof InputParameterString) {
            this.fields.add(new InputFieldString(panel, parameter));
        } else if (parameter instanceof InputParameterDoubleScalar) {
            this.fields.add(new InputFieldDoubleScalar(panel, (InputParameterDoubleScalar)parameter));
        } else if (parameter instanceof InputParameterFloatScalar) {
            this.fields.add(new InputFieldFloatScalar(panel, (InputParameterFloatScalar)parameter));
        } else if (parameter instanceof InputParameterSelectionList) {
            this.fields.add(new InputFieldSelectionList(panel, (InputParameterSelectionList)parameter));
        } else if (parameter instanceof InputParameterDistDiscreteSelection) {
            this.fields.add(new InputFieldDistDiscrete(panel, (InputParameterDistDiscreteSelection)parameter));
        } else if (parameter instanceof InputParameterDistContinuousSelection) {
            this.fields.add(new InputFieldDistContinuous(panel, (InputParameterDistContinuousSelection)parameter));
        } else if (parameter instanceof InputParameterSelectionMap) {
            this.fields.add(new InputFieldSelectionMap(panel, (InputParameterSelectionMap)parameter));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean ok = true;
        try {
            for (InputField field : this.fields) {
                AbstractInputField f;
                if (field instanceof InputFieldDouble) {
                    f = (InputFieldDouble)field;
                    ((InputFieldDouble)f).getParameter().setDoubleValue(((InputFieldDouble)f).getDoubleValue());
                    continue;
                }
                if (field instanceof InputFieldFloat) {
                    f = (InputFieldFloat)field;
                    ((InputFieldFloat)f).getParameter().setFloatValue(((InputFieldFloat)f).getFloatValue());
                    continue;
                }
                if (field instanceof InputFieldBoolean) {
                    f = (InputFieldBoolean)field;
                    ((InputFieldBoolean)f).getParameter().setBooleanValue(((InputFieldBoolean)f).getValue());
                    continue;
                }
                if (field instanceof InputFieldInteger) {
                    f = (InputFieldInteger)field;
                    ((InputFieldInteger)f).getParameter().setIntValue(((InputFieldInteger)f).getIntValue());
                    continue;
                }
                if (field instanceof InputFieldLong) {
                    f = (InputFieldLong)field;
                    ((InputFieldLong)f).getParameter().setLongValue(((InputFieldLong)f).getLongValue());
                    continue;
                }
                if (field instanceof InputFieldString) {
                    f = (InputFieldString)field;
                    ((InputParameterString)f.getParameter()).setStringValue(((InputFieldString)f).getStringValue());
                    continue;
                }
                if (field instanceof InputFieldDoubleScalar) {
                    f = (InputFieldDoubleScalar)field;
                    ((InputFieldDoubleScalar)f).getParameter().getDoubleParameter().setDoubleValue(((InputFieldDoubleScalar)f).getDoubleValue());
                    ((InputFieldDoubleScalar)f).getParameter().getUnitParameter().setObjectValue(((InputFieldDoubleScalar)f).getUnit());
                    ((InputFieldDoubleScalar)f).getParameter().setCalculatedValue();
                    continue;
                }
                if (field instanceof InputFieldFloatScalar) {
                    f = (InputFieldFloatScalar)field;
                    ((InputFieldFloatScalar)f).getParameter().getFloatParameter().setFloatValue(((InputFieldFloatScalar)f).getFloatValue());
                    ((InputFieldFloatScalar)f).getParameter().getUnitParameter().setObjectValue(((InputFieldFloatScalar)f).getUnit());
                    ((InputFieldFloatScalar)f).getParameter().setCalculatedValue();
                    continue;
                }
                if (field instanceof InputFieldSelectionList) {
                    f = (InputFieldSelectionList)field;
                    ((InputFieldSelectionList)f).getParameter().setIndex(((InputFieldSelectionList)f).getIndex());
                    continue;
                }
                if (field instanceof InputFieldDistContinuous) {
                    f = (InputFieldDistContinuous)field;
                    ((InputFieldDistContinuous)f).setDistParameterValues();
                    ((InputParameterMapDistContinuous)((InputFieldDistContinuous)f).getParameter().getValue()).setDist();
                    continue;
                }
                if (field instanceof InputFieldDistDiscrete) {
                    f = (InputFieldDistDiscrete)field;
                    ((InputFieldDistDiscrete)f).setDistParameterValues();
                    ((InputParameterMapDistDiscrete)((InputFieldDistDiscrete)f).getParameter().getValue()).setDist();
                    continue;
                }
                if (!(field instanceof InputFieldSelectionMap)) continue;
                f = (InputFieldSelectionMap)field;
                ((InputFieldSelectionMap)f).getParameter().setObjectValue(((InputFieldSelectionMap)f).getValue());
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), "Data Entry Error", 0);
            ok = false;
        }
        if (ok) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public static boolean process(InputParameterMap inputParameterMap) {
        TabbedParameterDialog dialog = new TabbedParameterDialog(inputParameterMap);
        return !dialog.stopped;
    }
}

