/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui.inputparameters;

import java.util.ArrayList;
import nl.tudelft.simulation.dsol.model.inputparameters.AbstractInputParameter;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterBoolean;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterDistContinuousSelection;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterDistDiscreteSelection;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterDouble;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterDoubleScalar;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterException;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterMap;
import nl.tudelft.simulation.dsol.model.inputparameters.InputParameterSelectionList;
import nl.tudelft.simulation.dsol.swing.gui.inputparameters.TabbedParameterDialog;
import nl.tudelft.simulation.jstats.streams.MersenneTwister;
import nl.tudelft.simulation.jstats.streams.StreamInterface;
import org.djunits.unit.LengthUnit;
import org.djunits.value.vdouble.scalar.Length;
import org.djunits.value.vdouble.scalar.base.AbstractDoubleScalar;

public class Test {
    public static void main(String[] args) throws InputParameterException {
        InputParameterMap ipMap = new InputParameterMap("model", "Model data", "Input variables for the model", 1.0);
        InputParameterMap seMap = new InputParameterMap("economic", "Socio-economic", "Socio-economic data", 1.0);
        ipMap.add((AbstractInputParameter)seMap);
        for (String tgsbf : new String[]{"Textile", "Garment", "Steel", "Brick", "Food"}) {
            for (String pcei : new String[]{"Production", "Consumption", "Import", "Export"}) {
                InputParameterDouble paramDouble = new InputParameterDouble(tgsbf + pcei, tgsbf + " " + pcei, tgsbf + " " + pcei + " in tonnes per year", 100000.0, 0.0, 1.0E12, true, true, "%f", 1.0);
                seMap.add((AbstractInputParameter)paramDouble);
            }
        }
        InputParameterMap trMap = new InputParameterMap("transport", "Transport", "Transport data", 2.0);
        ipMap.add((AbstractInputParameter)trMap);
        for (String tgsbf : new String[]{"Textile", "Garment", "Steel", "Brick", "Food"}) {
            for (String rrw : new String[]{"Road", "Rail", "Water"}) {
                InputParameterDouble paramDouble = new InputParameterDouble(tgsbf + rrw, tgsbf + " " + rrw, tgsbf + " " + rrw + " in tonnes per year", 100000.0, 0.0, 1.0E12, true, true, "%f", 1.0);
                trMap.add((AbstractInputParameter)paramDouble);
            }
        }
        InputParameterMap xxMap = new InputParameterMap("other", "Other", "Other parameters", 3.0);
        ipMap.add((AbstractInputParameter)xxMap);
        InputParameterBoolean paramBool1 = new InputParameterBoolean("boolean1", "Boolean value 1", "Boolean value 1 using tickbox false", false, 1.0);
        xxMap.add((AbstractInputParameter)paramBool1);
        InputParameterBoolean paramBool2 = new InputParameterBoolean("boolean2", "Boolean value 2", "Boolean value 2 using tickbox true", true, 2.0);
        xxMap.add((AbstractInputParameter)paramBool2);
        ArrayList<String> countries = new ArrayList<String>();
        countries.add("USA");
        countries.add("Netherlands");
        countries.add("Germany");
        countries.add("France");
        countries.add("Belgium");
        InputParameterSelectionList paramSelect = new InputParameterSelectionList("country", "Country", "Country to select", countries, (Object)"Netherlands", 4.0);
        xxMap.add((AbstractInputParameter)paramSelect);
        MersenneTwister stream = new MersenneTwister(1L);
        InputParameterDistContinuousSelection ipdcs = new InputParameterDistContinuousSelection("distCont", "Continuous distribution", "Continuous distribution", (StreamInterface)stream, 5.0);
        xxMap.add((AbstractInputParameter)ipdcs);
        InputParameterDistDiscreteSelection ipdds = new InputParameterDistDiscreteSelection("distDiscrete", "Discrete distribution", "Discrete distribution", (StreamInterface)stream, 6.0);
        xxMap.add((AbstractInputParameter)ipdds);
        InputParameterDoubleScalar length = new InputParameterDoubleScalar("length", "Length", "Length of the trip", (AbstractDoubleScalar)new Length(20.0, LengthUnit.LIGHTYEAR), 0.0, Double.MAX_VALUE, true, false, "%d", 7.0);
        xxMap.add((AbstractInputParameter)length);
        new TabbedParameterDialog(ipMap);
        System.out.println(ipMap.printValues());
        System.out.println(((InputParameterMap)ipMap.get("other")).get("length").toString());
        InputParameterDoubleScalar ipds = (InputParameterDoubleScalar)((InputParameterMap)ipMap.get("other")).get("length");
        Length l1 = (Length)ipds.getCalculatedValue();
        Length l2 = (Length)ipMap.get("other.length").getCalculatedValue();
        System.out.println(l1);
        System.out.println(l2);
    }
}

