/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui.test;

import java.util.ArrayList;
import java.util.List;
import nl.tudelft.simulation.dsol.SimRuntimeException;
import nl.tudelft.simulation.dsol.model.AbstractDSOLModel;
import nl.tudelft.simulation.dsol.model.DSOLModel;
import nl.tudelft.simulation.dsol.simtime.dist.DistContinuousSimulationTime;
import nl.tudelft.simulation.dsol.simulators.DevsSimulatorInterface;
import nl.tudelft.simulation.dsol.statistics.SimPersistent;
import nl.tudelft.simulation.dsol.statistics.SimTally;
import nl.tudelft.simulation.jstats.distributions.DistContinuous;
import nl.tudelft.simulation.jstats.distributions.DistExponential;
import nl.tudelft.simulation.jstats.distributions.DistTriangular;
import nl.tudelft.simulation.jstats.streams.MersenneTwister;
import nl.tudelft.simulation.jstats.streams.StreamInterface;
import org.djutils.logger.CategoryLogger;

public class MM1Model
extends AbstractDSOLModel<Double, DevsSimulatorInterface<Double>> {
    private static final long serialVersionUID = 1L;
    private int capacity = 1;
    private int busy = 0;
    private StreamInterface stream = new MersenneTwister(12L);
    private DistContinuousSimulationTime<Double> interarrivalTime = new DistContinuousSimulationTime.TimeDouble((DistContinuous)new DistExponential(this.stream, 1.0));
    private DistContinuousSimulationTime<Double> processingTime = new DistContinuousSimulationTime.TimeDouble((DistContinuous)new DistTriangular(this.stream, 0.8, 0.9, 1.1));
    private List<QueueEntry<Entity>> queue = new ArrayList<QueueEntry<Entity>>();
    private int entityCounter = 0;
    SimPersistent<Double> persistentUtilization;
    SimPersistent<Double> persistentQueueLength;
    SimTally<Double> tallyTimeInQueue;
    SimTally<Double> tallyTimeInSystem;

    public MM1Model(DevsSimulatorInterface<Double> simulator) {
        super(simulator);
    }

    public void constructModel() throws SimRuntimeException {
        this.persistentUtilization = new SimPersistent("utilization", (DSOLModel)this);
        this.persistentQueueLength = new SimPersistent("queue length", (DSOLModel)this);
        this.tallyTimeInQueue = new SimTally("time in queue", (DSOLModel)this);
        this.tallyTimeInSystem = new SimTally("time in system", (DSOLModel)this);
        this.generate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generate() throws SimRuntimeException {
        Entity entity = new Entity(this.entityCounter++, (Double)((DevsSimulatorInterface)this.simulator).getSimulatorTime());
        System.out.println("Generated: " + entity);
        CategoryLogger.always().info("Generated: " + entity);
        List<QueueEntry<Entity>> list = this.queue;
        synchronized (list) {
            if (this.capacity - this.busy >= 1) {
                this.startProcess(entity);
            } else {
                this.persistentQueueLength.register(((DevsSimulatorInterface)this.getSimulator()).getSimulatorTime(), (double)this.queue.size());
                this.queue.add(new QueueEntry<Entity>(entity, (Double)((DevsSimulatorInterface)this.simulator).getSimulatorTime()));
                System.out.println("In Queue: " + entity);
            }
        }
        ((DevsSimulatorInterface)this.simulator).scheduleEventRel((Number)((Double)this.interarrivalTime.draw()), (Object)this, "generate", null);
    }

    protected void startProcess(Entity entity) throws SimRuntimeException {
        System.out.println("Start Process: " + entity);
        this.persistentUtilization.register(((DevsSimulatorInterface)this.getSimulator()).getSimulatorTime(), (double)this.busy);
        ++this.busy;
        this.persistentUtilization.register(((DevsSimulatorInterface)this.getSimulator()).getSimulatorTime(), (double)this.busy);
        ((DevsSimulatorInterface)this.simulator).scheduleEventRel((Number)((Double)this.processingTime.draw()), (Object)this, "endProcess", new Object[]{entity});
        this.tallyTimeInQueue.register((Double)((DevsSimulatorInterface)this.simulator).getSimulatorTime() - entity.getCreateTime());
    }

    protected void endProcess(Entity entity) throws SimRuntimeException {
        System.out.println("End Process: " + entity);
        this.persistentUtilization.register(((DevsSimulatorInterface)this.getSimulator()).getSimulatorTime(), (double)this.busy);
        --this.busy;
        this.persistentUtilization.register(((DevsSimulatorInterface)this.getSimulator()).getSimulatorTime(), (double)this.busy);
        if (!this.queue.isEmpty()) {
            this.persistentQueueLength.register(((DevsSimulatorInterface)this.getSimulator()).getSimulatorTime(), (double)this.queue.size());
            this.startProcess(this.queue.remove(0).getEntity());
        }
        this.tallyTimeInSystem.register((Double)((DevsSimulatorInterface)this.simulator).getSimulatorTime() - entity.getCreateTime());
    }

    protected class QueueEntry<E> {
        private final double queueInTime;
        private final E entity;

        public QueueEntry(E entity, double queueInTime) {
            this.entity = entity;
            this.queueInTime = queueInTime;
        }

        public double getQueueInTime() {
            return this.queueInTime;
        }

        public E getEntity() {
            return this.entity;
        }

        public String toString() {
            return "QueueEntry [queueInTime=" + this.queueInTime + ", entity=" + this.entity + "]";
        }
    }

    protected class Entity {
        private final double createTime;
        private final int id;

        public Entity(int id, double createTime) {
            this.id = id;
            this.createTime = createTime;
        }

        public double getCreateTime() {
            return this.createTime;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return "Entity [createTime=" + this.createTime + ", id=" + this.id + "]";
        }
    }
}

