/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.gui.test;

import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.simulators.DevsSimulatorInterface;
import nl.tudelft.simulation.dsol.statistics.SimPersistent;
import nl.tudelft.simulation.dsol.statistics.table.PersistentTableModel;
import nl.tudelft.simulation.dsol.statistics.table.StatisticsTableModel;
import nl.tudelft.simulation.dsol.statistics.table.TallyTableModel;
import nl.tudelft.simulation.dsol.swing.charts.boxAndWhisker.BoxAndWhiskerChart;
import nl.tudelft.simulation.dsol.swing.charts.xy.XYChart;
import nl.tudelft.simulation.dsol.swing.gui.ConsoleLogger;
import nl.tudelft.simulation.dsol.swing.gui.ConsoleOutput;
import nl.tudelft.simulation.dsol.swing.gui.DSOLPanel;
import nl.tudelft.simulation.dsol.swing.gui.TablePanel;
import nl.tudelft.simulation.dsol.swing.gui.control.DEVSControlPanel;
import nl.tudelft.simulation.dsol.swing.gui.test.MM1Model;
import nl.tudelft.simulation.dsol.swing.statistics.StatisticsTable;
import org.djutils.event.EventProducer;
import org.djutils.stats.summarizers.event.EventBasedTally;
import org.djutils.stats.summarizers.event.EventBasedTimestampWeightedTally;
import org.djutils.stats.summarizers.event.StatisticsEvents;
import org.pmw.tinylog.Level;

public class MM1Panel
extends DSOLPanel {
    private static final long serialVersionUID = 1L;

    public MM1Panel(DEVSControlPanel.TimeDouble controlPanel) throws RemoteException {
        super(controlPanel);
        this.addTabs();
        this.enableSimulationControlButtons();
    }

    protected void addTabs() {
        TablePanel charts = new TablePanel(4, 4);
        this.getTabbedPane().addTab("statistics", charts);
        this.getTabbedPane().setSelectedIndex(0);
        MM1Model model = (MM1Model)this.getModel();
        try {
            XYChart dNVal = new XYChart(this.getSimulator(), "time in queue (dN)").setLabelXAxis("time (s)").setLabelYAxis("dN");
            dNVal.add("dN value", (EventProducer)model.tallyTimeInQueue, StatisticsEvents.OBSERVATION_ADDED_EVENT);
            charts.setCell(dNVal.getSwingPanel(), 0, 0);
            XYChart dN = new XYChart(this.getSimulator(), "avg time in queue").setLabelXAxis("time (s)").setLabelYAxis("avg dN");
            dN.add("dN mean", (EventProducer)model.tallyTimeInQueue, StatisticsEvents.SAMPLE_MEAN_EVENT);
            charts.setCell(dN.getSwingPanel(), 1, 0);
            BoxAndWhiskerChart bwdN = new BoxAndWhiskerChart(this.getSimulator(), "dN boxplot");
            bwdN.add((EventBasedTally)model.tallyTimeInQueue);
            charts.setCell(bwdN.getSwingPanel(), 2, 0);
            StatisticsTable dNTable = new StatisticsTable((StatisticsTableModel)new TallyTableModel(model.tallyTimeInQueue));
            charts.setCell(dNTable.getSwingPanel(), 3, 0);
            XYChart qNVal = new XYChart(this.getSimulator(), "queue length (qN)").setLabelXAxis("time (s)").setLabelYAxis("qN");
            qNVal.add("qN value", (EventProducer)model.persistentQueueLength, SimPersistent.TIMED_OBSERVATION_ADDED_EVENT);
            charts.setCell(qNVal.getSwingPanel(), 0, 1);
            XYChart qN = new XYChart(this.getSimulator(), "avg queue length").setLabelXAxis("time (s)").setLabelYAxis("avg qN");
            qN.add("qN mean", (EventProducer)model.persistentQueueLength, StatisticsEvents.TIMED_WEIGHTED_SAMPLE_MEAN_EVENT);
            charts.setCell(qN.getSwingPanel(), 1, 1);
            BoxAndWhiskerChart bwqN = new BoxAndWhiskerChart(this.getSimulator(), "qN boxplot");
            bwqN.add((EventBasedTimestampWeightedTally)model.persistentQueueLength);
            charts.setCell(bwqN.getSwingPanel(), 2, 1);
            StatisticsTable qNTable = new StatisticsTable((StatisticsTableModel)new PersistentTableModel(model.persistentQueueLength));
            charts.setCell(qNTable.getSwingPanel(), 3, 1);
            XYChart utilization = new XYChart(this.getSimulator(), "utilization").setLabelXAxis("time (s)").setLabelYAxis("uN");
            utilization.add("utilization", (EventProducer)model.persistentUtilization, SimPersistent.TIMED_OBSERVATION_ADDED_EVENT);
            charts.setCell(utilization.getSwingPanel(), 0, 2);
            XYChart meanUtilization = new XYChart(this.getSimulator(), "avg utilization (uN)").setLabelXAxis("time (s)").setLabelYAxis("avg uN");
            meanUtilization.add("mean utilization", (EventProducer)model.persistentUtilization, StatisticsEvents.TIMED_WEIGHTED_SAMPLE_MEAN_EVENT);
            charts.setCell(meanUtilization.getSwingPanel(), 1, 2);
            BoxAndWhiskerChart bwuN = new BoxAndWhiskerChart(this.getSimulator(), "uN boxplot");
            bwuN.add((EventBasedTimestampWeightedTally)model.persistentUtilization);
            charts.setCell(bwuN.getSwingPanel(), 2, 2);
            StatisticsTable uNTable = new StatisticsTable((StatisticsTableModel)new PersistentTableModel(model.persistentUtilization));
            charts.setCell(uNTable.getSwingPanel(), 3, 2);
            XYChart tNVal = new XYChart(this.getSimulator(), "time in system (tN)").setLabelXAxis("time (s)").setLabelYAxis("tN");
            tNVal.add("tN value", (EventProducer)model.tallyTimeInSystem, StatisticsEvents.OBSERVATION_ADDED_EVENT);
            charts.setCell(tNVal.getSwingPanel(), 0, 3);
            XYChart tN = new XYChart(this.getSimulator(), "avg time in system").setLabelXAxis("time (s)").setLabelYAxis("avg tN");
            tN.add("tN mean", (EventProducer)model.tallyTimeInSystem, StatisticsEvents.SAMPLE_MEAN_EVENT);
            charts.setCell(tN.getSwingPanel(), 1, 3);
            BoxAndWhiskerChart bwtN = new BoxAndWhiskerChart(this.getSimulator(), "tN boxplot");
            bwtN.add((EventBasedTally)model.tallyTimeInSystem);
            charts.setCell(bwtN.getSwingPanel(), 2, 3);
            StatisticsTable tNTable = new StatisticsTable((StatisticsTableModel)new TallyTableModel(model.tallyTimeInSystem));
            charts.setCell(tNTable.getSwingPanel(), 3, 3);
        }
        catch (RemoteException exception) {
            ((DevsSimulatorInterface)model.getSimulator()).getLogger().always().error((Throwable)exception);
        }
        ConsoleLogger logConsole = new ConsoleLogger(Level.INFO);
        this.getTabbedPane().addTab("logger", logConsole);
        this.getTabbedPane().addTab("console", new ConsoleOutput());
    }
}

