/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.introspection.gui;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import nl.tudelft.simulation.dsol.swing.introspection.gui.DefaultModelManager;
import nl.tudelft.simulation.dsol.swing.introspection.gui.ExpandButton;
import nl.tudelft.simulation.dsol.swing.introspection.gui.IntrospectingTableModelInterface;
import nl.tudelft.simulation.dsol.swing.introspection.gui.ModelManager;
import nl.tudelft.simulation.dsol.swing.introspection.table.DynamicTableModel;
import nl.tudelft.simulation.introspection.AbstractProperty;
import nl.tudelft.simulation.introspection.Introspector;
import nl.tudelft.simulation.introspection.Property;
import nl.tudelft.simulation.introspection.beans.BeanIntrospector;
import org.djutils.immutablecollections.ImmutableCollection;
import org.djutils.immutablecollections.ImmutableIterator;
import org.djutils.logger.CategoryLogger;

public class CollectionTableModel
extends AbstractTableModel
implements IntrospectingTableModelInterface,
DynamicTableModel {
    private static final long serialVersionUID = 20140831L;
    protected Map<Integer, Object> instances = Collections.synchronizedMap(new LinkedHashMap(20));
    protected List<Integer> keys = Collections.synchronizedList(new ArrayList(20));
    private Class<?> componentType = null;
    private static final String[] COLUMNS = new String[]{"#", "+", "Instance"};
    private List<ExpandButton> buttons = Collections.synchronizedList(new ArrayList(20));
    private Property parentProperty;
    private Introspector introspector;
    private ModelManager manager = new DefaultModelManager();
    private int maxKey = 0;

    public CollectionTableModel(Property parentProperty) {
        this(parentProperty, (Introspector)new BeanIntrospector());
    }

    public CollectionTableModel(Property parentProperty, Introspector introspector) {
        ImmutableIterator i;
        Object values;
        try {
            values = parentProperty.getValue();
        }
        catch (Exception e) {
            values = new String("-");
        }
        if (values.getClass().isArray()) {
            for (int i2 = 0; i2 < Array.getLength(values); ++i2) {
                this.addValue(Array.get(values, i2));
            }
        }
        if (values instanceof Collection) {
            i = ((Collection)values).iterator();
            while (i.hasNext()) {
                this.addValue(i.next());
            }
        }
        if (values instanceof ImmutableCollection) {
            i = ((ImmutableCollection)values).iterator();
            while (i.hasNext()) {
                this.addValue(i.next());
            }
        }
        this.parentProperty = parentProperty;
        this.introspector = introspector;
        for (int i3 = 0; i3 < this.instances.size(); ++i3) {
            this.buttons.add(new ExpandButton(this.getProperty(i3), this));
        }
    }

    private void addValue(Object value) {
        Integer nextKey = this.maxKey++;
        this.keys.add(nextKey);
        this.instances.put(nextKey, value);
    }

    @Override
    public int getRowCount() {
        return this.instances.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return rowIndex;
        }
        if (columnIndex == 1) {
            return this.buttons.get(rowIndex);
        }
        if (columnIndex == 2) {
            return this.instances.get(this.keys.get(rowIndex));
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMNS[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1 || columnIndex == 2;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 2) {
            Integer key = this.keys.get(rowIndex);
            this.instances.put(key, aValue);
        }
        this.update();
    }

    private void update() {
        ArrayList<Object> newValue = new ArrayList<Object>(this.keys.size());
        for (int i = 0; i < this.keys.size(); ++i) {
            newValue.add(this.instances.get(this.keys.get(i)));
        }
        this.parentProperty.setValue(newValue);
        this.fireTableDataChanged();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 1) {
            return ExpandButton.class;
        }
        return Object.class;
    }

    @Override
    public Property getProperty(String propertyName) {
        int index = Integer.parseInt(propertyName);
        return this.getProperty(index);
    }

    protected Property getProperty(int index) {
        return new CollectionProperty(this.keys.get(index), this.parentProperty.getName());
    }

    @Override
    public void createRow() {
        if (this.componentType == null) {
            this.componentType = this.parentProperty.getComponentType();
            if (this.componentType == null) {
                return;
            }
        }
        try {
            Constructor<?> instanceConstructor = this.componentType.getConstructor(new Class[0]);
            Object instance = instanceConstructor.newInstance(new Object[0]);
            this.addValue(instance);
            this.buttons.add(new ExpandButton(this.getProperty(this.instances.size() - 1), this));
            this.update();
        }
        catch (Exception e) {
            CategoryLogger.always().warn((Throwable)e, "createRow: Could not instantiate new instance: ");
        }
    }

    @Override
    public void createRows(int amount) {
        for (int i = 0; i < amount; ++i) {
            this.createRow();
        }
    }

    @Override
    public void deleteRow(int index) {
        Integer deletionKey = this.keys.get(index);
        this.instances.remove(deletionKey);
        this.keys.remove(index);
        this.buttons.remove(index);
        this.update();
    }

    @Override
    public synchronized void deleteRows(int[] indices) {
        Arrays.sort(indices);
        for (int i = indices.length - 1; i >= 0; --i) {
            this.deleteRow(indices[i]);
        }
    }

    @Override
    public Introspector getIntrospector() {
        return this.introspector;
    }

    @Override
    public Class<?> getTypeAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        if (columnIndex == 1) {
            return ExpandButton.class;
        }
        if (columnIndex == 2) {
            return this.instances.get(this.keys.get(rowIndex)).getClass();
        }
        return null;
    }

    public void setModelManager(ModelManager manager) {
        this.manager = manager;
    }

    @Override
    public ModelManager getModelManager() {
        return this.manager;
    }

    @Override
    public boolean isRowEditable() {
        return this.parentProperty.isEditable();
    }

    public String toString() {
        return "CollectionTableModel";
    }

    class CollectionProperty
    extends AbstractProperty
    implements Property {
        private final Integer key;
        private final String name;

        CollectionProperty(Integer key, String name) {
            this.key = key;
            this.name = name;
        }

        public Object getInstance() {
            return CollectionTableModel.this.instances.values();
        }

        public String getName() {
            return this.name + "[" + CollectionTableModel.this.keys.indexOf(this.key) + "]";
        }

        public Class<?> getType() {
            return CollectionTableModel.this.instances.get(this.key).getClass();
        }

        public Object getValue() {
            try {
                return CollectionTableModel.this.instances.get(this.key);
            }
            catch (Exception e) {
                return new String("-");
            }
        }

        public boolean isEditable() {
            return true;
        }

        protected void setRegularValue(Object value) {
            throw new IllegalArgumentException(this + " is only supposed to be set to composite values.A program is not supposed to arrive here.");
        }

        public String toString() {
            return "Coll.Prop, key:" + this.key;
        }
    }
}

