/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.introspection.gui;

import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import nl.tudelft.simulation.dsol.swing.introspection.gui.CollectionTableModel;
import nl.tudelft.simulation.dsol.swing.introspection.gui.ICellPresentationConfigProvider;
import nl.tudelft.simulation.dsol.swing.introspection.gui.ImmutableCollectionTableModel;
import nl.tudelft.simulation.dsol.swing.introspection.gui.IntrospectingTableModelInterface;
import nl.tudelft.simulation.dsol.swing.introspection.gui.IntrospectionDialog;
import nl.tudelft.simulation.dsol.swing.introspection.gui.MapTableModel;
import nl.tudelft.simulation.dsol.swing.introspection.gui.ModelManager;
import nl.tudelft.simulation.dsol.swing.introspection.gui.ObjectJTable;
import nl.tudelft.simulation.dsol.swing.introspection.gui.ObjectTableModel;
import nl.tudelft.simulation.dsol.swing.introspection.mapping.CellPresentationConfiguration;
import nl.tudelft.simulation.dsol.swing.introspection.mapping.DefaultConfiguration;
import nl.tudelft.simulation.introspection.Introspector;
import nl.tudelft.simulation.introspection.Property;
import org.djutils.logger.CategoryLogger;

public class ExpandButton
extends JButton {
    private static final long serialVersionUID = 20140831L;
    private JTable myTable;
    private final Property PROPERTY;
    private final IntrospectingTableModelInterface MODEL;

    public ExpandButton(Property property, IntrospectingTableModelInterface model) {
        super("+");
        this.setMargin(new Insets(0, 0, 0, 0));
        this.PROPERTY = property;
        this.MODEL = model;
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpandButton.this.showTable();
            }
        };
        this.addActionListener(al);
    }

    public void setMyJTable(JTable table) {
        this.myTable = table;
    }

    public void showTable() {
        if (this.PROPERTY.getValue() == null) {
            return;
        }
        if (this.myTable != null) {
            Window parentWindow = SwingUtilities.getWindowAncestor(this);
            new IntrospectionDialog(parentWindow, this.PROPERTY.getName() + ", " + this.PROPERTY.getValue(), this.instantiateTable());
        } else {
            new IntrospectionDialog(this.PROPERTY.getName() + ", " + this.PROPERTY.getValue(), this.instantiateTable());
        }
    }

    private JTable instantiateTable() {
        TableModel newModel = null;
        ModelManager manager = this.MODEL.getModelManager();
        Introspector introspector = this.MODEL.getIntrospector();
        try {
            Constructor<?> c;
            Class<?> modelClass = null;
            if (this.PROPERTY.getComposedType().isArray()) {
                modelClass = manager.getDefaultCollectionObjectTableModel();
                c = modelClass.getConstructor(Property.class, Introspector.class);
                newModel = (IntrospectingTableModelInterface)c.newInstance(this.PROPERTY, introspector);
            } else if (this.PROPERTY.getComposedType().isCollection()) {
                modelClass = manager.getDefaultCollectionObjectTableModel();
                c = modelClass.getConstructor(Property.class, Introspector.class);
                newModel = (IntrospectingTableModelInterface)c.newInstance(this.PROPERTY, introspector);
            } else if (this.PROPERTY.getComposedType().isImmutableCollection()) {
                modelClass = manager.getDefaultCollectionObjectTableModel();
                c = modelClass.getConstructor(Property.class, Introspector.class);
                newModel = (IntrospectingTableModelInterface)c.newInstance(this.PROPERTY, introspector);
            } else if (this.PROPERTY.getComposedType().isMap()) {
                modelClass = manager.getDefaultMapObjectTableModel();
                c = modelClass.getConstructor(Property.class, Introspector.class);
                newModel = (IntrospectingTableModelInterface)c.newInstance(this.PROPERTY, introspector);
            } else if (this.PROPERTY.getComposedType().isImmutableMap()) {
                modelClass = manager.getDefaultMapObjectTableModel();
                c = modelClass.getConstructor(Property.class, Introspector.class);
                newModel = (IntrospectingTableModelInterface)c.newInstance(this.PROPERTY, introspector);
            } else {
                modelClass = manager.getDefaultObjectTableModel();
                c = modelClass.getConstructor(Object.class, Introspector.class);
                newModel = (IntrospectingTableModelInterface)c.newInstance(this.PROPERTY.getValue(), introspector);
            }
        }
        catch (Exception exception) {
            CategoryLogger.always().warn((Throwable)exception, "instantiate: could not instantiate parent tablemodel, using default");
            newModel = this.PROPERTY.getComposedType().isArray() ? new CollectionTableModel(this.PROPERTY) : (this.PROPERTY.getComposedType().isCollection() ? new CollectionTableModel(this.PROPERTY) : (this.PROPERTY.getComposedType().isImmutableCollection() ? new ImmutableCollectionTableModel(this.PROPERTY) : (this.PROPERTY.getComposedType().isMap() ? new MapTableModel(this.PROPERTY) : (this.PROPERTY.getComposedType().isImmutableMap() ? new MapTableModel(this.PROPERTY) : new ObjectTableModel(this.PROPERTY.getValue())))));
        }
        CellPresentationConfiguration config = DefaultConfiguration.getDefaultConfiguration();
        if (this.myTable instanceof ICellPresentationConfigProvider) {
            config = ((ICellPresentationConfigProvider)((Object)this.myTable)).getCellPresentationConfiguration();
        }
        ObjectJTable result = new ObjectJTable((IntrospectingTableModelInterface)newModel, config);
        newModel.getModelManager().setDefaultCollectionObjectTableModel(manager.getDefaultCollectionObjectTableModel());
        newModel.getModelManager().setDefaultObjectTableModel(manager.getDefaultObjectTableModel());
        result.repaint();
        return result;
    }

    @Override
    public String toString() {
        return "ExpandButton [PROPERTY=" + this.PROPERTY + ", MODEL=" + this.MODEL + "]";
    }
}

