/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.introspection.gui;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import nl.tudelft.simulation.dsol.swing.introspection.gui.DefaultModelManager;
import nl.tudelft.simulation.dsol.swing.introspection.gui.ExpandButton;
import nl.tudelft.simulation.dsol.swing.introspection.gui.IntrospectingTableModelInterface;
import nl.tudelft.simulation.dsol.swing.introspection.gui.ModelManager;
import nl.tudelft.simulation.introspection.AbstractProperty;
import nl.tudelft.simulation.introspection.Introspector;
import nl.tudelft.simulation.introspection.Property;
import nl.tudelft.simulation.introspection.beans.BeanIntrospector;
import org.djutils.immutablecollections.ImmutableCollection;
import org.djutils.immutablecollections.ImmutableIterator;

public class ImmutableCollectionTableModel
extends AbstractTableModel
implements IntrospectingTableModelInterface {
    private static final long serialVersionUID = 20140831L;
    protected Map<Integer, Object> instances = Collections.synchronizedMap(new LinkedHashMap(20));
    protected List<Integer> keys = Collections.synchronizedList(new ArrayList(20));
    private static final String[] COLUMNS = new String[]{"#", "+", "Instance"};
    private List<ExpandButton> buttons = Collections.synchronizedList(new ArrayList(20));
    private Property parentProperty;
    private Introspector introspector;
    private ModelManager manager = new DefaultModelManager();
    private int maxKey = 0;

    public ImmutableCollectionTableModel(Property parentProperty) {
        this(parentProperty, (Introspector)new BeanIntrospector());
    }

    public ImmutableCollectionTableModel(Property parentProperty, Introspector introspector) {
        ImmutableIterator i;
        Object values;
        try {
            values = parentProperty.getValue();
        }
        catch (Exception e) {
            values = new String("-");
        }
        if (values.getClass().isArray()) {
            for (int i2 = 0; i2 < Array.getLength(values); ++i2) {
                this.addValue(Array.get(values, i2));
            }
        }
        if (values instanceof Collection) {
            i = ((Collection)values).iterator();
            while (i.hasNext()) {
                this.addValue(i.next());
            }
        }
        if (values instanceof ImmutableCollection) {
            i = ((ImmutableCollection)values).iterator();
            while (i.hasNext()) {
                this.addValue(i.next());
            }
        }
        this.parentProperty = parentProperty;
        this.introspector = introspector;
        for (int i3 = 0; i3 < this.instances.size(); ++i3) {
            this.buttons.add(new ExpandButton(this.getProperty(i3), this));
        }
    }

    private void addValue(Object value) {
        Integer nextKey = this.maxKey++;
        this.keys.add(nextKey);
        this.instances.put(nextKey, value);
    }

    @Override
    public int getRowCount() {
        return this.instances.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return rowIndex;
        }
        if (columnIndex == 1) {
            return this.buttons.get(rowIndex);
        }
        if (columnIndex == 2) {
            return this.instances.get(this.keys.get(rowIndex));
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMNS[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            return;
        }
        throw new IllegalArgumentException("cannot set values in an ImmutableCollection...");
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 1) {
            return ExpandButton.class;
        }
        return Object.class;
    }

    @Override
    public Property getProperty(String propertyName) {
        int index = Integer.parseInt(propertyName);
        return this.getProperty(index);
    }

    protected Property getProperty(int index) {
        return new ImmutableCollectionProperty(this.keys.get(index), this.parentProperty.getName());
    }

    @Override
    public Introspector getIntrospector() {
        return this.introspector;
    }

    @Override
    public Class<?> getTypeAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        if (columnIndex == 1) {
            return ExpandButton.class;
        }
        if (columnIndex == 2) {
            return this.instances.get(this.keys.get(rowIndex)).getClass();
        }
        return null;
    }

    public void setModelManager(ModelManager manager) {
        this.manager = manager;
    }

    @Override
    public ModelManager getModelManager() {
        return this.manager;
    }

    public String toString() {
        return "ImmutableCollectionTableModel";
    }

    class ImmutableCollectionProperty
    extends AbstractProperty
    implements Property {
        private final Integer key;
        private final String name;

        ImmutableCollectionProperty(Integer key, String name) {
            this.key = key;
            this.name = name;
        }

        public Object getInstance() {
            return ImmutableCollectionTableModel.this.instances.values();
        }

        public String getName() {
            return this.name + "[" + ImmutableCollectionTableModel.this.keys.indexOf(this.key) + "]";
        }

        public Class<?> getType() {
            return ImmutableCollectionTableModel.this.instances.get(this.key).getClass();
        }

        public Object getValue() {
            try {
                return ImmutableCollectionTableModel.this.instances.get(this.key);
            }
            catch (Exception e) {
                return new String("-");
            }
        }

        public boolean isEditable() {
            return false;
        }

        protected void setRegularValue(Object value) {
            throw new IllegalArgumentException(this + " is only supposed to be set to composite values.A program is not supposed to arrive here.");
        }

        public String toString() {
            return "ImmColl.Prop, key:" + this.key;
        }
    }
}

