/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.introspection.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import nl.tudelft.simulation.dsol.swing.introspection.gui.DefaultModelManager;
import nl.tudelft.simulation.dsol.swing.introspection.gui.ExpandButton;
import nl.tudelft.simulation.dsol.swing.introspection.gui.IntrospectingTableModelInterface;
import nl.tudelft.simulation.dsol.swing.introspection.gui.ModelManager;
import nl.tudelft.simulation.introspection.AbstractProperty;
import nl.tudelft.simulation.introspection.Introspector;
import nl.tudelft.simulation.introspection.Property;
import nl.tudelft.simulation.introspection.beans.BeanIntrospector;
import org.djutils.immutablecollections.ImmutableMap;
import org.djutils.logger.CategoryLogger;

public class MapTableModel
extends AbstractTableModel
implements IntrospectingTableModelInterface {
    private static final long serialVersionUID = 20140831L;
    protected Map<Integer, Object> keyMap = Collections.synchronizedMap(new LinkedHashMap(20));
    protected Map<Integer, Object> valueMap = Collections.synchronizedMap(new LinkedHashMap(20));
    protected List<Integer> rowKeys = Collections.synchronizedList(new ArrayList(20));
    private static final String[] COLUMNS = new String[]{"#", "+", "Key", "Value"};
    private List<ExpandButton> buttons = Collections.synchronizedList(new ArrayList(20));
    private Property parentProperty;
    private Introspector introspector;
    private ModelManager manager = new DefaultModelManager();
    private int maxKey = 0;

    public MapTableModel(Property parentProperty) {
        this(parentProperty, (Introspector)new BeanIntrospector());
    }

    public MapTableModel(Property parentProperty, Introspector introspector) {
        Map map;
        LinkedHashMap values;
        try {
            values = parentProperty.getValue();
        }
        catch (Exception e) {
            values = new LinkedHashMap();
        }
        if (values instanceof Map) {
            map = values;
            for (Object key : map.keySet()) {
                this.addValue(key, map.get(key));
            }
        }
        if (values instanceof ImmutableMap) {
            map = (ImmutableMap)values;
            for (Object key : map.keySet()) {
                this.addValue(key, map.get(key));
            }
        }
        this.parentProperty = parentProperty;
        this.introspector = introspector;
        for (int i = 0; i < this.keyMap.size(); ++i) {
            ExpandButton button = new ExpandButton(this.getProperty(i), this);
            this.buttons.add(button);
        }
        this.fireTableDataChanged();
    }

    private void addValue(Object key, Object value) {
        Integer nextKey = this.maxKey++;
        this.rowKeys.add(nextKey);
        this.keyMap.put(nextKey, key);
        this.valueMap.put(nextKey, value);
    }

    @Override
    public int getRowCount() {
        return this.keyMap.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return rowIndex;
        }
        if (columnIndex == 1) {
            return this.buttons.get(rowIndex);
        }
        if (columnIndex == 2) {
            return this.keyMap.get(this.rowKeys.get(rowIndex));
        }
        if (columnIndex == 3) {
            return this.valueMap.get(this.rowKeys.get(rowIndex));
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMNS[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    @Override
    public void setValueAt(Object keyValue, int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            return;
        }
        CategoryLogger.always().warn("cannot set values in a Map...");
        throw new IllegalArgumentException("cannot set values in a Map...");
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 1) {
            return ExpandButton.class;
        }
        return Object.class;
    }

    @Override
    public Property getProperty(String propertyName) {
        int index = Integer.parseInt(propertyName);
        return this.getProperty(index);
    }

    protected Property getProperty(int index) {
        return new MapProperty(this.rowKeys.get(index), this.parentProperty.getName());
    }

    @Override
    public Introspector getIntrospector() {
        return this.introspector;
    }

    @Override
    public Class<?> getTypeAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        if (columnIndex == 1) {
            return ExpandButton.class;
        }
        if (columnIndex == 2) {
            return this.keyMap.get(this.rowKeys.get(rowIndex)).getClass();
        }
        if (columnIndex == 3) {
            return this.valueMap.get(this.rowKeys.get(rowIndex)).getClass();
        }
        return null;
    }

    public void setModelManager(ModelManager manager) {
        this.manager = manager;
    }

    @Override
    public ModelManager getModelManager() {
        return this.manager;
    }

    public String toString() {
        return "MapTableModel";
    }

    class MapProperty
    extends AbstractProperty
    implements Property {
        private final Integer key;
        private final String name;

        MapProperty(Integer key, String name) {
            this.key = key;
            this.name = name;
        }

        public Object getInstance() {
            return MapTableModel.this.valueMap.values();
        }

        public String getName() {
            return this.name + "[" + MapTableModel.this.rowKeys.indexOf(this.key) + "]";
        }

        public Class<?> getType() {
            return MapTableModel.this.valueMap.get(this.key).getClass();
        }

        public Object getValue() {
            try {
                return MapTableModel.this.valueMap.get(this.key);
            }
            catch (Exception e) {
                return new String("-");
            }
        }

        public boolean isEditable() {
            return false;
        }

        protected void setRegularValue(Object value) {
            throw new IllegalArgumentException(this + " is only supposed to be set to composite values.A program is not supposed to arrive here.");
        }

        public String toString() {
            return "Map.Prop, key:" + this.key;
        }
    }
}

