/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.introspection.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Collection;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import nl.tudelft.simulation.dsol.swing.introspection.gui.ICellPresentationConfigProvider;
import nl.tudelft.simulation.dsol.swing.introspection.gui.IntrospectingTableModelInterface;
import nl.tudelft.simulation.dsol.swing.introspection.gui.ObjectJTableInterface;
import nl.tudelft.simulation.dsol.swing.introspection.gui.SortingObjectTableModel;
import nl.tudelft.simulation.dsol.swing.introspection.gui.UpdateTimer;
import nl.tudelft.simulation.dsol.swing.introspection.mapping.CellPresentationConfiguration;
import nl.tudelft.simulation.dsol.swing.introspection.mapping.DefaultConfiguration;
import nl.tudelft.simulation.dsol.swing.introspection.sortable.SortDefinition;
import nl.tudelft.simulation.dsol.swing.introspection.sortable.SortingTableHeader;
import org.djutils.immutablecollections.ImmutableCollection;
import org.djutils.immutablecollections.ImmutableMap;

public class ObjectJTable
extends JTable
implements ObjectJTableInterface,
ICellPresentationConfigProvider {
    private static final long serialVersionUID = 20140831L;
    private static UpdateTimer updateTimer = new UpdateTimer(100L);
    protected boolean hasShown = false;
    private IntrospectingTableModelInterface introspectionTableModel;
    private final CellPresentationConfiguration CONFIG;

    public ObjectJTable(IntrospectingTableModelInterface dm) {
        this(dm, DefaultConfiguration.getDefaultConfiguration());
    }

    public ObjectJTable(IntrospectingTableModelInterface dm, CellPresentationConfiguration config) {
        super(new SortingObjectTableModel(dm));
        this.CONFIG = config;
        this.init(dm);
    }

    public ObjectJTable(IntrospectingTableModelInterface dm, TableColumnModel cm) {
        super(new SortingObjectTableModel(dm), cm);
        this.CONFIG = DefaultConfiguration.getDefaultConfiguration();
        this.init(dm);
    }

    public ObjectJTable(IntrospectingTableModelInterface dm, TableColumnModel cm, ListSelectionModel sm) {
        super(new SortingObjectTableModel(dm), cm, sm);
        this.CONFIG = DefaultConfiguration.getDefaultConfiguration();
        this.init(dm);
    }

    @Override
    public CellPresentationConfiguration getCellPresentationConfiguration() {
        return this.CONFIG;
    }

    private void init(IntrospectingTableModelInterface model) {
        this.introspectionTableModel = model;
        this.initConfig();
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
        SortingTableHeader header = new SortingTableHeader(new SortDefinition[]{new SortDefinition(0, true)});
        this.setTableHeader(header);
        ((JTableHeader)header).setColumnModel(this.getColumnModel());
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)header, "North");
        panel.add((Component)this, "Center");
        updateTimer.add(this);
    }

    @Override
    public TableCellRenderer getDefaultRenderer(Class<?> columnClass) {
        if (columnClass.isArray()) {
            return super.getDefaultRenderer(Object[].class);
        }
        if (Collection.class.isAssignableFrom(columnClass)) {
            return super.getDefaultRenderer(Collection.class);
        }
        if (ImmutableCollection.class.isAssignableFrom(columnClass)) {
            return super.getDefaultRenderer(ImmutableCollection.class);
        }
        if (Map.class.isAssignableFrom(columnClass)) {
            return super.getDefaultRenderer(Map.class);
        }
        if (ImmutableMap.class.isAssignableFrom(columnClass)) {
            return super.getDefaultRenderer(ImmutableMap.class);
        }
        return super.getDefaultRenderer(columnClass);
    }

    private void initConfig() {
        this.addHierarchyListener(new ParentListener());
        Class<?>[][] renderers = this.CONFIG.getRenderers();
        Class<?>[][] editors = this.CONFIG.getEditors();
        try {
            int i;
            for (i = 0; i < renderers.length; ++i) {
                this.setDefaultRenderer(renderers[i][0], (TableCellRenderer)renderers[i][1].newInstance());
            }
            for (i = 0; i < editors.length; ++i) {
                this.setDefaultEditor(editors[i][0], (TableCellEditor)editors[i][1].newInstance());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Configuration " + this.CONFIG + "failed, probably invalid classes.");
        }
        this.getColumn(this.getColumnName(0)).setPreferredWidth(150);
        this.getColumn(this.getColumnName(1)).setMaxWidth(25);
        if (this.getColumnCount() == 3) {
            this.getColumn(this.getColumnName(2)).setPreferredWidth(600);
        } else {
            this.getColumn(this.getColumnName(2)).setPreferredWidth(200);
            this.getColumn(this.getColumnName(3)).setPreferredWidth(400);
        }
        this.setAutoResizeMode(3);
    }

    @Override
    public IntrospectingTableModelInterface getIntrospectingTableModel() {
        return this.introspectionTableModel;
    }

    protected class ParentListener
    implements HierarchyListener {
        protected ParentListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if (e.getChangeFlags() == 2L) {
                if (!ObjectJTable.this.hasShown && ObjectJTable.this.isDisplayable()) {
                    ObjectJTable.this.hasShown = true;
                    return;
                }
                if (ObjectJTable.this.hasShown && !ObjectJTable.this.isDisplayable()) {
                    ObjectJTable.this.getModel().removeTableModelListener(ObjectJTable.this);
                }
            }
        }
    }
}

