/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.introspection.gui;

import java.util.Arrays;
import javax.swing.table.AbstractTableModel;
import nl.tudelft.simulation.dsol.swing.introspection.gui.DefaultModelManager;
import nl.tudelft.simulation.dsol.swing.introspection.gui.ExpandButton;
import nl.tudelft.simulation.dsol.swing.introspection.gui.IntrospectingTableModelInterface;
import nl.tudelft.simulation.dsol.swing.introspection.gui.ModelManager;
import nl.tudelft.simulation.introspection.Introspector;
import nl.tudelft.simulation.introspection.Property;
import nl.tudelft.simulation.introspection.beans.BeanIntrospector;
import org.djutils.logger.CategoryLogger;

public class ObjectTableModel
extends AbstractTableModel
implements IntrospectingTableModelInterface {
    private static final long serialVersionUID = 20140831L;
    protected Property[] properties = new Property[0];
    private static String[] columns = new String[]{"Property", "+", "Value"};
    private ExpandButton[] buttons;
    private Introspector introspector = null;
    private ModelManager manager = new DefaultModelManager();

    public ObjectTableModel(Object bean) {
        this(bean, (Introspector)new BeanIntrospector());
    }

    public ObjectTableModel(Object object, Introspector introspector) {
        this.properties = introspector.getProperties(object);
        this.buttons = new ExpandButton[this.properties.length];
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i] = new ExpandButton(this.properties[i], this);
        }
        this.introspector = introspector;
    }

    @Override
    public int getRowCount() {
        return this.properties.length;
    }

    @Override
    public int getColumnCount() {
        return columns.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Property requested = this.properties[rowIndex];
        if (columnIndex == 0) {
            return requested.getName();
        }
        if (columnIndex == 1) {
            return this.buttons[rowIndex];
        }
        if (columnIndex == 2) {
            try {
                return requested.getValue();
            }
            catch (Exception e) {
                return new String("-");
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columns[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            return true;
        }
        if (columnIndex == 2) {
            return this.properties[rowIndex].isEditable() && !this.properties[rowIndex].getType().isArray();
        }
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 2 || !this.isCellEditable(rowIndex, columnIndex)) {
            return;
        }
        Property requested = this.properties[rowIndex];
        try {
            requested.setValue(aValue);
        }
        catch (IllegalArgumentException exception) {
            CategoryLogger.always().warn((Throwable)exception, "setValueAt");
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 1) {
            return ExpandButton.class;
        }
        return Object.class;
    }

    @Override
    public Class<?> getTypeAt(int rowIndex, int columnIndex) {
        Property requested = this.properties[rowIndex];
        if (columnIndex == 0) {
            return String.class;
        }
        if (columnIndex == 1) {
            return ExpandButton.class;
        }
        if (columnIndex == 2) {
            return requested.getType();
        }
        return null;
    }

    protected int getPropertyIndex(String property) {
        for (int i = 0; i < this.properties.length; ++i) {
            if (!this.properties[i].getName().equalsIgnoreCase(property)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Property getProperty(String propertyName) {
        int index = this.getPropertyIndex(propertyName);
        if (index == -1) {
            return null;
        }
        return this.properties[index];
    }

    @Override
    public Introspector getIntrospector() {
        return this.introspector;
    }

    public void setModelManager(ModelManager manager) {
        this.manager = manager;
    }

    @Override
    public ModelManager getModelManager() {
        return this.manager;
    }

    public String toString() {
        return "ObjectTableModel [properties=" + Arrays.toString(this.properties) + "]";
    }
}

