/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.introspection.gui;

import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;

public class UpdateTimer
extends TimerTask {
    private WeakReference<Component>[] components = new WeakReference[0];
    private Timer timer = null;
    private long period = 300L;

    public UpdateTimer(long period) {
        this.period = period;
    }

    public synchronized void add(Component component) {
        ArrayList<WeakReference<Component>> arrayList = new ArrayList<WeakReference<Component>>(Arrays.asList(this.components));
        arrayList.add(new WeakReference<Component>(component));
        this.components = arrayList.toArray(new WeakReference[arrayList.size()]);
        if (this.timer == null) {
            this.timer = new Timer(true);
            this.timer.scheduleAtFixedRate((TimerTask)this, 0L, this.period);
        }
    }

    public synchronized void remove(Component component) {
        for (int i = this.components.length - 1; i > -1; --i) {
            if (!((Component)this.components[i].get()).equals(component)) continue;
            this.remove(this.components[i]);
        }
    }

    private synchronized void remove(WeakReference<Component> reference) {
        ArrayList<WeakReference<Component>> arrayList = new ArrayList<WeakReference<Component>>(Arrays.asList(this.components));
        arrayList.remove(reference);
        this.components = arrayList.toArray(new WeakReference[arrayList.size()]);
        if (this.components.length == 0) {
            this.timer.cancel();
        }
    }

    @Override
    public void run() {
        for (int i = this.components.length - 1; i > -1; --i) {
            Component component = (Component)this.components[i].get();
            if (component != null) {
                component.repaint();
                continue;
            }
            this.remove(this.components[i]);
        }
    }
}

