/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.introspection.mapping;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class MyColorEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 20140831L;
    protected Color color;
    protected JPanel cellPanel = new JPanel();

    @Override
    public Object getCellEditorValue() {
        return this.color;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.cellPanel.setBackground(((Color)value).darker());
        this.color = (Color)value;
        JColorChooser chooser = new JColorChooser((Color)value);
        JDialog dialog = JColorChooser.createDialog(table, "Color selection", false, chooser, new OKListener(chooser), new CancelListener());
        dialog.setVisible(true);
        return this.cellPanel;
    }

    protected class CancelListener
    implements ActionListener {
        protected CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MyColorEditor.this.cancelCellEditing();
        }
    }

    private class OKListener
    implements ActionListener {
        private JColorChooser chooser;

        OKListener(JColorChooser chooser) {
            this.chooser = chooser;
        }

        @Override
        public synchronized void actionPerformed(ActionEvent event) {
            MyColorEditor.this.color = this.chooser.getColor();
            MyColorEditor.this.stopCellEditing();
            MyColorEditor.this.cellPanel.setBackground(MyColorEditor.this.color.darker());
            MyColorEditor.this.cellPanel.paintImmediately(MyColorEditor.this.cellPanel.getBounds());
        }
    }
}

