/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.introspection.sortable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import nl.tudelft.simulation.dsol.logger.Cat;
import nl.tudelft.simulation.dsol.swing.introspection.sortable.Sortable;
import org.djutils.logger.CategoryLogger;
import org.djutils.logger.LogCategory;

public class SortingTableModel
implements TableModel,
Sortable {
    protected Map<ProxyListener, TableModelListener> proxyListeners = new LinkedHashMap<ProxyListener, TableModelListener>(5);
    protected TableModel source;
    private List<Object> index = Collections.synchronizedList(new ArrayList());
    protected Integer[] expandedIndex;
    private List<Sortable.Definition> definitions = Collections.synchronizedList(new ArrayList());

    public SortingTableModel(TableModel source) {
        this.source = source;
    }

    private synchronized void buildIndex() {
        this.initIndex();
        for (Sortable.Definition definition : this.definitions) {
            this.index = this.sortList(this.index, definition.isAcendingSort(), definition.getFieldID());
        }
        this.expandIndex();
    }

    private void expandIndex() {
        ArrayList<Object> expandedList = new ArrayList<Object>();
        for (Object current : this.index) {
            if (current instanceof List) {
                expandedList.addAll((List)current);
                continue;
            }
            expandedList.add(current);
        }
        this.expandedIndex = expandedList.toArray(new Integer[0]);
    }

    private void initIndex() {
        this.index.clear();
        ArrayList<Integer> entry = new ArrayList<Integer>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            entry.add(i);
        }
        this.index.add(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> sortList(List<Object> unsorted, boolean ascending, int column) {
        ArrayList<Object> result = new ArrayList<Object>(unsorted.size());
        List<Object> list = unsorted;
        synchronized (list) {
            for (Object current : unsorted) {
                if (current instanceof Integer) {
                    result.add(current);
                    continue;
                }
                List currentList = (List)current;
                result.addAll(this.sortSubList(currentList, ascending, column));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> sortSubList(List<?> unsorted, boolean ascending, int column) {
        ArrayList<Object> result = new ArrayList<Object>(unsorted.size());
        List<?> list = unsorted;
        synchronized (list) {
            for (int i = 0; i < unsorted.size(); ++i) {
                Integer unsortedEntry = (Integer)unsorted.get(i);
                Object current = this.source.getValueAt(unsortedEntry, column);
                boolean allocated = false;
                for (int y = 0; y < result.size() && !allocated; ++y) {
                    boolean inList = false;
                    Object resultValue = result.get(y);
                    if (resultValue instanceof List) {
                        inList = true;
                        resultValue = this.source.getValueAt((Integer)((List)resultValue).get(0), column);
                    } else {
                        resultValue = this.source.getValueAt((Integer)resultValue, column);
                    }
                    if (!(current instanceof Comparable) || !(resultValue instanceof Comparable)) continue;
                    try {
                        int comparisson = ((Comparable)current).compareTo(resultValue);
                        if (comparisson == 0) {
                            if (inList) {
                                ((List)result.get(y)).add(unsortedEntry);
                            } else {
                                ArrayList valueList = new ArrayList(2);
                                valueList.add(result.get(y));
                                valueList.add(unsortedEntry);
                                result.remove(y);
                                result.add(y, valueList);
                            }
                            allocated = true;
                        }
                        if ((!ascending || comparisson >= 0) && (ascending || comparisson <= 0)) continue;
                        result.add(y, unsortedEntry);
                        allocated = true;
                        continue;
                    }
                    catch (ClassCastException exception) {
                        CategoryLogger.filter((LogCategory)Cat.SWING).info((Throwable)exception, "sortSubList - Could not compare {} and {}", new Object[]{current, resultValue});
                    }
                }
                if (allocated) continue;
                result.add(unsortedEntry);
            }
        }
        return result;
    }

    @Override
    public Sortable.Definition[] getDefinitions() {
        return this.definitions.toArray(new Sortable.Definition[0]);
    }

    @Override
    public void setDefinitions(Sortable.Definition[] definitions) {
        this.definitions.clear();
        this.definitions.addAll(Arrays.asList(definitions));
    }

    @Override
    public void sort() {
        this.buildIndex();
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        ProxyListener proxy = new ProxyListener();
        this.proxyListeners.put(proxy, l);
        this.source.addTableModelListener(proxy);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.source.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return this.source.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.source.getColumnName(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.source.getRowCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.expandedIndex == null) {
            this.buildIndex();
        }
        if (rowIndex > this.expandedIndex.length) {
            CategoryLogger.always().warn("getValueAt could not retrieve row {} from sorted list. Returning default instead", new Object[]{rowIndex});
            return this.source.getValueAt(rowIndex, columnIndex);
        }
        return this.source.getValueAt(this.expandedIndex[rowIndex], columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.source.isCellEditable(this.expandedIndex[rowIndex], columnIndex);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        ProxyListener proxy = (ProxyListener)this.proxyListeners.get(l);
        this.source.removeTableModelListener(proxy);
        this.proxyListeners.remove(proxy);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex > this.expandedIndex.length) {
            CategoryLogger.always().warn("setValueAt could not retrieve row {} from sorted list. Ignoring 'setValue' command", new Object[]{rowIndex});
            return;
        }
        this.source.setValueAt(aValue, this.expandedIndex[rowIndex], columnIndex);
        this.buildIndex();
        if (this.source instanceof DefaultTableModel) {
            ((DefaultTableModel)this.source).fireTableDataChanged();
        }
    }

    public String toString() {
        return "SortingTableModel";
    }

    protected class ProxyListener
    implements TableModelListener {
        protected ProxyListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            SortingTableModel.this.sort();
            SortingTableModel.this.proxyListeners.get(this).tableChanged(e);
        }
    }
}

