/*
 * Decompiled with CFR 0.152.
 */
package nl.vroste.zio.kinesis.client.dynamicconsumer;

import java.io.Serializable;
import nl.vroste.zio.kinesis.client.dynamicconsumer.SchedulerConfig$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.kinesis.checkpoint.CheckpointConfig;
import software.amazon.kinesis.common.ConfigsBuilder;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.coordinator.CoordinatorConfig;
import software.amazon.kinesis.leases.LeaseManagementConfig;
import software.amazon.kinesis.lifecycle.LifecycleConfig;
import software.amazon.kinesis.metrics.MetricsConfig;
import software.amazon.kinesis.processor.ProcessorConfig;
import software.amazon.kinesis.retrieval.RetrievalConfig;
import software.amazon.kinesis.retrieval.RetrievalSpecificConfig;
import software.amazon.kinesis.retrieval.fanout.FanOutConfig;
import software.amazon.kinesis.retrieval.polling.PollingConfig;

public class SchedulerConfig
implements Product,
Serializable {
    private final CheckpointConfig checkpoint;
    private final CoordinatorConfig coordinator;
    private final LeaseManagementConfig leaseManagement;
    private final LifecycleConfig lifecycle;
    private final MetricsConfig metrics;
    private final ProcessorConfig processor;
    private final RetrievalConfig retrieval;
    private final KinesisAsyncClient kinesisClient;
    private final String streamName;

    public static SchedulerConfig apply(CheckpointConfig checkpointConfig, CoordinatorConfig coordinatorConfig, LeaseManagementConfig leaseManagementConfig, LifecycleConfig lifecycleConfig, MetricsConfig metricsConfig, ProcessorConfig processorConfig, RetrievalConfig retrievalConfig, KinesisAsyncClient kinesisAsyncClient, String string) {
        return SchedulerConfig$.MODULE$.apply(checkpointConfig, coordinatorConfig, leaseManagementConfig, lifecycleConfig, metricsConfig, processorConfig, retrievalConfig, kinesisAsyncClient, string);
    }

    public static SchedulerConfig fromProduct(Product product) {
        return SchedulerConfig$.MODULE$.fromProduct(product);
    }

    public static SchedulerConfig makeDefault(ConfigsBuilder configsBuilder, KinesisAsyncClient kinesisAsyncClient, InitialPositionInStreamExtended initialPositionInStreamExtended, String string) {
        return SchedulerConfig$.MODULE$.makeDefault(configsBuilder, kinesisAsyncClient, initialPositionInStreamExtended, string);
    }

    public static SchedulerConfig unapply(SchedulerConfig schedulerConfig) {
        return SchedulerConfig$.MODULE$.unapply(schedulerConfig);
    }

    public SchedulerConfig(CheckpointConfig checkpoint, CoordinatorConfig coordinator, LeaseManagementConfig leaseManagement, LifecycleConfig lifecycle, MetricsConfig metrics, ProcessorConfig processor, RetrievalConfig retrieval, KinesisAsyncClient kinesisClient, String streamName) {
        this.checkpoint = checkpoint;
        this.coordinator = coordinator;
        this.leaseManagement = leaseManagement;
        this.lifecycle = lifecycle;
        this.metrics = metrics;
        this.processor = processor;
        this.retrieval = retrieval;
        this.kinesisClient = kinesisClient;
        this.streamName = streamName;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof SchedulerConfig)) return false;
        SchedulerConfig schedulerConfig = (SchedulerConfig)object;
        CheckpointConfig checkpointConfig = this.checkpoint();
        CheckpointConfig checkpointConfig2 = schedulerConfig.checkpoint();
        if (checkpointConfig == null) {
            if (checkpointConfig2 != null) {
                return false;
            }
        } else if (!checkpointConfig.equals(checkpointConfig2)) return false;
        CoordinatorConfig coordinatorConfig = this.coordinator();
        CoordinatorConfig coordinatorConfig2 = schedulerConfig.coordinator();
        if (coordinatorConfig == null) {
            if (coordinatorConfig2 != null) {
                return false;
            }
        } else if (!coordinatorConfig.equals(coordinatorConfig2)) return false;
        LeaseManagementConfig leaseManagementConfig = this.leaseManagement();
        LeaseManagementConfig leaseManagementConfig2 = schedulerConfig.leaseManagement();
        if (leaseManagementConfig == null) {
            if (leaseManagementConfig2 != null) {
                return false;
            }
        } else if (!leaseManagementConfig.equals(leaseManagementConfig2)) return false;
        LifecycleConfig lifecycleConfig = this.lifecycle();
        LifecycleConfig lifecycleConfig2 = schedulerConfig.lifecycle();
        if (lifecycleConfig == null) {
            if (lifecycleConfig2 != null) {
                return false;
            }
        } else if (!lifecycleConfig.equals(lifecycleConfig2)) return false;
        MetricsConfig metricsConfig = this.metrics();
        MetricsConfig metricsConfig2 = schedulerConfig.metrics();
        if (metricsConfig == null) {
            if (metricsConfig2 != null) {
                return false;
            }
        } else if (!metricsConfig.equals(metricsConfig2)) return false;
        ProcessorConfig processorConfig = this.processor();
        ProcessorConfig processorConfig2 = schedulerConfig.processor();
        if (processorConfig == null) {
            if (processorConfig2 != null) {
                return false;
            }
        } else if (!processorConfig.equals(processorConfig2)) return false;
        RetrievalConfig retrievalConfig = this.retrieval();
        RetrievalConfig retrievalConfig2 = schedulerConfig.retrieval();
        if (retrievalConfig == null) {
            if (retrievalConfig2 != null) {
                return false;
            }
        } else if (!retrievalConfig.equals(retrievalConfig2)) return false;
        KinesisAsyncClient kinesisAsyncClient = this.kinesisClient();
        KinesisAsyncClient kinesisAsyncClient2 = schedulerConfig.kinesisClient();
        if (kinesisAsyncClient == null) {
            if (kinesisAsyncClient2 != null) {
                return false;
            }
        } else if (!kinesisAsyncClient.equals(kinesisAsyncClient2)) return false;
        String string = this.streamName();
        String string2 = schedulerConfig.streamName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!schedulerConfig.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof SchedulerConfig;
    }

    public int productArity() {
        return 9;
    }

    public String productPrefix() {
        return "SchedulerConfig";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return this._7();
            }
            case 7: {
                return this._8();
            }
            case 8: {
                return this._9();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "checkpoint";
            }
            case 1: {
                return "coordinator";
            }
            case 2: {
                return "leaseManagement";
            }
            case 3: {
                return "lifecycle";
            }
            case 4: {
                return "metrics";
            }
            case 5: {
                return "processor";
            }
            case 6: {
                return "retrieval";
            }
            case 7: {
                return "kinesisClient";
            }
            case 8: {
                return "streamName";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public CheckpointConfig checkpoint() {
        return this.checkpoint;
    }

    public CoordinatorConfig coordinator() {
        return this.coordinator;
    }

    public LeaseManagementConfig leaseManagement() {
        return this.leaseManagement;
    }

    public LifecycleConfig lifecycle() {
        return this.lifecycle;
    }

    public MetricsConfig metrics() {
        return this.metrics;
    }

    public ProcessorConfig processor() {
        return this.processor;
    }

    public RetrievalConfig retrieval() {
        return this.retrieval;
    }

    private KinesisAsyncClient kinesisClient() {
        return this.kinesisClient;
    }

    private String streamName() {
        return this.streamName;
    }

    public SchedulerConfig withInitialPosition(InitialPositionInStreamExtended pos) {
        LeaseManagementConfig leaseManagementConfig = this.leaseManagement().initialPositionInStream(pos);
        RetrievalConfig retrievalConfig = this.retrieval().initialPositionInStreamExtended(pos);
        CheckpointConfig checkpointConfig = this.copy$default$1();
        CoordinatorConfig coordinatorConfig = this.copy$default$2();
        LifecycleConfig lifecycleConfig = this.copy$default$4();
        MetricsConfig metricsConfig = this.copy$default$5();
        ProcessorConfig processorConfig = this.copy$default$6();
        KinesisAsyncClient kinesisAsyncClient = this.copy$default$8();
        String string = this.copy$default$9();
        return this.copy(checkpointConfig, coordinatorConfig, leaseManagementConfig, lifecycleConfig, metricsConfig, processorConfig, retrievalConfig, kinesisAsyncClient, string);
    }

    public SchedulerConfig withEnhancedFanOut() {
        RetrievalConfig retrievalConfig = this.retrieval().retrievalSpecificConfig((RetrievalSpecificConfig)new FanOutConfig(this.kinesisClient()).streamName(this.streamName()).applicationName(this.retrieval().applicationName()));
        CheckpointConfig checkpointConfig = this.copy$default$1();
        CoordinatorConfig coordinatorConfig = this.copy$default$2();
        LeaseManagementConfig leaseManagementConfig = this.copy$default$3();
        LifecycleConfig lifecycleConfig = this.copy$default$4();
        MetricsConfig metricsConfig = this.copy$default$5();
        ProcessorConfig processorConfig = this.copy$default$6();
        KinesisAsyncClient kinesisAsyncClient = this.copy$default$8();
        String string = this.copy$default$9();
        return this.copy(checkpointConfig, coordinatorConfig, leaseManagementConfig, lifecycleConfig, metricsConfig, processorConfig, retrievalConfig, kinesisAsyncClient, string);
    }

    public SchedulerConfig withPolling() {
        RetrievalConfig retrievalConfig = this.retrieval().retrievalSpecificConfig((RetrievalSpecificConfig)new PollingConfig(this.streamName(), this.kinesisClient()));
        CheckpointConfig checkpointConfig = this.copy$default$1();
        CoordinatorConfig coordinatorConfig = this.copy$default$2();
        LeaseManagementConfig leaseManagementConfig = this.copy$default$3();
        LifecycleConfig lifecycleConfig = this.copy$default$4();
        MetricsConfig metricsConfig = this.copy$default$5();
        ProcessorConfig processorConfig = this.copy$default$6();
        KinesisAsyncClient kinesisAsyncClient = this.copy$default$8();
        String string = this.copy$default$9();
        return this.copy(checkpointConfig, coordinatorConfig, leaseManagementConfig, lifecycleConfig, metricsConfig, processorConfig, retrievalConfig, kinesisAsyncClient, string);
    }

    public SchedulerConfig copy(CheckpointConfig checkpoint, CoordinatorConfig coordinator, LeaseManagementConfig leaseManagement, LifecycleConfig lifecycle, MetricsConfig metrics, ProcessorConfig processor, RetrievalConfig retrieval, KinesisAsyncClient kinesisClient, String streamName) {
        return new SchedulerConfig(checkpoint, coordinator, leaseManagement, lifecycle, metrics, processor, retrieval, kinesisClient, streamName);
    }

    public CheckpointConfig copy$default$1() {
        return this.checkpoint();
    }

    public CoordinatorConfig copy$default$2() {
        return this.coordinator();
    }

    public LeaseManagementConfig copy$default$3() {
        return this.leaseManagement();
    }

    public LifecycleConfig copy$default$4() {
        return this.lifecycle();
    }

    public MetricsConfig copy$default$5() {
        return this.metrics();
    }

    public ProcessorConfig copy$default$6() {
        return this.processor();
    }

    public RetrievalConfig copy$default$7() {
        return this.retrieval();
    }

    public KinesisAsyncClient copy$default$8() {
        return this.kinesisClient();
    }

    public String copy$default$9() {
        return this.streamName();
    }

    public CheckpointConfig _1() {
        return this.checkpoint();
    }

    public CoordinatorConfig _2() {
        return this.coordinator();
    }

    public LeaseManagementConfig _3() {
        return this.leaseManagement();
    }

    public LifecycleConfig _4() {
        return this.lifecycle();
    }

    public MetricsConfig _5() {
        return this.metrics();
    }

    public ProcessorConfig _6() {
        return this.processor();
    }

    public RetrievalConfig _7() {
        return this.retrieval();
    }

    public KinesisAsyncClient _8() {
        return this.kinesisClient();
    }

    public String _9() {
        return this.streamName();
    }
}

