/*
 * Decompiled with CFR 0.152.
 */
package no.difi.meldingsutveksling.noarkexchange;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import no.difi.meldingsutveksling.logging.MarkerFactory;
import no.difi.meldingsutveksling.noarkexchange.NoarkClient;
import no.difi.meldingsutveksling.noarkexchange.NoarkClientSettings;
import no.difi.meldingsutveksling.noarkexchange.PutMessageMarker;
import no.difi.meldingsutveksling.noarkexchange.PutMessageRequestWrapper;
import no.difi.meldingsutveksling.noarkexchange.WebServiceTemplateFactory;
import no.difi.meldingsutveksling.noarkexchange.schema.PutMessageRequestType;
import no.difi.meldingsutveksling.noarkexchange.schema.PutMessageResponseType;
import no.difi.meldingsutveksling.noarkexchange.websak.PutMessageRequestMapper;
import no.difi.meldingsutveksling.noarkexchange.websak.schema.AddressType;
import no.difi.meldingsutveksling.noarkexchange.websak.schema.AppReceiptType;
import no.difi.meldingsutveksling.noarkexchange.websak.schema.GetCanReceiveMessageRequestType;
import no.difi.meldingsutveksling.noarkexchange.websak.schema.GetCanReceiveMessageResponseType;
import no.difi.meldingsutveksling.noarkexchange.websak.schema.ObjectFactory;
import no.difi.meldingsutveksling.noarkexchange.websak.schema.StatusMessageType;
import org.modelmapper.ModelMapper;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.soap.client.core.SoapActionCallback;

public class WebsakClient
implements NoarkClient {
    private static final String SOAP_ACTION = "http://www.arkivverket.no/Noark/Exchange/IEDUImport/PutMessage";
    private final WebServiceTemplateFactory templateFactory;
    private NoarkClientSettings settings;

    public WebsakClient(NoarkClientSettings settings) {
        this.settings = settings;
        this.templateFactory = settings.createTemplateFactory();
    }

    public NoarkClientSettings getNoarkClientSettings() {
        return this.settings;
    }

    public boolean canRecieveMessage(String orgnr) {
        GetCanReceiveMessageRequestType r = new GetCanReceiveMessageRequestType();
        AddressType addressType = new AddressType();
        addressType.setOrgnr(orgnr);
        r.setReceiver(addressType);
        JAXBElement<GetCanReceiveMessageRequestType> request = new ObjectFactory().createGetCanReceiveMessageRequest(r);
        WebServiceTemplate template = this.templateFactory.createTemplate("no.difi.meldingsutveksling.noarkexchange.websak.schema", MarkerFactory.receiverMarker((String)orgnr));
        JAXBElement result = (JAXBElement)template.marshalSendAndReceive(this.settings.getEndpointUrl(), request);
        return ((GetCanReceiveMessageResponseType)result.getValue()).isResult();
    }

    public PutMessageResponseType sendEduMelding(PutMessageRequestType request) {
        JAXBElement<no.difi.meldingsutveksling.noarkexchange.websak.schema.PutMessageRequestType> websakRequest = new PutMessageRequestMapper().mapFrom(request);
        WebServiceTemplate template = this.templateFactory.createTemplate("no.difi.meldingsutveksling.noarkexchange.websak.schema", PutMessageMarker.markerFrom((PutMessageRequestWrapper)new PutMessageRequestWrapper(request)));
        JAXBElement response = (JAXBElement)template.marshalSendAndReceive(this.settings.getEndpointUrl(), websakRequest, (WebServiceMessageCallback)new SoapActionCallback(SOAP_ACTION));
        PutMessageResponseType theResponse = new PutMessageResponseType();
        ModelMapper modelMapper = new ModelMapper();
        modelMapper.map(response.getValue(), (Object)theResponse);
        this.setUnmappedValues((JAXBElement<no.difi.meldingsutveksling.noarkexchange.websak.schema.PutMessageResponseType>)response, theResponse);
        return theResponse;
    }

    private void setUnmappedValues(JAXBElement<no.difi.meldingsutveksling.noarkexchange.websak.schema.PutMessageResponseType> websakResponse, PutMessageResponseType response) {
        List<StatusMessageType> statusMessages = this.getStatusMessages(websakResponse);
        if (!statusMessages.isEmpty()) {
            no.difi.meldingsutveksling.noarkexchange.schema.StatusMessageType statusMessage = new no.difi.meldingsutveksling.noarkexchange.schema.StatusMessageType();
            statusMessage.setCode(statusMessages.get(0).getCode());
            statusMessage.setText(statusMessages.get(0).getText());
            response.getResult().getMessage().add(statusMessage);
        }
    }

    private List<StatusMessageType> getStatusMessages(JAXBElement<no.difi.meldingsutveksling.noarkexchange.websak.schema.PutMessageResponseType> response) {
        List<StatusMessageType> statusMessageTypes = new ArrayList<StatusMessageType>();
        if (response.isNil()) {
            return statusMessageTypes;
        }
        AppReceiptType appReceipt = ((no.difi.meldingsutveksling.noarkexchange.websak.schema.PutMessageResponseType)response.getValue()).getResult();
        if (appReceipt != null) {
            statusMessageTypes = appReceipt.getMessage();
        }
        return statusMessageTypes;
    }
}

