/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.security;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.Cipher;
import no.digipost.security.DigipostSecurityException;
import no.digipost.security.IllegalCertificateType;
import no.digipost.security.cert.CertificateNotFound;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DigipostSecurity {
    public static final String PROVIDER_NAME = "BC";
    public static final String PKIX = "PKIX";
    public static final String X509 = "X.509";
    public static final String JCEKS = "JCEKS";
    private static final Logger LOG = LoggerFactory.getLogger(DigipostSecurity.class);
    private static volatile boolean securityProviderSet = false;
    private static volatile boolean cryptoPolicyPropertySet = false;

    public static CertificateFactory getX509CertificateFactory() {
        try {
            return CertificateFactory.getInstance(X509);
        }
        catch (CertificateException e) {
            throw new RuntimeException("Could not create X.509 certificate factory: '" + e.getMessage() + "'. Available providers: " + Stream.of(Security.getProviders()).map(Provider::getName).collect(Collectors.joining(", ")), e);
        }
    }

    public static X509Certificate readCertificate(String resourceName) {
        return DigipostSecurity.readCertificates(resourceName).findFirst().orElseThrow(() -> new CertificateNotFound(resourceName));
    }

    public static X509Certificate readCertificate(byte[] certificateBytes) {
        return DigipostSecurity.readCertificate(new ByteArrayInputStream(certificateBytes));
    }

    public static X509Certificate readCertificate(InputStream certificateResource) {
        return DigipostSecurity.readCertificates(certificateResource).findFirst().orElseThrow(() -> new CertificateNotFound());
    }

    public static Stream<X509Certificate> readCertificates(String resourceName) {
        InputStream certificateResource = DigipostSecurity.class.getClassLoader().getResourceAsStream(resourceName);
        if (certificateResource == null) {
            throw new RuntimeException(resourceName + " not found");
        }
        return DigipostSecurity.readCertificates(certificateResource);
    }

    public static Stream<X509Certificate> readCertificates(byte[] certificatesBytes) {
        return DigipostSecurity.readCertificates(new ByteArrayInputStream(certificatesBytes));
    }

    public static Stream<X509Certificate> readCertificates(InputStream certificatesResource) {
        try {
            return DigipostSecurity.getX509CertificateFactory().generateCertificates(certificatesResource).stream().map(DigipostSecurity::requireX509);
        }
        catch (CertificateException e) {
            throw new RuntimeException("Unable to generate certificate: " + e.getMessage(), e);
        }
    }

    public static X509Certificate requireX509(Certificate certificate) {
        if (certificate instanceof X509Certificate) {
            return (X509Certificate)certificate;
        }
        throw new IllegalCertificateType(certificate);
    }

    public static Stream<X509Certificate> asStream(CertPath path) {
        return path.getCertificates().stream().map(DigipostSecurity::requireX509);
    }

    public static KeyStore asKeyStore(Iterable<X509Certificate> certificates) {
        try {
            KeyStore keystore = KeyStore.getInstance(JCEKS);
            keystore.load(null, null);
            for (X509Certificate cert : certificates) {
                keystore.setCertificateEntry(cert.getSubjectDN().toString(), cert);
            }
            return keystore;
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new DigipostSecurityException(e);
        }
    }

    public static CertPath asCertPath(Stream<X509Certificate> certificates) {
        List collectedCertificates = certificates.collect(Collectors.toList());
        try {
            return DigipostSecurity.getX509CertificateFactory().generateCertPath(collectedCertificates);
        }
        catch (CertificateException e) {
            throw new DigipostSecurityException(e);
        }
    }

    public static String describe(CertPath certPath) {
        if (certPath == null) {
            return "(null)";
        }
        List<? extends Certificate> certificates = certPath.getCertificates();
        if (!certificates.isEmpty()) {
            return certificates.stream().map(DigipostSecurity::describe).collect(Collectors.joining("\n ^-- Issued by: ", "CertPath with the following certificates:\nCertificate: ", ""));
        }
        return "CertPath with no certificates";
    }

    public static String describe(Certificate certificate) {
        if (certificate == null) {
            return "(null)";
        }
        if (certificate instanceof X509Certificate) {
            X509Certificate x509 = (X509Certificate)certificate;
            return x509.getSubjectDN() + ", issuer: " + x509.getIssuerDN();
        }
        return certificate.getType() + "-certificate";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void ensureSecurityProvider() {
        DigipostSecurity.ensureCryptoPolicyUnlimited();
        if (securityProviderSet) return;
        Class<Security> clazz = Security.class;
        synchronized (Security.class) {
            if (Security.getProvider(PROVIDER_NAME) != null) return;
            Security.addProvider((Provider)new BouncyCastleProvider());
            securityProviderSet = true;
            LOG.info("Security provider BC added: " + BouncyCastleProvider.class.getName());
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void ensureCryptoPolicyUnlimited() {
        if (!cryptoPolicyPropertySet) {
            Security.setProperty("crypto.policy", "unlimited");
            cryptoPolicyPropertySet = true;
            LOG.info("Security policy set: crypto.policy=unlimited");
        }
    }

    public static void verifyJceUnlimitedStrength() {
        try {
            int aesMaxKeyLength = Cipher.getMaxAllowedKeyLength("AES");
            if (aesMaxKeyLength != Integer.MAX_VALUE) {
                throw new DigipostSecurityException("Java Cryptography Extension (JCE) Unlimited Strength not enabled! Maximum allowed key length for AES is " + aesMaxKeyLength);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigipostSecurityException("Error when verifying the maximum key length for the AES algorithm. Is Java Cryptography Extension (JCE) Unlimited Strength enabled?", e);
        }
    }

    private DigipostSecurity() {
    }

    static {
        DigipostSecurity.ensureSecurityProvider();
    }
}

